/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mbsa.cstepper;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMStepper;
import com.dassault.cecilia.core.plugin.PluginMTranslate;
import com.dassault.cecilia.core.plugin.PluginModel;
import com.dassault.cecilia.core.plugin.Translator;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.plugin.mbsa.cstepper.ResCStep;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class PluginInference
extends AbstractPluginModel {
    protected boolean _displayMsg = true;
    private static final String TRANSLATOR = "com.dassault.cecilia.plugin.mbsa.translator.TranslatePluginGeneric";
    protected static final String DEPEND_STEP = "com.dassault.cecilia.plugin.mbsa.cstepper.opt.PluginStepperInference";

    protected PluginInference() {
    }

    protected PluginModel verifyPluginTranslator(Plugable launcher) {
        PluginModel plugTrans = launcher.getPlugin(TRANSLATOR);
        if (plugTrans == null || !(plugTrans instanceof PluginMTranslate)) {
            if (this._displayMsg) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResCStep.getString("ERR_PLUG_TRANSLATE") + "\n   [" + TRANSLATOR + "]", ResCStep.getString("DEF_TITLE"), 0);
            }
            return null;
        }
        return plugTrans;
    }

    protected Translator createTranslator(Plugable launcher) {
        PluginModel plugTrans = this.verifyPluginTranslator(launcher);
        if (plugTrans == null) {
            return null;
        }
        Translator trans = ((PluginMTranslate)plugTrans).createTranslator(launcher, null);
        if (trans == null) {
            if (this._displayMsg) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResCStep.getString("ERR_TRANSLATOR"), ResCStep.getString("DEF_TITLE"), 0);
            }
            return null;
        }
        return trans;
    }

    protected File createFile(Plugable launcher) {
        return this.createFile(launcher, "CStepper", ".alt");
    }

    protected void displayError(Plugable launcher, Translator trans, StepperException exc) {
        Matcher match;
        if (!this._displayMsg) {
            return;
        }
        int line = -1;
        String mess = exc.getMessage();
        Pattern pattern = Pattern.compile("^(\\p{Alpha}:)?[^:]+:\\s*([0-9]+)\\s*:\\s*([.\n]*)");
        if (pattern != null && (match = pattern.matcher(mess)).find()) {
            String str = match.group(2);
            line = Integer.parseInt(str);
            mess = mess.substring(match.start(3));
        }
        if (trans == null || line == -1) {
            if (mess.length() > 80) {
                JTextArea ctrlMess = new JTextArea();
                ctrlMess.setLineWrap(true);
                ctrlMess.setWrapStyleWord(false);
                ctrlMess.setEditable(false);
                ctrlMess.setText(mess);
                JScrollPane scrMess = new JScrollPane(ctrlMess);
                scrMess.setPreferredSize(new Dimension(400, 200));
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), scrMess, ResCStep.getString("DEF_TITLE"), 0);
            } else {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), mess, ResCStep.getString("DEF_TITLE"), 0);
            }
        } else {
            trans.displayOriginalLine(line, mess, ResCStep.getString("DEF_TITLE"));
        }
    }

    protected Stepper createBanStepper(Plugable launcher) {
        PluginModel plugin = launcher.getPlugin(DEPEND_STEP);
        if (plugin == null || !(plugin instanceof PluginMStepper)) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)launcher.getWindow()), ResCStep.getString("ERR_DEPEND_STEPPER") + "\n   [" + DEPEND_STEP + "]");
            return null;
        }
        return ((PluginMStepper)plugin).createStepper(launcher, null);
    }
}

