/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util;

import java.math.BigInteger;

public class CryptUtility {
    static final String DATA_MASK = "kmepogaujbfw";
    static final String DISK_MASK = "bwosklertiufj";

    public static String cryptData(String data) {
        return CryptUtility.cryptData(data, DATA_MASK);
    }

    public static String cryptData(String data, String cryptMask) {
        String result = new String("");
        String mask = new String("");
        while (mask.length() < data.length()) {
            mask = mask.concat(cryptMask);
        }
        mask = mask.substring(0, data.length());
        int dataLength = data.length();
        char[] dataChar = data.toCharArray();
        char[] maskChar = mask.toCharArray();
        for (int i = 0; i < dataLength; ++i) {
            result = result + CryptUtility.cryptOneCar(dataChar[i], CryptUtility.getBigInteger(maskChar[i]));
        }
        return result;
    }

    private static String cryptOneCar(char c, BigInteger charData) {
        BigInteger cBi = CryptUtility.getBigInteger(c);
        BigInteger resultBi = cBi.xor(charData);
        return CryptUtility.getHexaValue(Integer.parseInt(resultBi.toString()));
    }

    public static String decryptData(String data) {
        return CryptUtility.decryptData(data, DATA_MASK);
    }

    public static String decryptData(String data, String cryptMask) {
        if (data == null) {
            return "";
        }
        String result = new String();
        int dataLength = data.length() / 2;
        String mask = new String("");
        while (mask.length() < dataLength) {
            mask = mask.concat(cryptMask);
        }
        mask = mask.substring(0, dataLength);
        char[] maskChar = mask.toCharArray();
        int j = 0;
        for (int i = 0; i < dataLength; ++i) {
            int dataInt = CryptUtility.getIntValue(data.substring(j, j + 2));
            result = result + CryptUtility.decryptOneCar(dataInt, CryptUtility.getBigInteger(maskChar[i]));
            j += 2;
        }
        return result;
    }

    private static String decryptOneCar(int c, BigInteger charData) {
        BigInteger cBi = new BigInteger("" + c);
        BigInteger resultBi = cBi.xor(charData);
        return "" + (char)resultBi.intValue();
    }

    private static BigInteger getBigInteger(char c) {
        BigInteger bi = new BigInteger(String.valueOf((int)c));
        return bi;
    }

    private static String getHexaValue(int value) {
        int firstValue = value / 16;
        int secondValue = value - firstValue * 16;
        String result = new String(CryptUtility.intToHexa(firstValue) + CryptUtility.intToHexa(secondValue));
        return result;
    }

    private static int getIntValue(String value) {
        char[] valueTab = value.toCharArray();
        return CryptUtility.hexaToInt("" + valueTab[0]) * 16 + CryptUtility.hexaToInt("" + valueTab[1]);
    }

    private static int hexaToInt(String valeur) {
        switch (valeur.toCharArray()[0]) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return Integer.parseInt(valeur);
            }
            case 'A': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'F': {
                return 15;
            }
            case 'G': {
                return 16;
            }
            case 'H': {
                return 17;
            }
            case 'I': {
                return 18;
            }
            case 'J': {
                return 19;
            }
            case 'K': {
                return 20;
            }
            case 'L': {
                return 21;
            }
            case 'M': {
                return 22;
            }
            case 'N': {
                return 23;
            }
        }
        return -1;
    }

    private static String intToHexa(int valeur) {
        switch (valeur) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return "" + valeur;
            }
            case 10: {
                return "A";
            }
            case 11: {
                return "B";
            }
            case 12: {
                return "C";
            }
            case 13: {
                return "D";
            }
            case 14: {
                return "E";
            }
            case 15: {
                return "F";
            }
            case 16: {
                return "G";
            }
            case 17: {
                return "H";
            }
            case 18: {
                return "I";
            }
            case 19: {
                return "J";
            }
            case 20: {
                return "K";
            }
            case 21: {
                return "L";
            }
            case 22: {
                return "M";
            }
            case 23: {
                return "N";
            }
        }
        return "";
    }
}

