/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util;

import com.dassault.cecilia.lib.util.io.CRCWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

public class MacAdressUtility {
    public static final String PROP_LICENSE_MACNAME = "cecilia.core.LicenseName";
    private static final boolean LICENSE_MAC_WITH_NAME = Boolean.getBoolean("cecilia.core.LicenseName");

    public static void main(String[] args) {
        try {
            System.out.println(MacAdressUtility.readMACAddressWithIPConfig());
            System.out.println(MacAdressUtility.getMACAddressWithJava6());
            System.out.println(MacAdressUtility.getMACAddressWithName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getMACAddress() throws Exception {
        if (LICENSE_MAC_WITH_NAME) {
            return MacAdressUtility.getMACAddressWithName();
        }
        return MacAdressUtility.getMACAddressWithJava6();
    }

    private static String getMACAddressWithName() throws Exception {
        String name = InetAddress.getLocalHost().getHostName();
        CRCWriter writer = new CRCWriter(new StringWriter());
        writer.write(name);
        writer.close();
        return writer.getMAC();
    }

    private static String getMACAddressWithJava6() throws Exception {
        StringBuffer result = new StringBuffer(256);
        Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
        while (networks.hasMoreElements()) {
            NetworkInterface network = networks.nextElement();
            byte[] mac = network.getHardwareAddress();
            if (mac == null || mac.length != 6) continue;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            if (result.length() > 0) {
                result.append(";");
            }
            result.append(sb.toString());
        }
        if (result.length() == 0) {
            throw new IOException("No Mac address");
        }
        return result.toString();
    }

    private static String readMACAddressWithIPConfig() throws Exception {
        Collection<String> lines = MacAdressUtility.exec("ipconfig /all", false);
        StringBuffer MACAddresses = new StringBuffer();
        String MACAddress = null;
        Iterator<String> iter = lines.iterator();
        while (iter.hasNext()) {
            MACAddress = MacAdressUtility.parseMACLine(iter.next());
            if (MACAddress == null) continue;
            MACAddresses.append(MACAddress);
            MACAddresses.append(';');
        }
        if (MACAddresses.length() != 0) {
            MACAddresses.deleteCharAt(MACAddresses.length() - 1);
        }
        return MACAddresses.toString();
    }

    private static Collection<String> exec(String cmd, boolean pressAnyKey) throws IOException {
        final ArrayList<String> lines = new ArrayList<String>(10);
        Process proc = Runtime.getRuntime().exec(cmd);
        if (pressAnyKey) {
            OutputStreamWriter writer = new OutputStreamWriter(proc.getOutputStream());
            writer.write(" \n");
            ((Writer)writer).close();
        }
        final BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        lines.add(line);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        };
        thread.start();
        try {
            while (thread.isAlive()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return lines;
    }

    private static String parseMACLine(String line) {
        String MACAddress = null;
        char[] chars = line.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!MacAdressUtility.isHexChar(chars[i]) || (MACAddress = MacAdressUtility.parseMACAddress(chars, i)) == null) continue;
            return MACAddress;
        }
        return null;
    }

    private static String parseMACAddress(char[] chars, int offset) {
        if (chars.length - offset - 1 < 16) {
            return null;
        }
        if (!MacAdressUtility.isHexChar(chars[offset + 0])) {
            return null;
        }
        if (!MacAdressUtility.isHexChar(chars[offset + 1])) {
            return null;
        }
        if (chars[offset + 2] != '-') {
            return null;
        }
        if (!MacAdressUtility.isHexChar(chars[offset + 3])) {
            return null;
        }
        if (!MacAdressUtility.isHexChar(chars[offset + 4])) {
            return null;
        }
        if (chars[offset + 5] != '-') {
            return null;
        }
        if (!MacAdressUtility.isHexChar(chars[offset + 6])) {
            return null;
        }
        if (!MacAdressUtility.isHexChar(chars[offset + 7])) {
            return null;
        }
        if (chars[offset + 8] != '-') {
            return null;
        }
        if (!MacAdressUtility.isHexChar(chars[offset + 9])) {
            return null;
        }
        if (!MacAdressUtility.isHexChar(chars[offset + 10])) {
            return null;
        }
        if (chars[offset + 11] != '-') {
            return null;
        }
        if (!MacAdressUtility.isHexChar(chars[offset + 12])) {
            return null;
        }
        if (!MacAdressUtility.isHexChar(chars[offset + 13])) {
            return null;
        }
        if (chars[offset + 14] != '-') {
            return null;
        }
        if (!MacAdressUtility.isHexChar(chars[offset + 15])) {
            return null;
        }
        if (!MacAdressUtility.isHexChar(chars[offset + 16])) {
            return null;
        }
        return new String(chars, offset, 17);
    }

    private static boolean isHexChar(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }
}

