/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.diff;

import com.dassault.cecilia.lib.util.diff.DiffFile;
import com.dassault.cecilia.lib.util.diff.DiffRecord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;

public class DiffFileLine
extends DiffFile {
    boolean _compareNoCase = false;
    boolean _ignoreBlankChar = false;
    boolean _ignoreBlankLine = false;
    String _ignoreAfterChar = "";
    int _ignoreHeaderLine = 0;

    public DiffFileLine(File input, File output) {
        super(input, output);
    }

    public DiffFileLine(File input, File output, String ignoreAfterChar) {
        super(input, output);
        this._ignoreAfterChar = ignoreAfterChar;
        this._ignoreBlankChar = true;
    }

    public boolean isCompareNoCase() {
        return this._compareNoCase;
    }

    public void setCompareNoCase(boolean value) {
        this._compareNoCase = value;
    }

    public boolean isIgnoreBlankChar() {
        return this._ignoreBlankChar;
    }

    public void setIgnoreBlankChar(boolean value) {
        this._ignoreBlankChar = value;
    }

    public boolean isIgnoreBlankLine() {
        return this._ignoreBlankLine;
    }

    public void setIgnoreBlankLine(boolean value) {
        this._ignoreBlankLine = value;
    }

    public boolean isIgnoreAfterChar() {
        return this._ignoreAfterChar.length() > 0;
    }

    public void setIgnoreAfterChar(String str) {
        this._ignoreAfterChar = str;
    }

    public void setIgnoreHeaderLine(int nbrLine) {
        this._ignoreHeaderLine = nbrLine;
    }

    private String convert(String line) {
        if (line == null) {
            return line;
        }
        if (this.isIgnoreAfterChar()) {
            int end = -1;
            for (int i = 0; i < this._ignoreAfterChar.length(); ++i) {
                int pos = line.indexOf(this._ignoreAfterChar.charAt(i));
                if (pos < 0) continue;
                if (end == -1) {
                    end = pos;
                    continue;
                }
                if (pos >= end) continue;
                end = pos;
            }
            if (end != -1) {
                line = line.substring(0, end);
            }
        }
        if (this._ignoreBlankChar) {
            StringBuffer sb = new StringBuffer(line.length());
            int flag = 78;
            for (int i = 0; i < line.length(); ++i) {
                char cur = line.charAt(i);
                if (cur == '\r') continue;
                if (cur == ' ' || cur == '\t') {
                    if (flag != 70) continue;
                    flag = 84;
                    continue;
                }
                if (flag == 84) {
                    sb.append(' ');
                }
                flag = 70;
                sb.append(cur);
            }
            line = sb.toString();
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compare() throws IOException {
        BufferedReader in = null;
        BufferedReader out = null;
        IOException exc = null;
        try {
            String lineIn;
            int i;
            in = new LineNumberReader(new FileReader(this._input1));
            out = new BufferedReader(new FileReader(this._input2));
            for (i = 0; i < this._ignoreHeaderLine; i += 1) {
                lineIn = ((LineNumberReader)in).readLine();
                if (lineIn != null) continue;
                this.addRecord(new DiffRecord(i, "Empty header line"));
                break;
            }
            while (!this.withDiff()) {
                String lineOut;
                while ((lineIn = this.convert(((LineNumberReader)in).readLine())) != null && this._ignoreBlankLine && lineIn.length() == 0) {
                }
                while ((lineOut = this.convert(out.readLine())) != null && this._ignoreBlankLine && lineOut.length() == 0) {
                }
                if (lineIn == null && lineOut == null) break;
                if (lineIn == null) {
                    this.addRecord(new DiffRecord(((LineNumberReader)in).getLineNumber()).setMsg1("EOF " + this._input1.getCanonicalPath()));
                    continue;
                }
                if (lineOut == null) {
                    this.addRecord(new DiffRecord(((LineNumberReader)in).getLineNumber()).setMsg2("EOF " + this._input2.getCanonicalPath()));
                    continue;
                }
                if (this._compareNoCase) {
                    if (lineIn.equalsIgnoreCase(lineOut)) continue;
                    this.addRecord(new DiffRecord(((LineNumberReader)in).getLineNumber(), "Line Diff : ").setMsg1(lineIn).setMsg2(lineOut));
                    continue;
                }
                if (lineIn.equals(lineOut)) continue;
                this.addRecord(new DiffRecord(((LineNumberReader)in).getLineNumber(), "Line Diff : ").setMsg1(lineIn).setMsg2(lineOut));
            }
            i = !this.withDiff() ? 1 : 0;
            return i != 0;
        }
        catch (IOException e) {
            if (exc == null) {
                exc = e;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            block29: {
                block28: {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            if (exc != null) break block28;
                            exc = e;
                        }
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        if (exc != null) break block29;
                        exc = e;
                    }
                }
            }
            this.close();
            if (exc != null) {
                throw exc;
            }
        }
    }
}

