/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.diff;

import com.dassault.cecilia.lib.util.destination.Layout;
import com.dassault.cecilia.lib.util.destination.Record;
import com.dassault.cecilia.lib.util.diff.DiffRecDefine;
import com.dassault.cecilia.lib.util.diff.DiffRecord;
import java.util.Map;

public class DiffLayoutSimple
extends Layout {
    boolean _displayHeader = true;

    @Override
    public String format(Record rec) {
        if (rec instanceof DiffRecord) {
            String msg;
            DiffRecord record = (DiffRecord)rec;
            StringBuffer sb = new StringBuffer(128);
            int line = record.getLine();
            if (line >= 0) {
                sb.append("[Line : ");
                sb.append(line);
                sb.append("] ");
            }
            if ((msg = record.getHeader()) != null && msg.length() > 0) {
                sb.append(msg);
                sb.append("\n");
            }
            if ((msg = record.getMsg1()) != null) {
                sb.append(">> ");
                sb.append(msg);
                sb.append("\n");
            }
            if ((msg = record.getMsg2()) != null) {
                sb.append("<< ");
                sb.append(msg);
                sb.append("\n");
            }
            if (sb.length() == 0) {
                sb.append(record);
            }
            return sb.toString();
        }
        if (rec instanceof DiffRecDefine) {
            DiffRecDefine define;
            String msg;
            if (this._displayHeader && (msg = (define = (DiffRecDefine)rec).getHeader()) != null) {
                StringBuffer sb = new StringBuffer(128);
                sb.append(msg);
                sb.append(" :\n");
                String stream = define.getDesc1();
                if (stream != null) {
                    sb.append("<  ");
                    sb.append(stream);
                    sb.append("\n");
                }
                if ((stream = define.getDesc2()) != null) {
                    sb.append(">  ");
                    sb.append(stream);
                    sb.append("\n");
                }
                sb.append("\n");
                return sb.toString();
            }
        } else {
            throw new RuntimeException("Record unknow");
        }
        return "";
    }

    @Override
    public void configure(Map<String, String> params) {
        String header = params.get("Header");
        if (header != null) {
            this._displayHeader = Boolean.parseBoolean(header);
        }
    }
}

