/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.format;

import com.dassault.cecilia.lib.util.format.DoubleFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DoubleFormatUtility
implements DoubleFormat {
    protected int _limit;
    protected DecimalFormat _number;
    protected DecimalFormat _scienc;

    public DoubleFormatUtility() {
        this(6, 6);
    }

    public DoubleFormatUtility(int limit, int precision) {
        DecimalFormatSymbols _symbol = new DecimalFormatSymbols(Locale.ENGLISH);
        this._number = new DecimalFormat("0.##", _symbol);
        this.setLimit(limit);
        this.setPrecision(precision);
    }

    public void setLimit(int limit) {
        this._limit = limit;
    }

    public int getLimit() {
        return this._limit;
    }

    public void setPrecision(int precision) {
        this._number.setMaximumFractionDigits(precision);
        DecimalFormatSymbols _symbol = new DecimalFormatSymbols(Locale.ENGLISH);
        StringBuilder pattern = new StringBuilder(precision + 10);
        pattern.append("0.");
        while (precision-- > 0) {
            pattern.append("0");
        }
        pattern.append("E00");
        this._scienc = new DecimalFormat(pattern.toString(), _symbol);
        this._scienc.setDecimalSeparatorAlwaysShown(true);
    }

    public int getPrecision() {
        return this._number.getMaximumFractionDigits();
    }

    @Override
    public String format(double val) {
        String result = null;
        double v = val;
        if (v < 0.0) {
            v *= -1.0;
        }
        if ((result = v == 0.0 ? this._number.format(v) : (this._limit == 0 || v > Math.pow(10.0, this._limit) || v < Math.pow(0.1, this._limit) ? this._scienc.format(v) : this._number.format(v))).equals("0") && v != 0.0) {
            result = this._scienc.format(v);
        }
        if (val < 0.0) {
            return "-" + result;
        }
        return result;
    }

    public static void main(String[] args) {
        DoubleFormatUtility df = new DoubleFormatUtility(3, 6);
        System.out.println(df.format(0.0));
        System.out.println(df.format(-0.0));
        System.out.println(df.format(1.0E-4));
        System.out.println(df.format(0.001));
        System.out.println(df.format(-1.0));
        System.out.println(df.format(100.0));
        System.out.println(df.format(999.0));
        System.out.println(df.format(1000.0));
        System.out.println(df.format(1001.0));
        System.out.println(df.format(100000.0));
        System.out.println(df.format(0.12345678901234568));
        System.out.println(df.format(10000.123456789011));
        System.out.println(df.format(1.2345678901234567E-8));
        System.out.println(df.format(0.0012345678901234567));
        df = new DoubleFormatUtility(3, 2);
        System.out.println(df.format(0.001458368246979537));
        df = new DoubleFormatUtility(3, 3);
        System.out.println(df.format(0.001458368246979537));
        df = new DoubleFormatUtility(3, 4);
        System.out.println(df.format(0.001458368246979537));
        System.exit(0);
    }
}

