/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.format;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtilities {
    private static Map<String, String> __XMLCodeToChar = new HashMap<String, String>();
    private static Pattern __XMLCode;

    public static String escapeCR(String str) {
        if (str == null) {
            return "";
        }
        char[] charArray = str.toCharArray();
        StringBuilder buf = new StringBuilder(str.length() + 64);
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] == '\n') {
                buf.append('\\').append('n');
                continue;
            }
            if (charArray[i] == '\\') {
                buf.append('\\').append('\\');
                continue;
            }
            buf.append(charArray[i]);
        }
        return buf.toString();
    }

    public static String convertToHTML(String str) {
        if (str == null) {
            return "";
        }
        char[] charArray = str.toCharArray();
        StringBuilder buf = new StringBuilder(str.length() + 64);
        buf.append("<html>");
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] == '\n') {
                buf.append("<br>");
                continue;
            }
            buf.append(charArray[i]);
        }
        buf.append("</html>");
        return buf.toString();
    }

    public static String STR(String ... strs) {
        if (strs.length == 0) {
            return "";
        }
        if (strs.length == 1) {
            return strs[0];
        }
        int length = 10;
        for (int i = strs.length - 1; i >= 0; --i) {
            length += strs[i].length();
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < strs.length; ++i) {
            sb.append(strs[i]);
        }
        return sb.toString();
    }

    public static byte[] convertHexaStringToByte(String hexa) {
        if (hexa.length() % 2 != 0) {
            return null;
        }
        byte[] result = new byte[hexa.length() / 2];
        for (int i = 0; i < hexa.length() / 2; ++i) {
            result[i] = (byte)Integer.parseInt(hexa.substring(i * 2, i * 2 + 2), 16);
        }
        return result;
    }

    public static String convertByteToHexaString(byte[] code) {
        StringBuilder sb = new StringBuilder(code.length * 2);
        for (int i = 0; i < code.length; ++i) {
            String hexa = Integer.toHexString(code[i]);
            if (hexa.length() > 2) {
                sb.append(hexa.substring(hexa.length() - 2));
                continue;
            }
            if (hexa.length() == 1) {
                sb.append("0");
            }
            sb.append(hexa);
        }
        return sb.toString();
    }

    public static Vector<SearchString> buildTabSearchString(String searchString) {
        Vector<SearchString> listSearchString = new Vector<SearchString>();
        char[] searchBuffer = searchString.toCharArray();
        boolean before = false;
        boolean after = false;
        String searchSubString = new String("");
        for (int i = 0; i < searchBuffer.length; ++i) {
            if (searchBuffer[i] == '*') {
                if (!before) {
                    if (!searchSubString.equals("")) {
                        after = true;
                        listSearchString.add(new SearchString(searchSubString, before, after));
                        searchSubString = new String("");
                        after = false;
                    }
                    before = true;
                    continue;
                }
                if (searchSubString.equals("")) continue;
                after = true;
                listSearchString.add(new SearchString(searchSubString, before, after));
                searchSubString = new String("");
                after = false;
                continue;
            }
            searchSubString = new String(searchSubString + searchBuffer[i]);
        }
        if (!searchSubString.equals("")) {
            listSearchString.add(new SearchString(searchSubString, before, after));
            searchSubString = new String("");
        } else if (listSearchString.size() == 0) {
            listSearchString.add(new SearchString("", true, false));
        }
        return listSearchString;
    }

    public static boolean isASearchEvent(String eventName, List<SearchString> tabSearchString) {
        String localEventName = new String(eventName);
        boolean before = false;
        for (SearchString searchString : tabSearchString) {
            int position;
            if (searchString.getValue().equals("") && searchString.isStringBefore()) {
                return true;
            }
            if (searchString.isStringAfter()) {
                position = localEventName.indexOf(searchString.getValue());
                if (position == -1) {
                    return false;
                }
                if (!searchString.isStringBefore() && (before || position != 0)) {
                    return false;
                }
            } else {
                position = localEventName.lastIndexOf(searchString.getValue());
                if (position == -1) {
                    return false;
                }
                if (!searchString.isStringBefore() && (before || position != 0)) {
                    return false;
                }
                if (position + searchString.getValue().length() < localEventName.length()) {
                    return false;
                }
            }
            localEventName = localEventName.substring(position + searchString.getValue().length());
            before = true;
        }
        return true;
    }

    public static List<String> splitWordsLimitedWidth(String msg, int maxCar) {
        ArrayList<String> result = new ArrayList<String>();
        int len = 0;
        StringBuilder buffer = new StringBuilder();
        StringTokenizer st = new StringTokenizer(msg, " \n", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.contains("\n")) {
                result.add(buffer.toString());
                buffer = new StringBuilder();
                len = 0;
                continue;
            }
            int tokLen = tok.length();
            if (len == 0) {
                if (tokLen > maxCar) {
                    result.add(tok);
                    continue;
                }
                buffer.append(tok);
                len += tokLen;
                continue;
            }
            if (tokLen + len <= maxCar) {
                buffer.append(tok);
                len += tokLen;
                continue;
            }
            result.add(buffer.toString());
            buffer = new StringBuilder();
            len = 0;
            if (tok.contains(" ")) continue;
            if (tokLen > maxCar) {
                result.add(tok);
                continue;
            }
            buffer.append(tok);
            len += tokLen;
        }
        if (len > 0) {
            result.add(buffer.toString());
        }
        return result;
    }

    public static String convertFromXML(String txt) {
        StringBuilder buffer = new StringBuilder(txt.length());
        Matcher matcher = __XMLCode.matcher(txt);
        int pos = 0;
        while (matcher.find(pos)) {
            int start = matcher.start();
            if (start > pos) {
                buffer.append(txt.substring(pos, start));
            }
            buffer.append(__XMLCodeToChar.get(matcher.group(1)));
            pos = matcher.end();
        }
        if (pos < txt.length()) {
            buffer.append(txt.substring(pos));
        }
        return buffer.toString();
    }

    public static String convertToXML(String txt) {
        int len = txt.length();
        StringBuilder buffer = new StringBuilder(len + 32);
        block7: for (int i = 0; i < len; ++i) {
            switch (txt.charAt(i)) {
                case '\"': {
                    buffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    buffer.append("&apos;");
                    continue block7;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block7;
                }
                case '<': {
                    buffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block7;
                }
                default: {
                    buffer.append(txt.charAt(i));
                }
            }
        }
        return buffer.toString();
    }

    static {
        __XMLCodeToChar.put("quot", "\"");
        __XMLCodeToChar.put("amp", "&");
        __XMLCodeToChar.put("apos", "'");
        __XMLCodeToChar.put("lt", "<");
        __XMLCodeToChar.put("gt", ">");
        __XMLCode = Pattern.compile("&(quot|amp|apos|lt|gt);");
    }

    public static class SearchString {
        private String _value;
        private boolean _before;
        private boolean _after;

        public SearchString(String value, boolean before, boolean after) {
            this._value = new String(value);
            this._before = before;
            this._after = after;
        }

        public String getValue() {
            return this._value;
        }

        public boolean isStringBefore() {
            return this._before;
        }

        public boolean isStringAfter() {
            return this._after;
        }
    }
}

