/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.loader;

import com.dassault.cecilia.lib.util.loader.JarResources;
import com.dassault.cecilia.lib.util.loader.MultiClassLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;

public class JarClassLoader
extends MultiClassLoader {
    private JarResources _jarResources;

    public JarClassLoader(String jarName, ClassLoader parent) {
        super(parent);
        this._jarResources = new JarResources(jarName);
    }

    public JarClassLoader(InputStream jarStream, ClassLoader parent) {
        super(parent);
        this._jarResources = new JarResources(jarStream);
    }

    public Manifest getManifest() {
        return this._jarResources.getManifest();
    }

    @Override
    protected byte[] loadClassBytes(String className) {
        className = this.formatClassName(className);
        return this._jarResources.getResource(className);
    }

    @Override
    public URL findResource(String name) {
        byte[] res = this._jarResources.getResource(name);
        if (res != null) {
            return this._jarResources.getURLAccess(name);
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        byte[] res = this._jarResources.getResource(name);
        if (res != null) {
            return new ByteArrayInputStream(res);
        }
        return super.getResourceAsStream(name);
    }
}

