/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class UtilFormatter
extends SimpleFormatter {
    Date dat = new Date();
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String format = "{0,date,yyyy-MM-dd HH:mm:ss.SSS}";
    private final MessageFormat formatter = new MessageFormat("{0,date,yyyy-MM-dd HH:mm:ss.SSS}");
    private Object[] args = new Object[1];

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        this.dat.setTime(record.getMillis());
        this.args[0] = this.dat;
        StringBuffer textDate = new StringBuffer();
        this.formatter.format(this.args, textDate, (FieldPosition)null);
        sb.append(textDate);
        sb.append(String.format(" %1$7s [%2$s] %3$s : ", record.getLevel(), Thread.currentThread().getName().trim(), record.getLoggerName()));
        sb.append(this.formatMessage(record));
        sb.append(lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

