/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mcs;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMTreatment;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.plugin.mcs.MCSDiffParameters;
import com.dassault.cecilia.plugin.mcs.ResMCS;
import java.net.URL;
import javax.swing.Icon;

public class TreatmentMCSDiff
extends AbstractPluginModel
implements PluginMTreatment {
    public boolean withOption(Plugable plugable) {
        return false;
    }

    public boolean withParameters() {
        return true;
    }

    public Object getDefaultParameters(PluginManager plugable) {
        return new MCSDiffParameters();
    }

    public Object changeParameters(PluginManager parent, Object parameters) {
        MCSDiffParameters clone = new MCSDiffParameters((MCSDiffParameters)parameters);
        if (clone.change(parent)) {
            return clone;
        }
        return parameters;
    }

    public IOParameters getIOParameters() {
        return MCSDiffParameters.getIOParameters();
    }

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResMCS.getString("TREAT_DIFF_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResMCS.getString("TREAT_DIFF_DESC");
        }
        if (key.equals("plugin.parameterTag")) {
            return "mcsdiff-treatment";
        }
        if (key.equals("type")) {
            return "PluginTreatment";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("B-06.svg"));
        }
        return super.getIcon(key);
    }

    public String writeDefine(Plugable launcher, Object parameters) {
        if (parameters == null || !(parameters instanceof MCSDiffParameters)) {
            return null;
        }
        MCSDiffParameters params = (MCSDiffParameters)parameters;
        StringBuffer sb = new StringBuffer(128);
        sb.append("      <set name='mcsdiff.result' global='false'> <mcsdiff");
        sb.append(" src1file='").append(params.getSrc1File()).append("'");
        sb.append(" src2file='").append(params.getSrc2File()).append("'");
        sb.append(">\n");
        if (params.getTrace()) {
            sb.append("        <destination file='%{log.path}'>\n");
            sb.append("          <param name='Append' value='true'/>\n");
            sb.append("          <layout name='%{log.format}'/>\n");
            sb.append("        </destination>\n");
        } else {
            sb.append("        <destination name='null'/>\n");
        }
        sb.append("      </mcsdiff> </set>");
        if (params.getFailure()) {
            sb.append("      <fail message='MCSDiff Failure'> <not>\n");
            sb.append("        <get name='mcsdiff.result'/> </not> </fail>");
        }
        return sb.toString();
    }

    public String writeCommand(Plugable launcher, Object parameters) {
        return null;
    }
}

