/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.seqconvert;

import com.dassault.cecilia.plugin.seqconvert.Event;
import java.util.ArrayList;

public class Sequence {
    private int nbEvents;
    private Event[] events;

    public Sequence(Event[] evts) {
        this.nbEvents = evts.length;
        this.events = new Event[this.nbEvents];
        for (int i = 0; i < this.nbEvents; ++i) {
            this.events[i] = evts[i];
        }
    }

    public int getNbEvents() {
        return this.nbEvents;
    }

    public Event getEvent(int index) {
        try {
            return this.events[index];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Event[] getEvents() {
        return this.events;
    }

    public Event[] filter(Event[] eventsToFilter) {
        ArrayList<Event> listEvents = new ArrayList<Event>(0);
        for (int i = 0; i < this.nbEvents; ++i) {
            boolean exist = false;
            for (int j = 0; j < eventsToFilter.length; ++j) {
                if (!this.events[i].isEqualTo(eventsToFilter[j])) continue;
                exist = true;
            }
            if (exist) continue;
            listEvents.add(this.events[i]);
        }
        Event[] retEvents = listEvents.toArray(new Event[listEvents.size()]);
        return retEvents;
    }

    public Event[] removeRedundantEvents() {
        ArrayList<Event> listEvents = new ArrayList<Event>(0);
        for (int i = 0; i < this.nbEvents; ++i) {
            boolean exist = false;
            for (int j = i + 1; j < this.nbEvents; ++j) {
                if (!this.events[i].isEqualTo(this.events[j])) continue;
                exist = true;
            }
            if (exist) continue;
            listEvents.add(this.events[i]);
        }
        Event[] retEvents = listEvents.toArray(new Event[listEvents.size()]);
        return retEvents;
    }

    public boolean isEqualTo(Sequence s) {
        if (this.nbEvents != s.nbEvents) {
            return false;
        }
        for (int i = 0; i < this.nbEvents; ++i) {
            if (this.events[i].isEqualTo(s.events[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isEquivalent(Sequence s) {
        if (this.nbEvents != s.nbEvents) {
            return false;
        }
        for (int i = 0; i < s.nbEvents; ++i) {
            if (this.contains(s.events[i])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Event e) {
        for (int i = 0; i < this.nbEvents; ++i) {
            if (!this.events[i].isEqualTo(e)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Sequence s) {
        if (s.nbEvents > this.nbEvents) {
            return false;
        }
        for (int i = 0; i < s.nbEvents; ++i) {
            boolean contains = false;
            for (int j = 0; j < this.nbEvents; ++j) {
                if (!this.events[j].isEqualTo(s.events[i])) continue;
                contains = true;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    public boolean isContainedIn(Sequence s) {
        if (this.nbEvents > s.nbEvents) {
            return false;
        }
        for (int i = 0; i < this.nbEvents; ++i) {
            boolean contains = false;
            for (int j = 0; j < s.nbEvents; ++j) {
                if (!s.events[j].isEqualTo(this.events[i])) continue;
                contains = true;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }
}

