/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.migration.db51to60;

import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.LaunchIniReader;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBGlobEvent;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.dao.sql.SQLConnection;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.CeciliaFactory;
import com.dassault.cecilia.dbobj.ResMsgObj;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.general.log.DBLogs;
import com.dassault.cecilia.dbobj.mbsa.node.AltaNode;
import com.dassault.cecilia.dbobj.mbsa.operator.AltaOperatorRef;
import com.dassault.cecilia.dbobj.mbsa.operator.OperatorDictionary;
import com.dassault.cecilia.dbobj.project.DBProject;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.migration.db51to60.ThreadSuperviseur;
import java.awt.Image;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class FlowsUpdate
extends CAppl
implements ThreadSuperviseur.Informateur {
    private static Logger _LOG = Logger.getLogger(FlowsUpdate.class.getPackage().getName());
    String[] _argsMain;
    public static final String PROP_UPDATE_SESSION_DISABLE = "cecilia.migration.db51to60.UpdateSessionDisable";
    DBFolder _lastConvert = null;
    public static final String PROP_SUPERVISOR_PERIOD = "cecilia.migration.db51to60.SupervisorPeriod";

    public FlowsUpdate(String[] args) {
        this._argsMain = args;
    }

    @Override
    public String getTitle() {
        return "Migration tools";
    }

    @Override
    public ImageIcon getSplashIcon() {
        return null;
    }

    @Override
    public List<? extends Image> getIcons() {
        return null;
    }

    @Override
    public CECFactory getDAOFactory() {
        return (CECFactory)this._daoFactory;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean standardDatabaseConnection() {
        if (this._argsMain != null && this._argsMain.length > 0) {
            SQLConnection sqlConnect;
            String connect = this._argsMain[0];
            SQLConnection.DBType dbType = SQLConnection.findDBType(connect);
            if (dbType == null) {
                _LOG.severe("Le type de la connexion \u00e0 la base de donn\u00e9es n'a pas \u00e9t\u00e9 trouv\u00e9: " + connect);
                return false;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("db.connect.set", connect);
            if (this._argsMain.length > 1) {
                properties.put("db.srv.user", this._argsMain[1]);
            }
            if (this._argsMain.length > 2) {
                properties.put("db.srv.password", this._argsMain[2]);
            }
            if (!this.createConnection(sqlConnect = new SQLConnection(dbType, properties), false)) {
                _LOG.severe("La connexion n'a pas pu \u00eatre cr\u00e9\u00e9e: " + connect);
                return false;
            }
            this._sqlConnect = sqlConnect;
        } else if (!super.standardDatabaseConnection()) {
            return false;
        }
        this._daoFactory = new CeciliaFactory(this, this._daoFactory);
        return true;
    }

    @Override
    public boolean verifyLicense(StringBuffer msgLicense) {
        return true;
    }

    @Override
    public String getModuleName() {
        return "MIGRATE";
    }

    @Override
    public String getInfo() {
        DBFolder lastConvert = this._lastConvert;
        if (lastConvert == null) {
            return "No start convertion !";
        }
        return "Last DBFolder convertion: " + lastConvert.getRefPath();
    }

    private void doConvert_rec(DBFolder dbFolder, ConvertTool tool) {
        tool.convert(dbFolder);
        if (!dbFolder.isVersion()) {
            List<DBFolder> children = dbFolder.getChildren();
            if (children == null) {
                children = this.getDAOFactory().createFolderDAO().findChildren(dbFolder);
            }
            for (DBFolder dbChild : children) {
                this.doConvert_rec(dbChild, tool);
            }
        }
    }

    private int doUpdate(DBFolder.Family family, String title, ConvertTool tool) {
        int nbrError = 0;
        int nbrFatal = 0;
        DBFolder dbRoot = this.getDAOFactory().createFolderDAO().getRootID(family.getRootName());
        if (dbRoot == null) {
            _LOG.severe("Pas de folder root pour " + (Object)((Object)family));
            ++nbrFatal;
        } else {
            _LOG.info("Debut de la mise a jour " + title);
            try {
                this.doConvert_rec(dbRoot, tool);
                nbrError = tool._nbrError;
                nbrFatal += tool._nbrFatal;
            }
            catch (Throwable th) {
                _LOG.log(Level.SEVERE, "Exception non gere lors de la convertion de la famille: " + title, th);
                ++nbrFatal;
            }
            _LOG.info("Mise a jour " + title + " : " + tool._nbrConvert);
        }
        if (nbrError > 0) {
            _LOG.severe("Mise a jour " + title + " en erreur : " + nbrError);
        }
        if (nbrFatal > 0) {
            _LOG.severe("Mise a jour " + title + " en erreur fatal : " + nbrFatal);
        }
        return nbrError + nbrFatal;
    }

    private int doUpdate(DBFolder.Family family, ConvertTool tool) {
        return this.doUpdate(family, family.toString().toLowerCase(), tool);
    }

    private int doUpdate() {
        int nbrError = 0;
        nbrError += this.doUpdate(DBFolder.Family.ATTRIBUTE, new ConvertWrap(DBFolder.Family.ATTRIBUTE));
        nbrError += this.doUpdate(DBFolder.Family.PARAMETER, new ConvertWrap(DBFolder.Family.PARAMETER));
        nbrError += this.doUpdate(DBFolder.Family.BTP_MODEL, new ConvertWrap(DBFolder.Family.BTP_MODEL));
        nbrError += this.doUpdate(DBFolder.Family.CCF_MODEL, new ConvertWrap(DBFolder.Family.CCF_MODEL));
        nbrError += this.doUpdate(DBFolder.Family.FMEA_MODEL, new ConvertWrap(DBFolder.Family.FMEA_MODEL));
        nbrError += this.doUpdate(DBFolder.Family.IMAG, new ConvertWrap(DBFolder.Family.IMAG));
        nbrError += this.doUpdate(DBFolder.Family.TYPE, new ConvertWrap(DBFolder.Family.TYPE));
        nbrError += this.doUpdate(DBFolder.Family.OPERATOR, new ConvertNode(DBFolder.Family.OPERATOR));
        nbrError += this.doUpdate(DBFolder.Family.COMPONENT, new ConvertNode(DBFolder.Family.COMPONENT));
        nbrError += this.doUpdate(DBFolder.Family.EQUIPMENT, new ConvertNode(DBFolder.Family.EQUIPMENT));
        final ConvertNode projectConvertModel = new ConvertNode(DBFolder.Family.PROJECT);
        final ConvertWrap projectConvertTree = new ConvertWrap(DBFolder.Family.PROJECT);
        final ConvertWrap projectConvertProject = new ConvertWrap(DBFolder.Family.PROJECT){

            @Override
            protected boolean isToBeConverted(DBFolder dbFolder) {
                return true;
            }

            @Override
            protected ResultConvert doConvert(DBFolder dbFolder) {
                if (dbFolder.getObject() == null) {
                    DBObject dbObject = new DBObject();
                    DBProject dbProject = new DBProject(dbFolder);
                    dbFolder.setObject(dbObject);
                    ResultConvert result = ResultConvert.KO;
                    try {
                        if (!dbProject.writeToDAO(FlowsUpdate.this.getDAOFactory(), null)) {
                            _LOG.severe("Erreur lors de l'ecriture de '" + dbFolder.getRefPath() + "'");
                        } else {
                            result = ResultConvert.OK;
                        }
                    }
                    catch (Exception e) {
                        _LOG.log(Level.SEVERE, "Exception lors de l'ecriture de '" + dbFolder.getRefPath() + "'", e);
                    }
                    return result;
                }
                return super.doConvert(dbFolder);
            }
        };
        nbrError += this.doUpdate(DBFolder.Family.PROJECT, new ConvertTool(){

            @Override
            protected ResultConvert doConvert(DBFolder dbFolder) {
                if (dbFolder.isFolder() && dbFolder.getParent().isSystem()) {
                    return projectConvertProject.doConvert(dbFolder);
                }
                if (!dbFolder.isVersion()) {
                    return ResultConvert.NO;
                }
                switch (dbFolder.getFamilyFlag()) {
                    case 1: {
                        return projectConvertModel.doConvert(dbFolder);
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return projectConvertTree.doConvert(dbFolder);
                    }
                }
                return ResultConvert.NO;
            }
        });
        return nbrError += this.doUpdate(DBFolder.Family.PROJECT, "project/tree (instantiate)", new ConvertTool(){

            @Override
            protected ResultConvert doConvert(DBFolder dbFolder) {
                if (!dbFolder.isVersion()) {
                    return ResultConvert.NO;
                }
                if (dbFolder.getFamilyFlag() == 2) {
                    _LOG.finer("Instantiate:" + dbFolder.getRefPath());
                    FlowsUpdate.this._lastConvert = dbFolder;
                    DBWrap dbWrap = FlowsUpdate.this.getDAOFactory().findOrCreateWrap(dbFolder);
                    if (dbWrap == null) {
                        _LOG.info("Erreur lors de la lecture de '" + dbFolder.getRefPath() + "'");
                        return ResultConvert.NO;
                    }
                    FTEquation ftEqu = (FTEquation)dbWrap;
                    if (!ftEqu.instanciate(false, FlowsUpdate.this.getDBUser())) {
                        for (DBLogs.Log dbLog : ftEqu.getInstanciateLogs().getLogs(DBLogs.DBLevel.INFO)) {
                            _LOG.log(dbLog.getLevel().getJavaLevel(), "Instantiate_Error " + dbLog.getMessage());
                        }
                        return ResultConvert.KO;
                    }
                    Collection<DBGlobEvent> dbEGLI = ftEqu.createGlobalEvents(dbFolder);
                    if (!FlowsUpdate.this.getDAOFactory().createGlobEventDAO().insertAll(dbFolder, dbEGLI)) {
                        _LOG.log(Level.WARNING, ResMsgObj.msgFormat("EGL_MSG_GENERATE_INSERT_ERR", dbFolder.getRefPath()));
                        return ResultConvert.KO;
                    }
                    return ResultConvert.OK;
                }
                return ResultConvert.NO;
            }
        });
    }

    public static void main(String[] args) {
        StringBuffer logBuffer = new StringBuffer();
        LaunchIniReader.initLaunchIni("Db51to60", logBuffer);
        FlowsUpdate _application = new FlowsUpdate(args);
        _application.init(logBuffer);
        if (_application.standardDatabaseConnection() && _application.standardUserLogin(true, true) && _application.openSession()) {
            int periodSupervisor = Integer.getInteger(PROP_SUPERVISOR_PERIOD, -1);
            if (periodSupervisor > 0) {
                ThreadSuperviseur supervisor = new ThreadSuperviseur(Thread.currentThread(), _application, periodSupervisor, _LOG);
                supervisor.start();
            }
            _application.getDAOFactory().createFolderDAO().setCacheLogs(true);
            long timer = System.currentTimeMillis();
            int nbrError = _application.doUpdate();
            if (nbrError > 0) {
                System.err.println("Error number: " + nbrError + " (see log for more informations)");
            }
            timer = System.currentTimeMillis() - timer;
            System.out.println("  [Time:" + timer / 1000L + " sec.]");
        }
        _application.close();
    }

    @Override
    public Preferencies getPreferencies() {
        return null;
    }

    class ConvertNode
    extends ConvertWrap {
        ConvertNode(DBFolder.Family dbFamily) {
            super(dbFamily);
        }

        @Override
        protected boolean doTransformBeforeWrite(DBWrap dbWrap) {
            if (!(dbWrap instanceof AltaNode)) {
                _LOG.log(Level.SEVERE, "Erreur interne lors de la transformation de '" + dbWrap.getDBFolder().getRefPath() + "'");
                return false;
            }
            AltaNode node = (AltaNode)dbWrap;
            OperatorDictionary opDic = FlowsUpdate.this.getDAOFactory().getOperatorDictionary();
            Set<String> names = opDic.findOperators(node.getCode());
            List<AltaOperatorRef> operatorsInNode = node.getUsedOperator();
            if (operatorsInNode.size() != 0) {
                for (int i = operatorsInNode.size() - 1; i >= 0; --i) {
                    AltaOperatorRef operatorId = operatorsInNode.get(i);
                    if (names.remove(operatorId.getName())) continue;
                    operatorsInNode.remove(operatorId);
                }
            }
            if (names.size() != 0) {
                for (String name : names) {
                    DBFolder model;
                    Set<DBFolder> folders = opDic.getOperatorsWithName(name);
                    DBFolder select = null;
                    if (folders.size() >= 1 && (model = folders.iterator().next()).isModel()) {
                        List<DBFolder> children = model.getChildren();
                        if (children == null) {
                            children = FlowsUpdate.this.getDAOFactory().createFolderDAO().findChildren(model);
                        }
                        select = children.get(children.size() - 1);
                    }
                    if (select == null) {
                        _LOG.log(Level.WARNING, "Utilisation d'un operateur inconnu '" + name + "' au sein de '" + dbWrap.getDBFolder().getRefPath() + "'");
                    }
                    AltaOperatorRef operatorId = new AltaOperatorRef(name, select);
                    operatorsInNode.add(operatorId);
                }
            }
            return true;
        }
    }

    class ConvertWrap
    extends ConvertTool {
        DBFolder.Family _dbFamily;

        ConvertWrap(DBFolder.Family dbFamily) {
            this._dbFamily = dbFamily;
        }

        protected boolean isToBeConverted(DBFolder dbFolder) {
            return dbFolder.isVersion();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ResultConvert doConvert(DBFolder dbFolder) {
            if (!this.isToBeConverted(dbFolder)) {
                return ResultConvert.NO;
            }
            _LOG.finer("Convert:" + dbFolder.getRefPath());
            FlowsUpdate.this._lastConvert = dbFolder;
            DBWrap dbWrap = FlowsUpdate.this.getDAOFactory().findOrCreateWrap(dbFolder);
            if (dbWrap == null) {
                _LOG.severe("Erreur lors de la lecture de '" + dbFolder.getRefPath() + "'");
                return ResultConvert.KO;
            }
            if (!this.doTransformBeforeWrite(dbWrap)) {
                return ResultConvert.KO;
            }
            ResultConvert result = ResultConvert.KO;
            boolean freeze = dbFolder.isFreeze();
            if (freeze) {
                FlowsUpdate.this.getDAOFactory().createObjectDAO().setFreeze(dbFolder.getObject(), false);
            }
            try {
                if (!dbWrap.writeToDAO(FlowsUpdate.this.getDAOFactory(), null)) {
                    _LOG.severe("Erreur lors de l'ecriture de '" + dbFolder.getRefPath() + "'");
                } else {
                    result = ResultConvert.OK;
                }
            }
            catch (Exception e) {
                _LOG.log(Level.SEVERE, "Exception lors de l'ecriture de '" + dbFolder.getRefPath() + "'", e);
            }
            finally {
                if (freeze) {
                    FlowsUpdate.this.getDAOFactory().createObjectDAO().setFreeze(dbFolder.getObject(), true);
                }
            }
            return result;
        }

        protected boolean doTransformBeforeWrite(DBWrap dbWrap) {
            return true;
        }
    }

    abstract class ConvertTool {
        protected int _nbrConvert;
        protected int _nbrError;
        protected int _nbrFatal;

        ConvertTool() {
        }

        public void convert(DBFolder dbFolder) {
            try {
                switch (this.doConvert(dbFolder)) {
                    case KO: {
                        ++this._nbrError;
                    }
                    case OK: {
                        ++this._nbrConvert;
                    }
                }
            }
            catch (Throwable th) {
                _LOG.log(Level.SEVERE, "Exception non gere lors du dossier : " + dbFolder.getRefPath(), th);
                ++this._nbrFatal;
            }
        }

        protected abstract ResultConvert doConvert(DBFolder var1);
    }

    static enum ResultConvert {
        NO,
        OK,
        KO;

    }
}

