/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrCriterion;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanAttrAvg;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanAttribute;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanExpression;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BooleanStore {
    private static Logger _LOG = Logger.getLogger(BooleanStore.class.getPackage().getName());
    public static String INFO_PROJECT = "Project";
    public static String INFO_PROJECT_OWNER = "Project-Owner";
    public static String INFO_PROJECT_GROUP = "Project-Group";
    public static String INFO_PROJECT_ACCESS_GROUP = "Project-Access-Group";
    public static String INFO_PROJECT_ACCESS_OTHER = "Project-Access-Other";
    public static String INFO_PROJECT_CREATE_DATE = "Project-Create-Date";
    public static String INFO_SYSTEM = "System";
    public static String INFO_SYSTEM_OWNER = "System-Owner";
    public static String INFO_SYSTEM_GROUP = "System-Group";
    public static String INFO_SYSTEM_ACCESS_GROUP = "System-Access-Group";
    public static String INFO_SYSTEM_ACCESS_OTHER = "System-Access-Other";
    public static String INFO_SYSTEM_CREATE_DATE = "System-Create-Date";
    public static String INFO_TREE = "Tree";
    public static String INFO_TREE_OWNER = "Tree-Owner";
    public static String INFO_TREE_GROUP = "Tree-Group";
    public static String INFO_TREE_ACCESS_GROUP = "Tree-Access-Group";
    public static String INFO_TREE_ACCESS_OTHER = "Tree-Access-Other";
    public static String INFO_TREE_CREATE_DATE = "Tree-Create-Date";
    public static String INFO_TREE_COMMENT = "Tree-Comment";
    public static String INFO_VERSION = "Version";
    public static String INFO_VERSION_COMMENT = "Version-Comment";
    public static String INFO_VERSION_CREATE_DATE = "Version-Create-Date";
    public static String INFO_VERSION_CREATE_BY = "Version-Create-By";
    public static String INFO_VERSION_MODIFY_DATE = "Version-Modify-Date";
    public static String INFO_VERSION_MODIFY_BY = "Version-Modify-By";
    public static String INFO_CONFIGURATION = "Configuration";
    public static String INFO_MISSION_TIME = "Mission-Time";
    public static String INFO_CRITICITY = "Criticity";
    public static String INFO_CRITICITY_PROBA = "Criticity-Probability";
    public static String INFO_CRITICITY_ORDER = "Criticity-OrderCuts";
    public static String INFO_CRITICITY_LSR_LATENT = "Criticity-LSR-Latent";
    public static String INFO_CRITICITY_LSR_EVIDENT = "Criticity-LSR-Evident";
    public static String INFO_MODEL_MBSA = "ModelPathMBSA";
    public static String INFO_INITIAL_CONF_MBSA = "InitialConfMBSA";
    public static String INFO_TARGET_MBSA = "TargetMBSA";
    public static String INFO_LATENT_PROBABILITY = "Latent-Probability";
    public static String INFO_AVERAGE_FLIGHT_DURATION = "Average-Flight-Duration";
    public static String INFO_BIGTREE = "Tree-BigTree";
    public static String INFO_READONLY = "ReadOnly";
    public static String INFO_LOCKED = "Locked";
    public static String INFO_ACCESS_WRITE = "AccessWrite";
    public static String INFO_FROZEN = "Frozen";
    BooleanNode _rootNode = null;
    List<BooleanNode> _leafList = new ArrayList<BooleanNode>();
    List<BooleanNode> _gateList = new ArrayList<BooleanNode>();
    Map<String, BooleanNode> _varMap = new HashMap<String, BooleanNode>();
    Map<String, BooleanExpression> _paramMap = new LinkedHashMap<String, BooleanExpression>();
    Map<String, Boolean> _dsfMap = new TreeMap<String, Boolean>();
    Map<String, String> _infoMap = new HashMap<String, String>();
    Map<Integer, BooleanAttrAvg> _attAvgMap = new TreeMap<Integer, BooleanAttrAvg>();
    Map<Attr.Key, Set<String>> _attributes = new HashMap<Attr.Key, Set<String>>();
    BooleanParser _parser;
    StringBuffer _warning = new StringBuffer(1024);

    public BooleanParser getParser() {
        if (this._parser == null) {
            this._parser = new BooleanParser();
        }
        return this._parser;
    }

    public String getInfo(String key) {
        return this._infoMap.get(key);
    }

    public Collection<BooleanAttrAvg> getAttributeAverage() {
        return this._attAvgMap.size() == 0 ? null : this._attAvgMap.values();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("BooleanStore[").append(this._rootNode).append("] -> ");
        sb.append("{leaf=").append(this._leafList.size());
        sb.append(",gate=").append(this._gateList.size());
        sb.append(",param=").append(this._paramMap.size());
        return sb.append("}").toString();
    }

    public void loadXML(InputStream input) throws IOException {
        class BooleanHandler
        extends DefaultHandler {
            BooleanNode _currentVar;
            Locator _locator;

            BooleanHandler() {
            }

            public Locator getLocator() {
                return this._locator;
            }

            @Override
            public void setDocumentLocator(Locator locator) {
                this._locator = locator;
                super.setDocumentLocator(locator);
            }

            private String getValAttribute(Attributes attrs, String name, String entity) throws SAXException {
                int idx = attrs.getIndex(name);
                if (idx == -1) {
                    throw new SAXException("No attribute '" + name + "' for element '" + entity + "' !");
                }
                return attrs.getValue(idx);
            }

            @Override
            public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
                String eltName;
                if (attrs == null) {
                    return;
                }
                String string = eltName = "".equals(sName) ? qName : sName;
                if (eltName.equals("info")) {
                    String name = this.getValAttribute(attrs, "n", eltName);
                    String value = this.getValAttribute(attrs, "v", eltName);
                    BooleanStore.this._infoMap.put(name, value);
                } else if (eltName.equals("dsf")) {
                    String path = this.getValAttribute(attrs, "path", eltName);
                    String frb = this.getValAttribute(attrs, "frb", eltName);
                    BooleanStore.this._dsfMap.put(path, frb.equalsIgnoreCase("true"));
                } else if (eltName.equals("attr-avg")) {
                    int id = -1;
                    try {
                        id = Integer.parseInt(this.getValAttribute(attrs, "id", eltName));
                    }
                    catch (NumberFormatException e) {
                        throw new SAXException(e);
                    }
                    Attr.DefaultKey attrKey = null;
                    try {
                        String name = this.getValAttribute(attrs, "n", eltName);
                        switch (Integer.parseInt(this.getValAttribute(attrs, "t", eltName))) {
                            case 0: {
                                attrKey = new Attr.DefaultKey(AttrType.ALIAS, name);
                                break;
                            }
                            case 1: {
                                attrKey = new Attr.DefaultKey(AttrType.NUMBER, name);
                                break;
                            }
                            case 2: {
                                attrKey = new Attr.DefaultKey(AttrType.STRING, name);
                                break;
                            }
                            case 3: {
                                attrKey = new Attr.DefaultKey(AttrType.ENUM, name);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new SAXException(e);
                    }
                    if (attrKey == null) {
                        throw new SAXException("Unknown attribute type ('t')");
                    }
                    AttrCriterion attrCrit = null;
                    if (attrKey.getType() != AttrType.ALIAS) {
                        String attrOp = this.getValAttribute(attrs, "o", eltName);
                        String attrData = this.getValAttribute(attrs, "d", eltName);
                        AttrCriterion.Operator op = AttrCriterion.Operator.valueOf((String)attrOp);
                        if (op == null) {
                            throw new SAXException("Value of attribute 'o' unknown : " + attrOp + " !");
                        }
                        attrCrit = new AttrCriterion((Attr.Key)attrKey, op, attrData);
                    } else {
                        attrCrit = new AttrCriterion((Attr.Key)attrKey, null, null);
                    }
                    BooleanAttrAvg.Choice choice = null;
                    String attrChoice = this.getValAttribute(attrs, "c", eltName);
                    choice = BooleanAttrAvg.Choice.valueOf(attrChoice);
                    if (choice == null) {
                        throw new SAXException("Value of attribute 'c' unknown : " + attrChoice + " !");
                    }
                    String parameter = null;
                    int idxParam = attrs.getIndex("p");
                    if (idxParam != -1) {
                        parameter = attrs.getValue(idxParam);
                    }
                    BooleanStore.this._attAvgMap.put(id, new BooleanAttrAvg(attrCrit, choice, parameter));
                } else if (eltName.equals("evt")) {
                    BooleanNode var;
                    String name = this.getValAttribute(attrs, "n", eltName);
                    int type = 0;
                    try {
                        type = Integer.parseInt(this.getValAttribute(attrs, "t", eltName));
                    }
                    catch (NumberFormatException nfe) {
                        throw new SAXException(nfe);
                    }
                    if (type < 0 || type > 6) {
                        throw new SAXException("Bad value for 't'");
                    }
                    boolean ext = false;
                    if (attrs.getIndex("ext") != -1) {
                        ext = "true".equals(attrs.getValue(attrs.getIndex("ext")));
                    }
                    if ((var = BooleanStore.this._varMap.get(name)) != null) {
                        throw new SAXException("Variable already define : " + name);
                    }
                    var = new BooleanNode(name, type, ext);
                    if (var.isLeaf()) {
                        var.setIndex(BooleanStore.this._leafList.size());
                        BooleanStore.this._leafList.add(var);
                    } else {
                        if (type == 0) {
                            if (BooleanStore.this._rootNode != null) {
                                throw new SAXException("Root already define ; 2 root is not possible : " + BooleanStore.this._rootNode.getName() + ", " + name);
                            }
                            BooleanStore.this._rootNode = var;
                        }
                        var.setIndex(BooleanStore.this._gateList.size());
                        BooleanStore.this._gateList.add(var);
                    }
                    BooleanStore.this._varMap.put(var.getName(), var);
                    this._currentVar = var;
                } else if (eltName.equals("fld")) {
                    String name = this.getValAttribute(attrs, "n", eltName);
                    String value = this.getValAttribute(attrs, "v", eltName);
                    Attr.Key key = null;
                    if ("equiv".equals(name)) {
                        key = BooleanAttribute.KEY_EQUIV;
                    } else if ("fmea".equals(name)) {
                        key = BooleanAttribute.KEY_FMEA;
                    } else if ("frb".equals(name)) {
                        key = BooleanAttribute.KEY_FRB;
                    } else if ("generic".equals(name)) {
                        key = BooleanAttribute.KEY_GENERIC;
                    } else if ("gsr".equals(name)) {
                        key = BooleanAttribute.KEY_GSR;
                    } else if ("inflight".equals(name)) {
                        key = BooleanAttribute.KEY_INFLIGHT;
                    } else if ("inspected".equals(name)) {
                        key = BooleanAttribute.KEY_INSPECTED;
                    } else if ("label".equals(name)) {
                        key = BooleanAttribute.KEY_LABEL;
                    } else if ("law".equals(name)) {
                        key = BooleanAttribute.KEY_LAW;
                    } else if ("state".equals(name)) {
                        key = BooleanAttribute.KEY_STATE;
                    } else {
                        throw new SAXException("Unknown field name ('n'): " + name);
                    }
                    this._currentVar.addAttribute(new BooleanAttribute(key, value));
                } else if (eltName.equals("attr")) {
                    BooleanAttribute attribute = null;
                    String name = this.getValAttribute(attrs, "n", eltName);
                    String value = this.getValAttribute(attrs, "v", eltName);
                    try {
                        switch (Integer.parseInt(this.getValAttribute(attrs, "t", eltName))) {
                            case 0: {
                                attribute = new BooleanAttribute(AttrType.ALIAS, name, value);
                                break;
                            }
                            case 1: {
                                attribute = new BooleanAttribute(AttrType.NUMBER, name, value);
                                break;
                            }
                            case 2: {
                                attribute = new BooleanAttribute(AttrType.STRING, name, value);
                                break;
                            }
                            case 3: {
                                attribute = new BooleanAttribute(AttrType.ENUM, name, value);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new SAXException(e);
                    }
                    if (attribute == null) {
                        throw new SAXException("Unknown attribute type ('t')");
                    }
                    Set<String> values = BooleanStore.this._attributes.get(attribute.getKey());
                    if (values == null) {
                        values = new TreeSet<String>();
                        BooleanStore.this._attributes.put(attribute.getKey(), values);
                    }
                    values.add(value);
                    this._currentVar.addAttribute(attribute);
                } else if (eltName.equals("param")) {
                    String name = this.getValAttribute(attrs, "n", eltName);
                    String value = this.getValAttribute(attrs, "v", eltName);
                    BooleanExpression param = BooleanStore.this._paramMap.get(name);
                    if (param != null) {
                        throw new SAXException("Parameter already define : " + name);
                    }
                    param = BooleanExpression.createNamedParameter(name, value);
                    BooleanStore.this._paramMap.put(name, param);
                }
            }

            @Override
            public void endDocument() throws SAXException {
                if (BooleanStore.this._rootNode == null) {
                    throw new SAXException("No root define");
                }
                super.endDocument();
            }

            @Override
            public void endElement(String uri, String sName, String qName) throws SAXException {
                String eltName;
                String string = eltName = "".equals(sName) ? qName : sName;
                if (eltName.equals("evt")) {
                    this._currentVar = null;
                }
            }
        }
        BooleanHandler handler = null;
        try {
            SAXParserFactory fabrique = SAXParserFactory.newInstance();
            handler = new BooleanHandler();
            SAXParser parseur = fabrique.newSAXParser();
            parseur.parse(input, (DefaultHandler)handler);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            Locator loc;
            StringBuffer sb = new StringBuffer();
            sb.append("SAX Parser Exception ");
            if (handler != null && (loc = handler.getLocator()) != null) {
                sb.append("in [line = ");
                sb.append(loc.getLineNumber());
                sb.append("] [col = ");
                sb.append(loc.getColumnNumber());
                sb.append("]");
            }
            sb.append("\n");
            sb.append(e.getMessage());
            throw new IOException(sb.toString(), e);
        }
        StringBuffer errorBuffer = new StringBuffer();
        for (Map.Entry<String, BooleanExpression> entry : this._paramMap.entrySet()) {
            if (entry.getValue().convert(this)) continue;
            errorBuffer.append("Parameter : ").append(entry.getKey()).append("\n");
        }
        Collections.sort(this._leafList, new Comparator<BooleanNode>(){

            @Override
            public int compare(BooleanNode o1, BooleanNode o2) {
                String str2;
                String str1 = o1._name;
                if (str1.length() > 2 && "'`".contains(str1.substring(0, 1)) && str1.charAt(str1.length() - 1) == '\'') {
                    str1 = str1.substring(1, str1.length() - 1);
                }
                if ((str2 = o2._name).length() > 2 && "'`".contains(str2.substring(0, 1)) && str2.charAt(str2.length() - 1) == '\'') {
                    str2 = str2.substring(1, str2.length() - 1);
                }
                return str1.compareTo(str2);
            }
        });
        int idx = 0;
        for (BooleanNode leaf : this._leafList) {
            leaf.setIndex(idx++);
            if (leaf.convert(this)) continue;
            errorBuffer.append("Variable : ").append(leaf.getName()).append("\n");
        }
        if (errorBuffer.length() > 0) {
            throw new IOException("Error during convert information : \n" + errorBuffer.toString());
        }
    }

    public BooleanExpression getNamedParameter(String name) {
        return this._paramMap.get(name);
    }

    public boolean oneOrMoreLeavesWithoutProbability() {
        if (this._leafList.isEmpty()) {
            return true;
        }
        for (BooleanNode leaf : this._leafList) {
            if (!leaf.withoutProbability()) continue;
            return true;
        }
        return false;
    }

    public void computeLeavesProbability(double missionTime, ProbabilityControl probaCtrl) {
        for (BooleanNode leaf : this._leafList) {
            leaf.computeProbability(missionTime, probaCtrl);
        }
    }

    public void writeProbabilities(Appendable output) throws IOException {
        for (BooleanNode leaf : this._leafList) {
            leaf.writeProbability(output);
        }
    }

    public void prepareComputeAverageRisk(TypeProbability typePr, double missionTime, ProbabilityControl ctrl) {
        if (!typePr.isAverageProbability()) {
            return;
        }
        for (BooleanNode leaf : this._leafList) {
            leaf.prepareComputeAverageRisk(typePr == TypeProbability.ARP3 ? null : this.getAttributeAverage(), this, missionTime, ctrl);
        }
    }

    public void addWarning(String warning) {
        char car;
        if (this._warning.length() > 0 && (car = this._warning.charAt(this._warning.length() - 1)) != '\n' && car != '\r') {
            this._warning.append("\n");
        }
        this._warning.append(warning);
    }

    public String getWarning() {
        return this._warning.toString();
    }

    public BooleanNode getRoot() {
        return this._rootNode;
    }

    public BooleanNode getNode(String name) {
        return this._varMap.get(name);
    }

    public Iterator<BooleanNode> iterate() {
        return this._varMap.values().iterator();
    }

    public int getNbrGates() {
        return this._gateList.size();
    }

    public BooleanNode getGate(int idx) {
        return this._gateList.get(idx);
    }

    public int getNbrLeaves() {
        return this._leafList.size();
    }

    public BooleanNode getLeaf(int idx) {
        return this._leafList.get(idx);
    }

    public Map<Attr.Key, Set<String>> getAttributes() {
        return this._attributes;
    }

    public Map<String, Boolean> getDsfs() {
        return this._dsfMap;
    }

    public double getDefaultMissionTime() {
        double duration = Double.NaN;
        String info = this.getInfo(INFO_MISSION_TIME);
        if (info != null) {
            try {
                duration = Double.parseDouble(info);
                if (duration < 0.0) {
                    duration = Double.NaN;
                    _LOG.warning("Mission Time must not be negative");
                }
            }
            catch (NumberFormatException e) {
                _LOG.warning("Mission Time must be a number");
            }
        }
        return duration;
    }

    public double getAverageFlightDuration() {
        double duration = Double.NaN;
        String info = this.getInfo(INFO_AVERAGE_FLIGHT_DURATION);
        if (info != null) {
            try {
                duration = Double.parseDouble(info);
                if (duration < 0.0) {
                    duration = Double.NaN;
                    _LOG.warning("Average Flight Duration must not be negative");
                }
            }
            catch (NumberFormatException e) {
                _LOG.warning("Average Flight Duration must be a number");
            }
        }
        return duration;
    }

    public static interface ProbabilityControl {
        public void appendMissingProbability(BooleanNode var1);

        public void appendErrorProbability(BooleanNode var1);

        public void appendLesserPeriodicity(BooleanNode var1);

        public void appendGreaterExposition(BooleanNode var1);

        public void appendAvgNoAttribute(BooleanNode var1);

        public void appendAvgNoMatrix(BooleanNode var1);

        public void appendAvgDefInspected(BooleanNode var1);

        public void appendAvgNoInspected(BooleanNode var1);

        public void appendAvgBadParameter(BooleanNode var1);
    }
}

