/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.lib.util.TestUtility;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanNode;
import com.dassault.cecilia.plugin.faulttree.compute.MCSReaderHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class MCSReaderHelperTest
extends TestUtility {
    private List<BooleanNode> createCut(int order) {
        ArrayList<BooleanNode> result = new ArrayList<BooleanNode>();
        while (order > 0) {
            result.add(null);
            --order;
        }
        return result;
    }

    private void debugHelper(MCSReaderHelper helper) {
        int[] orders = helper.getOrders();
        for (int i = 0; i < orders.length; ++i) {
            if (orders[i] <= 0) continue;
            System.out.println(i + "\t" + orders[i]);
        }
    }

    @Test
    public void testNumber10() {
        int order;
        int i;
        Random rnd = new Random(7L);
        MCSReaderHelper helper = new MCSReaderHelper(10){

            @Override
            public boolean isCanceled() {
                return false;
            }
        };
        for (i = 0; i < 10; ++i) {
            order = rnd.nextInt(8) + 1;
            helper.addCuts(this.createCut(order));
        }
        Assert.assertFalse((boolean)helper.hasLimited());
        Assert.assertTrue((boolean)helper.addCuts(this.createCut(rnd.nextInt(8) + 1)));
        Assert.assertTrue((boolean)helper.hasLimited());
        Assert.assertEquals((long)8L, (long)helper.getLimitOrder());
        Assert.assertEquals((long)10L, (long)helper._nbrKeepCut);
        for (i = 0; i < 9; ++i) {
            order = rnd.nextInt(8) + 1;
            helper.addCuts(this.createCut(order));
        }
        Assert.assertEquals((long)6L, (long)helper.getLimitOrder());
        Assert.assertEquals((long)9L, (long)helper._nbrKeepCut);
    }

    @Test
    public void testNumber100() {
        Random rnd = new Random(7L);
        MCSReaderHelper helper = new MCSReaderHelper(100){

            @Override
            public boolean isCanceled() {
                return false;
            }
        };
        for (int i = 0; i < 200; ++i) {
            helper.addCuts(this.createCut(rnd.nextInt(8) + 1));
            Assert.assertTrue((helper._nbrKeepCut <= 100 ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)helper.hasLimited());
        Assert.assertEquals((long)5L, (long)helper.getLimitOrder());
        Assert.assertEquals((long)94L, (long)helper._nbrKeepCut);
    }

    @Test
    public void testNumber50() {
        Random rnd = new Random(7L);
        MCSReaderHelper helper = new MCSReaderHelper(50){

            @Override
            public boolean isCanceled() {
                return false;
            }
        };
        for (int i = 0; i < 50; ++i) {
            helper.addCuts(this.createCut(rnd.nextInt(8) + 1));
            Assert.assertTrue((helper._nbrKeepCut <= 50 ? 1 : 0) != 0);
        }
        Assert.assertFalse((boolean)helper.hasLimited());
    }
}

