/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute;

import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IOParameters;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableAppl;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.plugin.PluginManager;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.dbobj.folder.DBFolderTreeActivable;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.main.cecilia.folders.ProjectFolderTree;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.melsynthesis.MELSynthesisDlg;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.tree.TreePath;

public class PluginCmdMELSynthesis
extends AbstractPluginModel
implements PluginMAction {
    private static Logger _LOG = Logger.getLogger(PluginCmdMELSynthesis.class.getPackage().getName());

    public boolean withOption(Plugable plugable) {
        return false;
    }

    public PlugPanel displayOption(Plugable launcher) {
        return null;
    }

    public void refreshOptions(Plugable launcher) {
    }

    public boolean withParameters() {
        return false;
    }

    public Object getDefaultParameters(PluginManager plugable) {
        return null;
    }

    public Object changeParameters(PluginManager parent, Object parameters) {
        return null;
    }

    public IOParameters getIOParameters() {
        return null;
    }

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResCompute.getString("PLUG_CMD_MELSYNTHESIS_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResCompute.getString("PLUG_CMD_MELSYNTHESIS_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        if (key.equals("plugin.shortcut")) {
            return "ctrl alt shift M";
        }
        return "Info";
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoCompute.getImageIcon("PLUGIN_SYNTHESE");
        }
        return super.getIcon(key);
    }

    public void createSession(Plugable launcher, Object parameters) {
        PlugableAppl pappl = launcher.getAppl();
        if (pappl == null || !(pappl instanceof CeciliaAppl)) {
            _LOG.severe("Echec du plugin '" + ((Object)((Object)this)).getClass().getName() + "': Pas d'application Cecilia");
            return;
        }
        CeciliaAppl appl = (CeciliaAppl)pappl;
        DBFolderTreeActivable tree = appl.getTopWindow().getFolders().getTree(DBFolder.Family.PROJECT);
        if (tree == null || !(tree instanceof ProjectFolderTree)) {
            _LOG.severe("Echec du plugin '" + ((Object)((Object)this)).getClass().getName() + "': Pas d'arborescence PROJECT");
            return;
        }
        LinkedHashSet<DBFolder> folders = new LinkedHashSet<DBFolder>();
        this.recupFolderSelected(appl, (ProjectFolderTree)tree, folders);
        MELSynthesisDlg dlg = new MELSynthesisDlg(launcher, new ArrayList<DBFolder>(folders));
        dlg.setVisible(true);
    }

    private final Set<DBFolder> recupFolderSelected(CeciliaAppl appl, ProjectFolderTree projectTree, Set<DBFolder> folders) {
        if (projectTree == null) {
            return folders;
        }
        TreePath[] selPaths = projectTree.getSelectionPaths();
        if (selPaths == null) {
            return folders;
        }
        if (selPaths.length == 0) {
            return folders;
        }
        ArrayList selFolders = projectTree.convertTreePathsToFolders(selPaths);
        for (DBFolder dbFolder : selFolders) {
            this.getAllTreeFolder(dbFolder, appl, folders);
        }
        return folders;
    }

    private final void getAllTreeFolder(DBFolder dbFolder, CeciliaAppl appl, Set<DBFolder> folders) {
        if (dbFolder.getAccessRight(appl.getDBUser()) == DBAccess.Right.NONE) {
            return;
        }
        if (dbFolder.isVersion()) {
            switch (dbFolder.getFamilyFlag()) {
                case 2: 
                case 5: {
                    folders.add(dbFolder);
                }
            }
        } else {
            List children;
            if (dbFolder.isModel()) {
                switch (dbFolder.getFamilyFlag()) {
                    case 2: 
                    case 5: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if ((children = dbFolder.getChildren()) == null) {
                children = appl.getDAOFactory().createFolderDAO().findChildren(dbFolder);
            }
            if (children != null) {
                for (DBFolder child : children) {
                    this.getAllTreeFolder(child, appl, folders);
                }
            }
        }
    }
}

