/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.batch;

import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.PartialCheckBox;
import com.dassault.cecilia.core.swing.other.ToggleBorderLayout;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class BatchItemTreeDlg
extends JDialogCecilia {
    private JComboBox _ctrlConfigs;
    private PartialCheckBox _ctrlRootCheck;
    private JTextField _ctrlRootName;
    private JLabel _ctrlRootLbl;
    Boolean _initialState = false;

    public BatchItemTreeDlg(Window owner) {
        super(owner, true);
        this.create();
        this.init();
    }

    private void create() {
        JPanel root = new JPanel(new GridBagLayout());
        JPanel cfgPanel = new JPanel(new GridBagLayout());
        this.createCtrlConfigs();
        cfgPanel.add((Component)new JLabel(ResCompute.getString("DLG_RESULT_INFO_CONFIG")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        cfgPanel.add((Component)this._ctrlConfigs, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        root.add((Component)cfgPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        JPanel rootPanel = new JPanel((LayoutManager)new ToggleBorderLayout());
        this.createCtrlRoot();
        JPanel selectRootPanel = new JPanel(new GridBagLayout());
        selectRootPanel.add((Component)this._ctrlRootLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        selectRootPanel.add((Component)this._ctrlRootName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        ToggleBorderLayout.configure((Container)rootPanel, (JToggleButton)this._ctrlRootCheck, (JComponent)selectRootPanel);
        root.add((Component)rootPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)root, "Center");
        this.getContentPane().add((Component)this.createButPanel(true), "South");
    }

    private void createCtrlConfigs() {
        this._ctrlConfigs = new JComboBox();
        this._ctrlConfigs.addItem("Default");
        this._ctrlConfigs.addItem("Config-0123456789");
        this._ctrlConfigs.setEditable(false);
    }

    private void createCtrlRoot() {
        this._ctrlRootCheck = new PartialCheckBox(ResCompute.getString("BATCH_ROOT_INTERMEDIATE"));
        this._ctrlRootCheck.setAsymetricChangeValue(true);
        this._ctrlRootName = new JTextField(20);
        this._ctrlRootLbl = new JLabel(ResCompute.getString("BATCH_ROOT_INTERMEDIATE_NAME"));
        this._ctrlRootCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchItemTreeDlg.this.refreshCtrlRoot();
            }
        });
    }

    protected void refreshCtrlRoot() {
        boolean rootSelect = this._ctrlRootCheck.isSelected() && !this._ctrlRootCheck.isPartial();
        this._ctrlRootName.setEnabled(rootSelect);
        this._ctrlRootLbl.setEnabled(rootSelect);
        this._ctrlRootCheck.updateUI();
    }

    protected boolean verifyParameters() {
        Boolean stillInInitialState;
        Boolean bl = stillInInitialState = this._ctrlRootCheck.isPartial() ? null : Boolean.valueOf(this._ctrlRootCheck.isSelected());
        if (stillInInitialState != this._initialState && this._ctrlRootCheck.isSelected() && !this.isRootPartial() && this._ctrlRootName.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._ctrlRootName), ResCompute.getString("BATCH_DLG_ERR_GATE"), this.getTitle(), 0);
            this._ctrlRootName.requestFocus();
            return false;
        }
        return true;
    }

    public String getConfig() {
        return (String)this._ctrlConfigs.getSelectedItem();
    }

    public String getRoot() {
        if (!this._ctrlRootCheck.isSelected() || this._ctrlRootName.getText().isEmpty()) {
            return "";
        }
        return this._ctrlRootName.getText();
    }

    public boolean isRootSelected() {
        return this._ctrlRootCheck.isSelected();
    }

    public boolean isRootPartial() {
        return this._ctrlRootCheck.getState() == PartialCheckBox.State.PARTIAL;
    }

    public void configurateConfig(List<String> configs, String config) {
        this._ctrlConfigs.removeAllItems();
        for (String cfg : configs) {
            this._ctrlConfigs.addItem(cfg);
        }
        this._ctrlConfigs.setSelectedItem(config);
    }

    public void configureRoot(boolean selectCheckBox, String interName, boolean isAMultiSelection) {
        if (interName == null) {
            this._ctrlRootCheck.setPartial(true);
            this._ctrlRootName.setText(null);
            this._ctrlRootName.setEnabled(false);
            this._initialState = null;
        } else {
            this._ctrlRootCheck.setSelected(selectCheckBox);
            this._ctrlRootName.setEnabled(selectCheckBox);
            this._ctrlRootName.setText(interName);
            this._initialState = selectCheckBox;
        }
        this.refreshCtrlRoot();
    }
}

