/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.batch;

import com.dassault.cecilia.core.ResIcoCore;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.action.CModelessThread;
import com.dassault.cecilia.core.cecilia.folder.dnd.DBFolderList;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.db.DBAccess;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.dbobj.CeciliaFactory;
import com.dassault.cecilia.dbobj.faulttree.config.FTConfig;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.faulttree.ft.gui.FTPanelTableFolder;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.dbobj.general.attrib.AttrType;
import com.dassault.cecilia.dbobj.general.attrib.DBAttrib;
import com.dassault.cecilia.dbobj.wrap.DBWrap;
import com.dassault.cecilia.plugin.faulttree.compute.ComputeType;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchCompute;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchItem;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchItemComputeDlg;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchItemTreeDlg;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchTableModel;
import com.dassault.cecilia.plugin.faulttree.compute.batch.BatchTableRenderer;
import com.dassault.cecilia.plugin.faulttree.compute.batch.ExportItem;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import org.w3c.dom.Element;

public class BatchPanel
extends FTPanelTableFolder {
    private static Logger _LOG = Logger.getLogger(BatchPanel.class.getPackage().getName());
    Plugable _plugable;
    BatchCompute _batch;
    CeciliaAction _ctrlEditCompute;
    CeciliaAction _ctrlEditTree;
    CeciliaAction _ctrlUp;
    CeciliaAction _ctrlDown;
    JComboBox _ctrlSaveResults;
    JCheckBox _ctrlIgnoreReference;
    Map<Attr.Key, Set<String>> _attributes = null;
    ArborRenderer _renderer;
    BatchItemComputeDlg _dlgItem = null;
    BatchItemTreeDlg _dlgTree = null;

    public BatchPanel(Plugable plugable, JDialog dlg, BatchCompute batch) {
        super((CAppl)plugable.getAppl(), dlg);
        this._plugable = plugable;
        this._batch = batch;
        this.initialise();
    }

    protected void createModel() {
        this._model = new BatchTableModel(this._batch);
    }

    private BatchTableModel getModel() {
        return (BatchTableModel)this._model;
    }

    protected void doDropDnD(final DBFolderList dataDnD, final Point point) {
        CModelessThread action = new CModelessThread((Component)((Object)this)){

            protected void firstDo() {
                BatchPanel.this.privateAddFolders(dataDnD, point);
            }

            protected void invokeLater() {
            }
        };
        action.createAndStartThread("Batch/DnD");
    }

    private void privateAddFolders(DBFolderList dataDnD, Point point) {
        super.addFolders(dataDnD.getFolders());
    }

    protected void addToBatch(DBFolder node) {
        CECFactory cecFactory = (CECFactory)this._cAppl.getDAOFactory();
        DBWrap dbWrap = cecFactory.findOrCreateWrap(node);
        if (dbWrap == null) {
            _LOG.info("Impossible de lire l'equation associee au dossier : " + node.getRefPath());
            return;
        }
        if (!(dbWrap instanceof FTEquation)) {
            _LOG.info("La donn\u00e9e m\u00e9tier associ\u00e9 au dossier n'est pas une equation : " + node.getRefPath());
            return;
        }
        BatchItem item = new BatchItem((CeciliaFactory)cecFactory, (FTEquation)dbWrap);
        this.getModel().addData(item);
    }

    private void createMapAttributes_rec(DBFolder dbFolder, Map<Attr.Key, Set<String>> attributes, DAOFolder daoFolder, CECFactory cecFactory) {
        if (dbFolder.isVersion()) {
            DBWrap dbWrap = cecFactory.findOrCreateWrap(dbFolder);
            if (dbWrap != null && dbWrap instanceof DBAttrib) {
                DBAttrib dbAttrib = (DBAttrib)dbWrap;
                Set enums = null;
                enums = dbAttrib.getType() == AttrType.ENUM ? new LinkedHashSet(dbAttrib.getEnums()) : Collections.emptySet();
                attributes.put((Attr.Key)dbAttrib, enums);
            }
        } else {
            List children = dbFolder.getChildren();
            if (children == null) {
                children = daoFolder.findChildren(dbFolder);
            }
            for (DBFolder dbChild : children) {
                this.createMapAttributes_rec(dbChild, attributes, daoFolder, cecFactory);
            }
        }
    }

    private synchronized void createMapAttributes() {
        if (this._attributes == null) {
            this._attributes = new HashMap<Attr.Key, Set<String>>();
            CECFactory cecFactory = (CECFactory)this._plugable.getAppl().getDAOFactory();
            DAOFolder daoFolder = cecFactory.createFolderDAO();
            DBFolder dbFolder = daoFolder.getRootID("ATTRIBUTES");
            this.createMapAttributes_rec(dbFolder, this._attributes, daoFolder, cecFactory);
        }
    }

    public void setRenderer(ArborRenderer renderer) {
        this._renderer = renderer;
        this.getModel().setRenderer(this._renderer);
    }

    protected void createDlgItemCompute() {
        if (this._dlgItem == null) {
            this.createMapAttributes();
            this._dlgItem = new BatchItemComputeDlg(SwingUtilities.getWindowAncestor(this._table), this._plugable, this._attributes);
            this._dlgItem.setRenderer(this._renderer);
            this._dlgItem.pack();
            this._dlgItem.setLocationRelativeTo(this._table);
        }
    }

    protected boolean displayDlgItemCompute(Collection<BatchItem> items) {
        this.createDlgItemCompute();
        if (!this.verifyExports(items)) {
            return false;
        }
        if (items.size() == 1) {
            BatchItem item = items.iterator().next();
            this._dlgItem.setTitle(ResCompute.msgFormat("BATCH_DLG_CONFIG_TITLE", item.getTreePathForFiles()));
        } else {
            this._dlgItem.setTitle(ResCompute.getString("BATCH_DLG_CONFIG_TITLE_MULTIPLE"));
        }
        this._dlgItem.setBatchItems(items);
        this._dlgItem.setVisible(true);
        return this._dlgItem.getResult();
    }

    protected void editComputeConfiguration(int[] idxs) {
        LinkedHashMap<Integer, BatchItem> map = new LinkedHashMap<Integer, BatchItem>();
        for (int i : idxs) {
            BatchItem item = this.getModel().getItem(i);
            BatchItem copy = item.getCopy();
            map.put(i, copy);
        }
        if (this.displayDlgItemCompute(map.values())) {
            Object object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                int idx = (Integer)entry.getKey();
                BatchItem item = (BatchItem)entry.getValue();
                this.getModel().setItem(idx, item);
                item.setError(2, null);
            }
            HashMap<String, BatchItem> exportsFileMap = new HashMap<String, BatchItem>();
            int nbrItems = this._batch.getNbrItem();
            for (int i = 0; i < nbrItems; ++i) {
                this._batch.getItem(i).setError(2, null);
                this._batch.getItem(i).checkError(this._attributes, exportsFileMap);
            }
            this.getModel().fireTableChanged(new TableModelEvent(this.getModel(), 0, Integer.MAX_VALUE, 2, 0));
            for (Integer i : map.keySet()) {
                this._table.addRowSelectionInterval(i, i);
            }
            this._table.addColumnSelectionInterval(0, this._table.getColumnCount() - 1);
        }
        this.refreshCtrl();
    }

    protected void createDlgTree() {
        if (this._dlgTree == null) {
            this._dlgTree = new BatchItemTreeDlg(SwingUtilities.getWindowAncestor(this._table));
            this._dlgTree.pack();
            this._dlgTree.setLocationRelativeTo(this._table);
        }
    }

    protected void editTreeConfiguration(int[] idxs) {
        List<String> possibleConfigsStr;
        this.createDlgTree();
        ArrayList<BatchItem> listItems = new ArrayList<BatchItem>();
        for (int i : idxs) {
            BatchItem item = this.getModel().getItem(i);
            listItems.add(item);
        }
        ArrayList<List<FTConfig>> configs = new ArrayList<List<FTConfig>>();
        BatchItem firstElem = (BatchItem)listItems.iterator().next();
        String currentRoot = firstElem.getRootConfig();
        String currentConfig = firstElem.getTreeConfig();
        boolean selectCheckBox = currentRoot != null && !currentRoot.isEmpty();
        boolean notEmptyValue = !currentRoot.isEmpty();
        this.updateConfigs(firstElem, configs);
        boolean firstItem = true;
        for (BatchItem item : listItems) {
            if (firstItem) {
                firstItem = false;
                continue;
            }
            if (item.getRootConfig() != null && currentRoot != null && item.getRootConfig().isEmpty() && currentRoot.isEmpty()) {
                if (notEmptyValue) {
                    currentRoot = null;
                } else {
                    currentRoot = "";
                    selectCheckBox = false;
                }
            } else if (!(item.getRootConfig() == null || currentRoot == null || item.getRootConfig().isEmpty() || currentRoot.isEmpty() || item.getRootConfig().equals(currentRoot))) {
                currentRoot = "";
                selectCheckBox = true;
            } else if (!(currentRoot != null && (currentRoot.equals(item.getRootConfig()) || currentRoot.isEmpty() && item.getRootConfig().isEmpty()))) {
                currentRoot = null;
            }
            notEmptyValue &= !item.getRootConfig().isEmpty();
            if (!currentConfig.equals(item.getTreeConfig()) && !currentConfig.equals("")) {
                currentConfig = "";
            }
            this.updateConfigs(item, configs);
        }
        if (configs.size() == 0) {
            return;
        }
        ArrayList<FTConfig> possibleConfigs = new ArrayList<FTConfig>((Collection)configs.get(0));
        boolean onlyEmptyConfigs = ((List)configs.get(0)).isEmpty();
        for (int i = 1; i < configs.size(); ++i) {
            ArrayList<FTConfig> list = new ArrayList<FTConfig>();
            onlyEmptyConfigs &= list.isEmpty();
            for (FTConfig conf : (List)configs.get(i)) {
                if (!possibleConfigs.contains(conf)) continue;
                list.add(conf);
            }
            possibleConfigs = list;
        }
        if (possibleConfigs.isEmpty() && onlyEmptyConfigs) {
            possibleConfigs.add(new FTConfig().setName("Default"));
        }
        if ((possibleConfigsStr = possibleConfigs.stream().map(x -> x.getName()).collect(Collectors.toList())).size() == 0 && listItems.size() == 1) {
            possibleConfigsStr.add("Default");
        } else if (listItems.size() > 1 && (currentConfig == null || currentConfig.isEmpty())) {
            possibleConfigsStr.add(0, "");
        }
        this._dlgTree.configureRoot(selectCheckBox, currentRoot, listItems.size() > 1);
        this._dlgTree.configurateConfig(possibleConfigsStr, currentConfig);
        if (listItems.size() == 1) {
            this._dlgTree.setTitle(ResCompute.msgFormat("BATCH_DLG_TREE_TITLE", ((BatchItem)listItems.iterator().next()).getTreePathForFiles()));
        } else {
            this._dlgTree.setTitle(ResCompute.getString("BATCH_DLG_TREE_TITLE_MULTIPLE"));
        }
        this._dlgTree.setVisible(true);
        if (this._dlgTree.getResult()) {
            String root = this._dlgTree.getRoot();
            String newConf = this._dlgTree.getConfig();
            boolean isSelected = this._dlgTree.isRootSelected();
            boolean isPartial = this._dlgTree.isRootPartial();
            DAOFactory factory = this._plugable.getAppl().getDAOFactory();
            if (listItems.size() > 1) {
                for (BatchItem item : listItems) {
                    if (!isPartial) {
                        if (isSelected && root != null && !root.isEmpty()) {
                            item._treeRoot = root;
                        } else if (!isSelected && !isPartial) {
                            item._treeRoot = "";
                        }
                    }
                    if (!item._treeConfig.equals(newConf)) {
                        item.loadFromResult(newConf, ComputeType.MCS, factory);
                        item.loadFromResult(newConf, ComputeType.MEL, factory);
                    }
                    if (newConf != null && !newConf.isEmpty()) {
                        item._treeConfig = newConf;
                    }
                    item.setError(1, null);
                }
            } else {
                BatchItem item = (BatchItem)listItems.iterator().next();
                if (root != null) {
                    item._treeRoot = root;
                }
                if (!item._treeConfig.equals(newConf)) {
                    item.loadFromResult(newConf, ComputeType.MCS, factory);
                    item.loadFromResult(newConf, ComputeType.MEL, factory);
                }
                item._treeConfig = newConf;
                item.setError(1, null);
            }
        }
        this.getModel().fireTableDataChanged();
    }

    private void updateConfigs(BatchItem item, List<List<FTConfig>> configs) {
        try {
            DBWrap dbWrap;
            CECFactory cecFactory = (CECFactory)this._plugable.getAppl().getDAOFactory();
            DBFolder dbFolder = cecFactory.createFolderDAO().findFolder("PROJECTS", item.getTreePath());
            if (dbFolder != null && (dbWrap = cecFactory.findOrCreateWrap(dbFolder)) != null && dbWrap instanceof FTEquation) {
                FTEquation equation = (FTEquation)dbWrap;
                configs.add(equation.getConfigs());
            }
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Exception during read properties informations in SQL", e);
            return;
        }
    }

    protected void doLoadFolder(DBFolder dbFolder, Element elem) {
        throw new IllegalAccessError();
    }

    public void load(final File input) {
        CModelessThread action = new CModelessThread((Component)((Object)this)){
            IOException _except;
            {
                super(c);
                this._except = null;
            }

            protected void firstDo() {
                try {
                    BatchPanel.this._batch.load(input);
                    BatchPanel.this.checkErrors();
                    BatchPanel.this._ctrlSaveResults.setSelectedItem((Object)BatchPanel.this._batch.getSaveResults());
                    BatchPanel.this._ctrlIgnoreReference.setSelected(BatchPanel.this._batch.getIgnoreReference());
                    BatchPanel.this.refreshCtrl();
                }
                catch (IOException e) {
                    this._except = e;
                }
            }

            protected void invokeLater() {
                if (this._except != null) {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)((Object)BatchPanel.this)), ResMsgCore.getString((String)"FILE_ERROR_OPEN") + this._except.getMessage());
                }
            }
        };
        action.createAndStartThread("Batch/Load");
    }

    public void save(File output) {
        try {
            this._batch.save(output);
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)((Object)this)), ResMsgCore.getString((String)"FILE_ERROR_SAVE") + e1.getMessage());
        }
    }

    public void deleteRows() {
        int[] idx = this._table.getSelectedRows();
        for (int i = idx.length - 1; i >= 0; --i) {
            this.getModel().removeData(idx[i]);
        }
        if (idx.length > 0) {
            this.refreshCtrl();
        }
    }

    protected void createActions() {
        super.createActions();
        this._ctrlEditCompute = new CeciliaAction(ResIcoCompute.getImageIcon("BUT_EDIT_COMPUTE"), ResCompute.getString("ACTION_EDIT_COMPUTE_MENU"), ResCompute.getString("ACTION_EDIT_COMPUTE_TTIP")){

            public void actionPerformed(ActionEvent e) {
                int[] idxs = BatchPanel.this._table.getSelectedRows();
                if (idxs.length > 0) {
                    BatchPanel.this.editComputeConfiguration(idxs);
                } else {
                    _LOG.info("idxs no correct : " + idxs);
                }
            }
        };
        this._ctrlEditTree = new CeciliaAction(ResIcoCore.getImageIcon((String)"BUT_EDIT"), ResCompute.getString("ACTION_EDIT_TREE_MENU"), ResCompute.getString("ACTION_EDIT_TREE_TTIP")){

            public void actionPerformed(ActionEvent e) {
                int[] idxs = BatchPanel.this._table.getSelectedRows();
                if (idxs.length != 0) {
                    BatchPanel.this.editTreeConfiguration(idxs);
                } else {
                    _LOG.info("idx no correct : " + idxs);
                }
            }
        };
        this._ctrlUp = new CeciliaAction(ResIcoCore.getImageIcon((String)"BUT_UP"), ResCompute.getString("ACTION_UP_MENU"), ResCompute.getString("ACTION_UP_TTIP")){

            public void actionPerformed(ActionEvent e) {
                int idxMin = BatchPanel.this._table.getSelectionModel().getMinSelectionIndex();
                int idxMax = BatchPanel.this._table.getSelectionModel().getMaxSelectionIndex();
                if (idxMin != -1 && idxMin > 0) {
                    BatchPanel.this.getModel().up(idxMin, idxMax);
                    BatchPanel.this._table.setRowSelectionInterval(idxMin - 1, idxMax - 1);
                    BatchPanel.this.refreshCtrl();
                }
            }
        };
        this._ctrlDown = new CeciliaAction(ResIcoCore.getImageIcon((String)"BUT_DOWN"), ResCompute.getString("ACTION_DOWN_MENU"), ResCompute.getString("ACTION_DOWN_TTIP")){

            public void actionPerformed(ActionEvent e) {
                int idxMin = BatchPanel.this._table.getSelectionModel().getMinSelectionIndex();
                int idxMax = BatchPanel.this._table.getSelectionModel().getMaxSelectionIndex();
                if (idxMax != -1 && idxMax < BatchPanel.this.getModel().getRowCount() - 1) {
                    BatchPanel.this.getModel().down(idxMin, idxMax);
                    BatchPanel.this._table.setRowSelectionInterval(idxMin + 1, idxMax + 1);
                    BatchPanel.this.refreshCtrl();
                }
            }
        };
    }

    protected void createPopUp() {
        this._popupList = new JPopupMenu();
        this._popupList.add((Action)this._ctrlEditTree);
        this._popupList.add((Action)this._ctrlEditCompute);
        this._popupList.add((Action)this._ctrlDel);
        this._popupList.add((Action)this._ctrlUp);
        this._popupList.add((Action)this._ctrlDown);
        this._popupList.addSeparator();
        this._popupList.add((Action)this._ctrlLoad);
        this._popupList.add((Action)this._ctrlSave);
    }

    protected void addAction(JToolBar toolbar) {
        toolbar.add(this._ctrlLoad.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlSave.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createGlue());
        toolbar.add(this._ctrlEditTree.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlEditCompute.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlAdd.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlDel.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlUp.createButton(CeciliaAction.BorderStyle.LIGHT));
        toolbar.add(Box.createRigidArea(CeciliaAction.RIGID_AREA));
        toolbar.add(this._ctrlDown.createButton(CeciliaAction.BorderStyle.LIGHT));
    }

    public void createTable() {
        this._table = new JTable(this.getModel()){

            @Override
            public void createDefaultColumnsFromModel() {
                super.createDefaultColumnsFromModel();
                for (int col = 0; col < this.getColumnCount(); ++col) {
                    int width = 10;
                    switch (col) {
                        case 0: {
                            width = 30;
                            break;
                        }
                        case 1: {
                            width = 10;
                            break;
                        }
                        case 2: {
                            width = 25;
                        }
                    }
                    this.getColumnModel().getColumn(col).setPreferredWidth(13 * width);
                }
            }
        };
    }

    protected void addTableDecorator() {
        super.addTableDecorator();
        BatchTableRenderer renderer = new BatchTableRenderer();
        this._table.setDefaultRenderer(String.class, renderer);
        this._table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                Point p = e.getPoint();
                int row = BatchPanel.this._table.rowAtPoint(p);
                int column = BatchPanel.this._table.convertColumnIndexToModel(BatchPanel.this._table.columnAtPoint(p));
                if (row >= 0 && column >= 0) {
                    switch (column) {
                        case 1: {
                            BatchPanel.this.editTreeConfiguration(new int[]{row});
                            break;
                        }
                        case 2: {
                            BatchPanel.this.editComputeConfiguration(new int[]{row});
                        }
                    }
                }
            }
        });
    }

    protected JPanel createBottomPanel() {
        this._ctrlSaveResults = new JComboBox<BatchCompute.SaveResults>(BatchCompute.SaveResults.values());
        this._ctrlSaveResults.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (BatchPanel.this._ctrlSaveResults.isEnabled()) {
                    this.setText(((BatchCompute.SaveResults)((Object)value)).getLabel());
                } else {
                    this.setText("");
                }
                return this;
            }
        });
        this._ctrlSaveResults.setEditable(false);
        this._ctrlSaveResults.setSelectedItem((Object)this._batch.getSaveResults());
        this._ctrlSaveResults.addActionListener(e -> {
            if (!this._ctrlSaveResults.isEnabled()) {
                return;
            }
            this._batch.setSaveResults((BatchCompute.SaveResults)((Object)((Object)this._ctrlSaveResults.getSelectedItem())));
        });
        this._ctrlIgnoreReference = new JCheckBox(ResCompute.getString("DLG_PARAM_REF_IGNORE"));
        this._ctrlIgnoreReference.setSelected(this._batch.getIgnoreReference());
        this._ctrlIgnoreReference.addActionListener(e -> this._batch.setIgnoreReference(this._ctrlIgnoreReference.isSelected()));
        JPanel aPanel = new JPanel(new GridBagLayout());
        aPanel.add((Component)new JLabel(ResCompute.getString("BATCH_SAVE_LABEL")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        aPanel.add((Component)this._ctrlSaveResults, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        aPanel.add((Component)this._ctrlIgnoreReference, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        return aPanel;
    }

    protected void refreshCtrl() {
        super.refreshCtrl();
        int nbrSel = this._table.getSelectedRowCount();
        int nbrElt = this._table.getRowCount();
        boolean error = this._batch.withError();
        this._ctrlSave.setEnabled(nbrElt > 0 && !error);
        this._ctrlEditTree.setEnabled(nbrSel >= 1);
        this._ctrlEditCompute.setEnabled(nbrSel >= 1);
        this._ctrlUp.setEnabled(nbrSel > 0 && this._table.getSelectionModel().getMinSelectionIndex() > 0);
        this._ctrlDown.setEnabled(nbrSel > 0 && this._table.getSelectionModel().getMaxSelectionIndex() < nbrElt - 1);
    }

    public void generateNewFolders() {
        int nbrItems = this._batch.getNbrItem();
        for (int i = 0; i < nbrItems; ++i) {
            BatchItem item = this._batch.getItem(i);
            for (ExportItem expItem : item.getExports()) {
                File newFileParent;
                String absolutPath = expItem.getFile().getAbsolutePath();
                if (absolutPath.contains("%path%")) {
                    File newFile = new File(absolutPath.replace("%path%", ExportItem.getAcceptableTreePathFromOriginal(item.getTreePathForFiles(), false)));
                    expItem.setFile(newFile);
                }
                if ((newFileParent = expItem.getFile().getParentFile()).exists()) continue;
                newFileParent.mkdirs();
            }
        }
    }

    public void checkErrors() {
        this.createMapAttributes();
        HashMap<String, BatchItem> exportsFileMap = new HashMap<String, BatchItem>();
        int nbrItems = this._batch.getNbrItem();
        for (int i = 0; i < nbrItems; ++i) {
            BatchItem item = this._batch.getItem(i);
            item.clearError();
            try {
                CECFactory cecFactory = (CECFactory)this._plugable.getAppl().getDAOFactory();
                boolean accessError = false;
                FTEquation ftEqu = null;
                DAOFolder daoFolder = cecFactory.createFolderDAO();
                DBFolder dbFolder = daoFolder.findFolder("PROJECTS", item.getTreePath());
                if (dbFolder != null) {
                    if (daoFolder.getAccessRight(dbFolder, this._plugable.getAppl().getDBUser()) == DBAccess.Right.NONE) {
                        accessError = true;
                    } else {
                        DBWrap dbWrap = cecFactory.findOrCreateWrap(dbFolder);
                        if (dbWrap != null && dbWrap instanceof FTEquation && (ftEqu = (FTEquation)dbWrap) != null) {
                            item.setFTEquation(ftEqu);
                        }
                    }
                }
                if (accessError) {
                    item.setError(0, ResCompute.getString("BATCH_ERROR_ACCESSRIGHT"));
                } else if (ftEqu == null) {
                    item.setError(0, ResCompute.getString("BATCH_ERROR_TREEPATH"));
                } else if (!(ftEqu.getConfigs().isEmpty() && item.getTreeConfig().equalsIgnoreCase("Default") || ftEqu.getConfig(item.getTreeConfig()) != null)) {
                    item.setError(1, ResCompute.msgFormat("BATCH_ERROR_CONFIG", item.getTreeConfiguration()));
                }
            }
            catch (Exception e) {
                _LOG.log(Level.FINE, "Exception during read properties informations in SQL", e);
                item.setError(0, ResCompute.getString("BATCH_ERROR_TREEPATH"));
            }
            item.checkError(this._attributes, exportsFileMap);
        }
        this.getModel().fireTableDataChanged();
    }

    public boolean withError() {
        return this._batch.withError();
    }

    private final boolean verifyExports(Collection<BatchItem> items) {
        ArrayList<ExportItem> commonsExports = new ArrayList<ExportItem>();
        commonsExports.addAll(items.iterator().next().getExports());
        for (BatchItem batchItem : items) {
            commonsExports.retainAll(batchItem.getExports());
        }
        for (ExportItem exportItem : commonsExports) {
            if (!exportItem.getFile().getAbsolutePath().contains("%path%")) continue;
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)((Object)this)), ResCompute.msgFormat("BATCH_DLG_ERROR_PATH", exportItem.getFile().getAbsolutePath(), "%path%"), ResMsgVoc.getString((String)"VOC_ERROR"), 0);
            return false;
        }
        return true;
    }
}

