/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.bddmemory;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.bddmemory.OptionsAraliaTextField;
import java.awt.Component;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

class IntegerVerifier
extends InputVerifier {
    IntegerVerifier() {
    }

    @Override
    public boolean verify(JComponent input) {
        OptionsAraliaTextField textField = (OptionsAraliaTextField)input;
        String str = textField.getText();
        if (str.length() == 0) {
            return true;
        }
        boolean result = false;
        try {
            int value = Integer.parseInt(str);
            if (this.valueIsGood(value)) {
                result = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!result) {
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)textField), this.msgError(), ResCompute.getString("DLG_ARALIA_ERREUR"), 0);
            textField.setText(textField.getPreviousValue());
        }
        return result;
    }

    protected boolean valueIsGood(int value) {
        return value > 0 && value <= Integer.MAX_VALUE;
    }

    protected String msgError() {
        return ResCompute.msgFormat("DLG_ARALIA_REGLE_GENERALE_TEXTFIELD", 0, Integer.MAX_VALUE);
    }
}

