/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ComputeAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskFinally;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIEngineExecute;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIEnginePrepareMCS;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultCriticity;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultDisplayMCS;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultLoadMCS;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultParser;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultProbability;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultSaveMCS;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultSaveMCSWithoutCuts;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIStorePrepare;
import java.io.File;
import javax.swing.ImageIcon;

public class ComputeMCS
extends ComputeAbstract {
    ParamComputeMCS _parameters;
    BooleanResult _results;

    @Override
    public ParamComputeMCS getParameters() {
        return this._parameters;
    }

    public BooleanResult getResults() {
        return this._results;
    }

    public ComputeMCS() {
        this._parameters = new ParamComputeMCS();
        this._results = new BooleanResult(this._store, this._parameters);
    }

    public ComputeMCS(ParamComputeMCS parameters, BooleanResult results) {
        this._parameters = parameters;
        this._results = results;
        this._store = results.getStore();
    }

    @Override
    public void prepareCompute(TaskContainer task, EngineBDDAbstract engineBDD, String pathTree, final File resFile, InfoDatum idatum, Plugable launcher) {
        task.addItem(new TaskIStorePrepare(task, this._store, this._parameters));
        task.addItem(new TaskIEnginePrepareMCS(task, engineBDD, this._parameters, this._store, resFile));
        task.addItem(new TaskIEngineExecute(task, engineBDD));
        task.addItem(new TaskIResultParser(task, this._results, resFile));
        task.addItem(new TaskIResultProbability(task, this._results, this._parameters));
        task.addItem(new TaskIResultCriticity(task, this._results, this._parameters));
        if (this._parameters.isReferenceCompute() && this._parameters.getTypeProbability() != TypeProbability.ARP3) {
            task.addItem(new TaskIResultSaveMCS(task, this, idatum, launcher));
        } else {
            task.addItem(new TaskIResultSaveMCSWithoutCuts(task, this, idatum, launcher));
        }
        task.addItem(new TaskIResultDisplayMCS(task, this, launcher, idatum));
        task.addFinally(new TaskFinally(this, this._dagFile, this._xmlFile){

            @Override
            public void run() {
                super.run();
                if (resFile.exists() && (Boolean.getBoolean("cecilia.ft.compute.KeepFile") || !resFile.delete())) {
                    resFile.deleteOnExit();
                }
            }
        });
    }

    @Override
    public void prepareDisplay(TaskContainer task, boolean bComputeProbability, String pathTree, InfoDatum idatum, Plugable launcher) {
        task.addItem(new TaskIResultLoadMCS(task, this, idatum, launcher));
        task.addItem(new TaskIStorePrepare(task, this._store, this._parameters));
        task.addItem(new TaskIResultProbability(task, this._results, this._parameters));
        task.addItem(new TaskIResultCriticity(task, this._results, this._parameters));
        if (this._parameters.isReferenceCompute() && bComputeProbability && this._parameters.getTypeProbability() != TypeProbability.ARP3) {
            task.addItem(new TaskIResultSaveMCS(task, this, idatum, launcher));
        } else {
            task.addItem(new TaskIResultSaveMCSWithoutCuts(task, this, idatum, launcher));
        }
        task.addItem(new TaskIResultDisplayMCS(task, this, launcher, idatum));
    }

    @Override
    public String getTaskShort() {
        return ResCompute.getString("DLG_RESULT_CUTS");
    }

    @Override
    public String getTaskName() {
        return ResCompute.getString("PLUG_CMD_NOMINAL_NAME");
    }

    @Override
    public String getTaskDesc(boolean forCompute) {
        return ResCompute.getString(forCompute ? "TASK_TITLE_CUTS_COMPUTE" : "TASK_TITLE_CUTS_DISPLAY");
    }

    @Override
    public ImageIcon getTaskIcon() {
        return ResIcoCompute.getImageIcon("PLUGIN_MCS");
    }
}

