/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.core.plugin.InfoDatum;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMCS;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMEL;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResIcoCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ComputeMELAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDMEL;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineBDDMELSimple;
import com.dassault.cecilia.plugin.faulttree.compute.compute.EngineMELHelperAbstract;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMEL;
import com.dassault.cecilia.plugin.faulttree.compute.compute.PrepareMELSimple;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskFinally;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIEngineExecute;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIEngineLaunchMEL;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIEnginePrepareMEL;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultDisplayMEL;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultLoadMCSForMELSimple;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultLoadMEL;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIResultSaveMEL;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskIStorePrepare;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class ComputeMEL
extends ComputeMELAbstract {
    private static Logger _LOG = Logger.getLogger(ComputeMEL.class.getPackage().getName());

    public ComputeMEL() {
        this._parameters = new ParamComputeMEL();
    }

    public ComputeMEL(ParamComputeMEL parameters, BooleanMEL results) {
        super(parameters, results);
    }

    @Override
    public void prepareCompute(TaskContainer task, EngineBDDAbstract engineBDD, String pathTree, File resFile, InfoDatum idatum, Plugable launcher) {
        if (!resFile.delete()) {
            resFile.deleteOnExit();
        }
        if (this._parameters.isSimplifiedMode()) {
            BooleanMCS mcs = new BooleanMCS(this._store);
            task.addItem(new TaskIResultLoadMCSForMELSimple(task, this._store, mcs, idatum, launcher));
            task.addItem(new TaskIStorePrepare(task, this._store, this._parameters));
            PrepareMELSimple prepareMEL = new PrepareMELSimple(this._parameters, this._store);
            try {
                prepareMEL.run();
            }
            catch (IOException e) {
                task.addError(ResCompute.getString("MSG_ENGINE_ERR_PREPARE"));
                _LOG.log(Level.WARNING, "IOException during verify engine: " + e.getMessage(), e);
            }
            EngineBDDMELSimple computeMEL = new EngineBDDMELSimple();
            computeMEL.prepareCompute(prepareMEL, this._results, mcs, this._parameters);
            task.addItem(new TaskIEngineExecute(task, computeMEL));
            if (this._parameters.isReferenceCompute() && this._parameters.getTypeProbability() != TypeProbability.ARP3) {
                task.addItem(new TaskIResultSaveMEL(task, this, idatum, launcher));
            }
            task.addItem(new TaskIResultDisplayMEL(task, this, launcher, idatum));
        } else {
            task.addItem(new TaskIStorePrepare(task, this._store, this._parameters));
            if (this._parameters.getLimitOrder() > 0 && this._parameters.withPessimistCompute() && this._parameters.withMCSResult()) {
                BooleanMCS mcs = new BooleanMCS(this._store);
                task.addItem(new TaskIResultLoadMCSForMELSimple(task, this._store, mcs, idatum, launcher));
                ((EngineBDDMEL)engineBDD).setMCSForPessimistCompute(mcs);
            }
            TaskIEnginePrepareMEL taskIEnginePrepareMEL = new TaskIEnginePrepareMEL(task, engineBDD, this._parameters, this._store);
            task.addItem(taskIEnginePrepareMEL);
            EngineMELHelperInteractif helper = new EngineMELHelperInteractif(task);
            helper.prepare();
            task.addItem(new TaskIEngineLaunchMEL(task, (EngineBDDMEL)engineBDD, taskIEnginePrepareMEL, helper));
            if (this._parameters.isReferenceCompute() && this._parameters.getTypeProbability() != TypeProbability.ARP3) {
                task.addItem(new TaskIResultSaveMEL(task, this, idatum, launcher));
            }
            task.addItem(new TaskIResultDisplayMEL(task, this, launcher, idatum));
            task.addFinally(new TaskFinally(this, this._dagFile, this._xmlFile));
            task.addFinally(helper);
        }
    }

    @Override
    public void prepareDisplay(TaskContainer task, boolean bComputeProbability, String pathTree, InfoDatum idatum, Plugable launcher) {
        task.addItem(new TaskIStorePrepare(task, this._store, this._parameters));
        task.addItem(new TaskIResultLoadMEL(task, this, idatum));
        task.addItem(new TaskIResultDisplayMEL(task, this, launcher, idatum));
    }

    @Override
    public String getTaskShort() {
        return ResCompute.getString("DLG_RESULT_MEL");
    }

    @Override
    public String getTaskName() {
        return ResCompute.getString("PLUG_CMD_MEL_NAME");
    }

    @Override
    public String getTaskDesc(boolean forCompute) {
        return ResCompute.getString(forCompute ? "TASK_TITLE_MEL_COMPUTE" : "TASK_TITLE_MEL_DISPLAY");
    }

    @Override
    public ImageIcon getTaskIcon() {
        return ResIcoCompute.getImageIcon("PLUGIN_MEL");
    }

    class EngineMELHelperInteractif
    extends EngineMELHelperAbstract {
        TaskContainer _task;
        StringBuffer _warnings = new StringBuffer(512);

        EngineMELHelperInteractif(TaskContainer task) {
            this._task = task;
        }

        @Override
        public void addError(String msg) {
            this._task.addError(new StringBuffer(msg.length() + 128).append(this._currentTarget).append(" : ").append(msg).toString());
        }

        @Override
        public void addWarning(String msg) {
            if (this._warnings.length() > 0) {
                this._warnings.append("\n");
            }
            this._warnings.append(this._currentTarget).append(" : ").append(msg);
        }

        @Override
        public ParamComputeMEL getParameters() {
            return ComputeMEL.this._parameters;
        }

        @Override
        protected BooleanStore getStore() {
            return ComputeMEL.this._store;
        }

        @Override
        protected BooleanMEL getResult() {
            return ComputeMEL.this._results;
        }

        @Override
        public void run() {
            BooleanMEL.Item nominal;
            super.run();
            if (this._warnings.length() > 0 && !(nominal = ComputeMEL.this.getResults().getNominalItem()).isAlwaysTrue() && !nominal.isAlwaysFalse()) {
                this._task.addWarning(this._warnings.toString());
            }
        }
    }
}

