/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.compute;

import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.PartialCheckBox;
import com.dassault.cecilia.dbobj.faulttree.ft.TypeProbability;
import com.dassault.cecilia.plugin.faulttree.compute.ParamCompute;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.DlgPanelComputeStd;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DlgPanelComputeMCS
extends DlgPanelComputeStd {
    boolean _withoutPrGate = false;
    PartialCheckBox _ctrlPrGate = new PartialCheckBox(ResCompute.getString("DLG_PARAM_GATE"));
    List<ParamCompute.TypeImportanceFactor> _selectIFs;
    PartialCheckBox _ctrlIFCheck;
    JButton _ctrlIFBut;
    DlgImportanceFactors _dlgIF;

    public DlgPanelComputeMCS() {
        this._ctrlPrGate.setToolTipText(ResCompute.getString("DLG_PARAM_GATE"));
        this._ctrlPrGate.setAsymetricChangeValue(true);
        this._ctrlCutTruncated.addActionListener(e -> this.updateComputeProbabilityToolTip());
        this._ctrlIFCheck = new PartialCheckBox("");
        this._ctrlIFCheck.setAsymetricChangeValue(true);
        this._ctrlIFCheck.setSelected(false);
        this._ctrlIFCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = DlgPanelComputeMCS.this._ctrlIFCheck.isSelected();
                if (!isSelected) {
                    DlgPanelComputeMCS.this._selectIFs.clear();
                } else {
                    DlgPanelComputeMCS.this.displayDlgIF();
                }
            }
        });
        this._ctrlIFBut = new JButton(ResCompute.getString("DLG_PARAM_IF"));
        this._ctrlIFBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgPanelComputeMCS.this.displayDlgIF();
            }
        });
        this._selectIFs = new ArrayList<ParamCompute.TypeImportanceFactor>();
    }

    @Override
    protected void addOptionnalProbaCtrl(JPanel prbPanel, int x, int y, int width) {
        prbPanel.add((Component)this._ctrlPrGate, new GridBagConstraints(x, y, width, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 2, 5), 0, 0));
        JPanel ifPanel = new JPanel(new GridBagLayout());
        ifPanel.add((Component)this._ctrlIFCheck, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 0), 0, 0));
        ifPanel.add((Component)this._ctrlIFBut, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 5), 0, 0));
        prbPanel.add((Component)ifPanel, new GridBagConstraints(x, y + 1, width, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
    }

    @Override
    protected void updateCtrls() {
        boolean bddSelect;
        super.updateCtrls();
        TypeProbability typePr = this.getTypeProbability();
        boolean bl = bddSelect = typePr == TypeProbability.BDD;
        if (!bddSelect) {
            this._ctrlPrGate.setSelected(false);
            this._ctrlIFCheck.setSelected(false);
        }
        this._ctrlPrGate.setEnabled(bddSelect && !this._withoutPrGate);
        this.updateComputeProbabilityToolTip();
        this._ctrlIFCheck.setEnabled(bddSelect);
        this._ctrlIFBut.setEnabled(bddSelect);
    }

    void displayDlgIF() {
        if (this._dlgIF == null) {
            Window owner = SwingUtilities.getWindowAncestor(this._ctrlIFBut);
            this._dlgIF = new DlgImportanceFactors(owner);
        }
        this._dlgIF.setLocationRelativeTo(JOptionCecilia.getTopContainerOf((Component)this._ctrlIFBut));
        if (this._dlgIF.display(this._selectIFs)) {
            if (this._ctrlIFCheck.getState() == PartialCheckBox.State.PARTIAL && this._selectIFs.size() != 0) {
                this._ctrlIFCheck.setPartial(false);
                this._ctrlIFCheck.setSelected(true);
                this._ctrlIFCheck.updateUI();
            } else if (this._ctrlIFCheck.getState() != PartialCheckBox.State.PARTIAL) {
                this._ctrlIFCheck.setSelected(this._selectIFs.size() != 0);
            }
        } else {
            this._ctrlIFCheck.setSelected(this._selectIFs.size() != 0);
        }
    }

    public void defaultValues() {
        this._ctrlPrGate.setSelected(false);
        this._ctrlIFCheck.setSelected(false);
        this._selectIFs.clear();
    }

    private void updateComputeProbabilityToolTip() {
        if (this._ctrlCutTruncated.isSelected()) {
            this._ctrlPrGate.setToolTipText(ResCompute.getString("COMPUTE_PROBA_INTERMEDIATE_WITH_CUT_WARNING"));
        } else {
            this._ctrlPrGate.setToolTipText(ResCompute.getString("DLG_PARAM_GATE"));
        }
    }

    class DlgImportanceFactors
    extends JDialogCecilia {
        Map<ParamCompute.TypeImportanceFactor, JCheckBox> _checkboxs;

        DlgImportanceFactors(Window owner) {
            super(owner, ResCompute.getString("DLG_PARAM_IF"), true);
            this._checkboxs = new LinkedHashMap<ParamCompute.TypeImportanceFactor, JCheckBox>();
            ParamCompute.TypeImportanceFactor[] IFs = ParamCompute.TypeImportanceFactor.values();
            JPanel panel = new JPanel(new GridLayout(IFs.length, 1));
            for (int i = 0; i < IFs.length; ++i) {
                JCheckBox chk = new JCheckBox(IFs[i].getLabel());
                this._checkboxs.put(IFs[i], chk);
                panel.add(chk);
            }
            this.getContentPane().setLayout(new GridBagLayout());
            this.getContentPane().add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.getContentPane().add((Component)this.createButPanel(true), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.pack();
            this.setResizable(false);
        }

        protected boolean verifyParameters() {
            return true;
        }

        boolean display(List<ParamCompute.TypeImportanceFactor> selectIFs) {
            for (JCheckBox jCheckBox : this._checkboxs.values()) {
                jCheckBox.setSelected(false);
            }
            for (ParamCompute.TypeImportanceFactor typeImportanceFactor : selectIFs) {
                this._checkboxs.get((Object)typeImportanceFactor).setSelected(true);
            }
            this._result = false;
            this.setVisible(true);
            if (this._result) {
                selectIFs.clear();
                for (Map.Entry entry : this._checkboxs.entrySet()) {
                    if (!((JCheckBox)entry.getValue()).isSelected()) continue;
                    selectIFs.add((ParamCompute.TypeImportanceFactor)((Object)entry.getKey()));
                }
            }
            return this._result;
        }
    }
}

