/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.export;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.DBKTableModel;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.dbobj.general.attrib.Attr;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanResult;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.CAAItem;
import com.dassault.cecilia.plugin.faulttree.compute.CAASelector;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.compute.ParamComputeMCS;
import com.dassault.cecilia.plugin.faulttree.compute.export.ExportMCS;
import com.dassault.cecilia.plugin.faulttree.compute.pref.PrintExportMCS;
import com.dassault.cecilia.plugin.faulttree.compute.results.MCSFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ExportCAA
extends ExportMCS {
    CAAItem _rootItem;
    CAASelector _caaSelector;

    public ExportCAA(BooleanStore store, ParamComputeMCS parameters, BooleanResult result, CAAItem rootItem, CAASelector caaSelector, PrintExportMCS prefs, MCSFilter mcsFilter) {
        super(store, parameters, result, rootItem, prefs);
        this._rootItem = rootItem;
        this._caaSelector = caaSelector;
        this._filter = mcsFilter;
    }

    @Override
    public void exportFormatScribe(SrbInputStream outScribe) {
        outScribe.concat("<GDOC SEC=''>\n");
        outScribe.concat("<TITLE>" + ResCompute.getString("KEY_0732") + "\n");
        outScribe.concat("<DOCNUM>\n");
        outScribe.concat("<DATE>" + ExportCAA.getCurrentDateAsDDMMYYYY() + "\n");
        outScribe.concat(".ti @\n");
        outScribe.concat(".tp 5 7 18 20 30 35 40 50 60\n");
        outScribe.concat("<BODY>\n");
        this.exportScribeBegining(outScribe);
        this.exportScribeFilterConfiguration(outScribe);
        outScribe.concat("<EUL>\n");
        outScribe.concat(".sk 1\n");
        this.exportScribeDSFConfiguration(outScribe);
        this.exportScribeCAASummary(outScribe);
        this.exportScribeCAACuts(outScribe);
        if (this._prefs.getBooleanValue("Content.MCSInCAA")) {
            this.exportScribeCAATable(outScribe);
            this.exportScribeMCSReminder(outScribe);
        }
        this.exportScribeMCSToC(outScribe);
    }

    @Override
    protected void exportScribeFilterConfiguration(SrbInputStream outScribe) {
        String msg;
        outScribe.concat("<H1>" + ResCompute.getString("KEY_0733") + "\n");
        outScribe.concat("<UL>\n");
        if (this._result != null && (msg = this._result.getWarning()) != null) {
            outScribe.concat("<LI>" + msg + "\n.br \n");
        }
        int level = 1;
        for (Attr.Key attr : this._caaSelector.getAttributes()) {
            outScribe.concat("<LI>" + ResCompute.msgFormat("CAA_ATTRIBUTE_LEVEL", level) + " :<HP2>");
            outScribe.concat(attr.getName());
            outScribe.concat("<EHP2>\n");
            outScribe.concat(".br \n");
            ++level;
        }
        outScribe.concat("<LI>" + ResCompute.getString("CAA_MERGE_VALUES") + " :<HP2>");
        outScribe.concat(ResMsgVoc.getString((String)(this._caaSelector.getMerge() ? "VOC_YES" : "VOC_NO")));
        outScribe.concat("<EHP2>\n");
        outScribe.concat(".br \n");
        if (this._filter != null) {
            outScribe.concat("<LI>" + ResCompute.getString("DLG_RESULT_SORTER") + " : <HP2>" + this._filter.getTypeSorter().getLabel() + "<EHP2>\n");
            outScribe.concat(".br \n");
            int rankLimit = this._filter.getRankLimit();
            if (rankLimit > 0) {
                outScribe.concat("<LI>" + ResCompute.getString("KEY_0744") + " : <HP2>" + Integer.toString(rankLimit) + "<EHP2>\n");
                outScribe.concat(".br \n");
            }
        }
        if (this._prefs.getPrefLevel() > 0) {
            outScribe.concat("<LI>" + ResCompute.getString("EXPORT_CAA_FILTER") + " : <HP2>" + this._prefs.getPrefLevel() + "<EHP2>\n");
        }
    }

    private void exportScribeCAASummary(SrbInputStream outScribe) {
        outScribe.concat("<H1>" + ResCompute.getString("CAA_EXPORT_ATTRIBUTE_CUTS_TABLE") + "\n");
        outScribe.concat("<UL>\n");
        outScribe.concat("<LI>" + ResCompute.getString("CAA_EXPORT_NBR_OF_CUTS") + " : <HP2>" + this._mcsOrigin.getCutCount() + "<EHP2>\n");
        outScribe.concat(".br \n");
        outScribe.concat("<EUL>\n");
        outScribe.concat(".sk 1\n");
        outScribe.concat("<TABLEAU>\n");
        outScribe.concat("<TABTIT>" + ResCompute.getString("KEY_0747") + "\n");
        outScribe.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_ORDER") + "\n");
        outScribe.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_QUANTITY") + "\n");
        outScribe.concat("<TABDEF CWIDTH = '10 12'   ALIGN = 'C C'>\n");
        for (int c = 0; c < this._mcsOrigin.getOrderMax(); ++c) {
            int q = this._mcsOrigin.getOrderNumber(c);
            if (q <= 0) continue;
            outScribe.concat("<C>" + c + "\n");
            if (q > 1000000000) {
                outScribe.concat("<C>> 1000000000\n");
                continue;
            }
            outScribe.concat("<C>" + q + "\n");
        }
        outScribe.concat("<ETABLEAU>\n");
    }

    private void exportScribeCAACuts(SrbInputStream outScribe) {
        outScribe.concat("<H1>" + ResCompute.getString("KEY_5013") + "\n");
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(ResMsgVoc.getString((String)"VOC_NUMBER"));
        headers.add(ResCompute.getString("KEY_0589"));
        int curOrder = -1;
        int lvlOrder = this._prefs.getPrefLevel();
        ArrayList rows = new ArrayList<List>();
        int curIndex = 1;
        MCS.CutIterator iCut = this._mcsOrigin.cutIterate();
        while (iCut.hasNext()) {
            Cut cut = iCut.next();
            int order = cut.getOrder();
            if (lvlOrder > 0 && order > lvlOrder) break;
            if (curOrder != order) {
                if (rows.size() > 0) {
                    this.exportScribeCAACuts(outScribe, rows, curOrder);
                }
                curOrder = order;
                rows = new ArrayList();
                curIndex = 1;
            }
            for (int e = 0; e < order; ++e) {
                Evt evt = cut.getEvent(e);
                ArrayList<String> row = new ArrayList<String>();
                if (e == 0) {
                    row.add(Integer.toString(curIndex));
                } else {
                    row.add(" ");
                }
                row.add(evt.getName());
                rows.add(row);
            }
            ++curIndex;
        }
        if (rows.size() > 0) {
            this.exportScribeCAACuts(outScribe, rows, curOrder);
        }
    }

    private void exportScribeCAACuts(SrbInputStream outScribe, List<List> rows, int cutOrder) {
        outScribe.concat("<H2>" + ResCompute.getString("KEY_5014") + " (" + cutOrder + ")\n");
        outScribe.concat("<TABLEAU>\n");
        outScribe.concat("<TABTIT>" + ResCompute.getString("KEY_5015") + "\n");
        outScribe.concat("<TABCOL>" + ResMsgVoc.getString((String)"VOC_NUMBER") + "\n");
        outScribe.concat("<TABCOL>" + ResCompute.getString("KEY_0589") + "\n");
        outScribe.concat("<TABDEF CWIDTH = '7 30'   ALIGN = 'C L'>\n");
        for (List l : rows) {
            for (Object obj : l) {
                outScribe.concat("<C>" + obj.toString() + "\n");
            }
        }
        outScribe.concat("<ETABLEAU>\n");
    }

    private void exportScribeCAATable(SrbInputStream outScribe) {
        outScribe.concat("<H1>" + ResCompute.getString("KEY_0748") + "\n");
        for (int i = 0; i < this._rootItem.getChildCount(); ++i) {
            this.exportScribeCAATable(outScribe, this._rootItem.getChildAt(i), 2);
        }
    }

    private void exportScribeCAATable(SrbInputStream outScribe, CAAItem current, int level) {
        if (this._prefs.getPrefLevel() > 0 && current.getCAACut().getOrder() > this._prefs.getPrefLevel()) {
            return;
        }
        StringBuffer title = new StringBuffer(256);
        title.append("<H").append(level).append(">");
        title.append(ResMsgVoc.getString((String)"VOC_ATTRIBUTE")).append(" : ");
        title.append(current.getCAACut().getAttribute().getName()).append(" ");
        title.append(current.getCAACut().printCuts());
        title.append("\n");
        outScribe.concat(title.toString());
        if (current.getChildCount() == 0) {
            MCS mcsFilter = current.getMCS();
            if (this._filter != null) {
                mcsFilter = this._filter.filterMCS(mcsFilter);
            }
            this.exportScribeMCSTable(outScribe, mcsFilter);
        } else {
            for (int i = 0; i < current.getChildCount(); ++i) {
                this.exportScribeCAATable(outScribe, current.getChildAt(i), level + 1);
            }
        }
    }

    @Override
    public void exportFormatDocBook(DBKOutput xmlWriter) throws IOException {
        if (xmlWriter.getXmlOutputFile() == null) {
            return;
        }
        xmlWriter.printHeadXML();
        xmlWriter.write("<title>", false);
        xmlWriter.write(ResCompute.getString("KEY_0732"), true);
        xmlWriter.write("</title>\n", false);
        this.exportDocBookBegining(xmlWriter);
        this.exportDocBookFilterConfiguration(xmlWriter);
        this.exportDocBookDSFConfiguration(xmlWriter);
        this.exportDocBookCAASummary(xmlWriter);
        this.exportDocBookCAACuts(xmlWriter);
        if (this._prefs.getBooleanValue("Content.MCSInCAA")) {
            this.exportDocBookCAATable(xmlWriter);
            this.exportDocBookMCSReminder(xmlWriter);
        }
        xmlWriter.printFootXML();
    }

    @Override
    protected void exportDocBookFilterConfiguration(DBKOutput xmlWriter) throws IOException {
        String msg;
        xmlWriter.writeSection(1, ResCompute.getString("KEY_0733"));
        if (this._result != null && (msg = this._result.getWarning()) != null) {
            xmlWriter.write("<para>", false);
            xmlWriter.write(msg, true);
            xmlWriter.write("</para>\n", false);
        }
        int level = 1;
        for (Attr.Key attr : this._caaSelector.getAttributes()) {
            xmlWriter.write("<para>", false);
            xmlWriter.write(ResCompute.msgFormat("CAA_ATTRIBUTE_LEVEL", level) + " : " + attr.getName(), true);
            xmlWriter.write("</para>\n", false);
            ++level;
        }
        xmlWriter.write("<para>", false);
        xmlWriter.write(ResCompute.getString("CAA_MERGE_VALUES") + " : " + ResMsgVoc.getString((String)(this._caaSelector.getMerge() ? "VOC_YES" : "VOC_NO")), true);
        xmlWriter.write("</para>\n", false);
        if (this._filter != null) {
            xmlWriter.write("<para>", false);
            xmlWriter.write(ResCompute.getString("DLG_RESULT_SORTER") + " : " + this._filter.getTypeSorter().getLabel(), true);
            xmlWriter.write("</para>\n", false);
            int rankLimit = this._filter.getRankLimit();
            if (rankLimit > 0) {
                xmlWriter.write("<para>", false);
                xmlWriter.write(ResCompute.getString("KEY_0744") + " : " + Integer.toString(rankLimit), true);
                xmlWriter.write("</para>\n", false);
            }
        }
        if (this._prefs.getPrefLevel() > 0) {
            xmlWriter.write("<para>", false);
            xmlWriter.write(ResCompute.getString("EXPORT_CAA_FILTER") + " : " + this._prefs.getPrefLevel(), true);
            xmlWriter.write("</para>\n", false);
        }
        xmlWriter.writeEndSection(1);
    }

    private void exportDocBookCAASummary(DBKOutput xmlWriter) throws IOException {
        xmlWriter.writeSection(1, ResCompute.getString("CAA_EXPORT_ATTRIBUTE_CUTS_TABLE"));
        xmlWriter.write("<para>", false);
        xmlWriter.write(ResCompute.getString("CAA_EXPORT_NBR_OF_CUTS") + " : " + this._mcsOrigin.getCutCount(), true);
        xmlWriter.write("</para>\n", false);
        ArrayList rows = new ArrayList();
        for (int c = 0; c < this._mcsOrigin.getOrderMax(); ++c) {
            int q = this._mcsOrigin.getOrderNumber(c);
            if (q <= 0) continue;
            ArrayList<String> row = new ArrayList<String>();
            row.add(Integer.toString(c));
            if (q > 1000000000) {
                row.add("> 1000000000");
            } else {
                row.add(Integer.toString(q));
            }
            rows.add(row);
        }
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(ResMsgVoc.getString((String)"VOC_ORDER"));
        headers.add(ResMsgVoc.getString((String)"VOC_QUANTITY"));
        DBKTableModel tableModel = new DBKTableModel(rows, headers, DBKTableModel.DataType.OBJECTS);
        xmlWriter.insertTable(tableModel);
        xmlWriter.writeEndSection(1);
    }

    private void exportDocBookCAACuts(DBKOutput xmlWriter) throws IOException {
        xmlWriter.writeSection(1, ResCompute.getString("KEY_5013"));
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(ResMsgVoc.getString((String)"VOC_NUMBER"));
        headers.add(ResCompute.getString("KEY_0589"));
        int curOrder = -1;
        int lvlOrder = this._prefs.getPrefLevel();
        ArrayList rows = new ArrayList();
        ArrayList moreRows = new ArrayList();
        int curIndex = 1;
        MCS.CutIterator iCut = this._mcsOrigin.cutIterate();
        while (iCut.hasNext()) {
            Cut cut = iCut.next();
            int order = cut.getOrder();
            if (lvlOrder > 0 && order > lvlOrder) break;
            if (curOrder != order) {
                if (rows.size() > 0) {
                    xmlWriter.writeSection(2, ResCompute.getString("KEY_5014") + " ( " + curOrder + ")");
                    DBKTableModel tableModel = new DBKTableModel(rows, headers, moreRows, DBKTableModel.DataType.OBJECTS);
                    xmlWriter.insertTable(tableModel);
                    xmlWriter.writeEndSection(2);
                }
                curOrder = order;
                rows = new ArrayList();
                moreRows = new ArrayList();
                curIndex = 1;
            }
            for (int e = 0; e < order; ++e) {
                Evt evt = cut.getEvent(e);
                ArrayList<String> row = new ArrayList<String>();
                ArrayList<Integer> moreRow = new ArrayList<Integer>();
                if (e == 0) {
                    row.add(Integer.toString(curIndex));
                    moreRow.add(order - 1);
                } else {
                    row.add(" ");
                    moreRow.add(-1);
                }
                row.add(evt.getName());
                moreRow.add(0);
                rows.add(row);
                moreRows.add(moreRow);
            }
            ++curIndex;
        }
        if (rows.size() > 0) {
            xmlWriter.writeSection(2, ResCompute.getString("KEY_5014") + " ( " + curOrder + ")");
            DBKTableModel tableModel = new DBKTableModel(rows, headers, moreRows, DBKTableModel.DataType.OBJECTS);
            xmlWriter.insertTable(tableModel);
            xmlWriter.writeEndSection(2);
        }
        xmlWriter.writeEndSection(1);
    }

    private void exportDocBookCAATable(DBKOutput xmlWriter) throws IOException {
        xmlWriter.writeSection(1, ResCompute.getString("KEY_0748"));
        for (int i = 0; i < this._rootItem.getChildCount(); ++i) {
            this.exportDocBookCAATable(xmlWriter, this._rootItem.getChildAt(i), 2);
        }
        xmlWriter.writeEndSection(1);
    }

    private void exportDocBookCAATable(DBKOutput xmlWriter, CAAItem current, int level) throws IOException {
        if (this._prefs.getPrefLevel() > 0 && current.getCAACut().getOrder() > this._prefs.getPrefLevel()) {
            return;
        }
        StringBuffer title = new StringBuffer(256);
        title.append(ResMsgVoc.getString((String)"VOC_ATTRIBUTE")).append(" : ");
        title.append(current.getCAACut().getAttribute().getName()).append(" ");
        title.append(current.getCAACut().printCuts());
        xmlWriter.writeSection(level, title.toString());
        if (current.getChildCount() == 0) {
            MCS mcsFilter = current.getMCS();
            if (this._filter != null) {
                mcsFilter = this._filter.filterMCS(mcsFilter);
            }
            this.exportDocBookMCSTable(xmlWriter, mcsFilter);
        } else {
            for (int i = 0; i < current.getChildCount(); ++i) {
                this.exportDocBookCAATable(xmlWriter, current.getChildAt(i), level + 1);
            }
        }
        xmlWriter.writeEndSection(level);
    }
}

