/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.melsynthesis;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.dbobj.faulttree.ft.FTEquation;
import com.dassault.cecilia.dbobj.project.CriticityCriterion;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import com.dassault.cecilia.main.cecilia.CeciliaAppl;
import com.dassault.cecilia.plugin.faulttree.compute.BooleanMEL;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.melsynthesis.MELResult;
import com.dassault.cecilia.plugin.faulttree.compute.melsynthesis.MELSynthesisCell;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class MELSynthesisExport {
    private final CeciliaAppl _cAppl;
    private final List<MELResult> _results;
    private final Writer _out;
    private final Map<String, List<MELSynthesisCell>> _eventsToProba;
    private final DoubleFormat _format;

    public MELSynthesisExport(CeciliaAppl cAppl, Writer out, List<MELResult> results, Map<String, List<MELSynthesisCell>> eventsToProba) {
        this._cAppl = cAppl;
        this._results = results;
        this._out = out;
        this._eventsToProba = eventsToProba;
        this._format = ((GeneralTextPreferencies)cAppl.getPreferencies().getItem(GeneralTextPreferencies.PREF_KEY).getPlug()).getDoubleFormat();
    }

    public boolean start() throws IOException {
        try {
            this.writeHeader();
            this.writeContent();
            this.writeFooter();
        }
        catch (IOException error) {
            error.printStackTrace();
            return false;
        }
        return true;
    }

    private void writeHeader() throws IOException {
        this._out.write("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n");
        this._out.write("<?mso-application progid=\"Excel.Sheet\"?>\n");
        this._out.write("<Workbook xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\"\n");
        this._out.write("  xmlns:o=\"urn:schemas-microsoft-com:office:office\"\n");
        this._out.write("  xmlns:x=\"urn:schemas-microsoft-com:office:excel\"\n");
        this._out.write("  xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\"\n");
        this._out.write("  xmlns:html=\"http://www.w3.org/TR/REC-html40\">\n");
        this._out.write(" <DocumentProperties xmlns=\"urn:schemas-microsoft-com:office:office\"/>\n");
        this._out.write(" <OfficeDocumentSettings xmlns=\"urn:schemas-microsoft-com:office:office\"/>\n");
        this._out.write(" <ExcelWorkbook xmlns=\"urn:schemas-microsoft-com:office:excel\"/>\n");
        this._out.write(" <Styles>\n");
        this._out.write("  <Style ss:ID='Default'>\n");
        this._out.write("   <Alignment ss:Vertical='Center' ss:Horizontal='Center' ss:WrapText='1'/>\n");
        this._out.write("   <NumberFormat ss:Format='True/False'/>\n");
        this._out.write("  </Style>\n");
        this._out.write(" </Styles>\n");
    }

    private void writeContent() throws IOException {
        this._out.append(" <Worksheet ss:Name=\"").append("MEL Synthesis").append("\">\n");
        this._out.append("  <Table ss:ExpandedColumnCount=\"").append(Integer.toString(this._results.size() + 2)).append("\" ss:ExpandedRowCount=\"").append(Integer.toString(this._eventsToProba.size() + 10)).append("\" x:FullColumns=\"1\"\n");
        this._out.append("   x:FullRows=\"1\" ss:DefaultColumnWidth=\"36.6\">\n");
        this._out.append("   <Column/>\n");
        for (int i = 1; i < this._results.size() + 2; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append("   <Column ss:Width='");
            sb.append(String.valueOf(i == 1 ? 200 : 100));
            sb.append("'/>\n");
            this._out.append(sb.toString());
        }
        this._out.append("   <Row>\n");
        this._out.append("   </Row>\n");
        this.writeResults();
        this._out.append("  </Table>\n");
        this._out.append("  <WorksheetOptions xmlns=\"urn:schemas-microsoft-com:office:excel\">\n");
        this._out.append("    <Zoom>80</Zoom>\n");
        this._out.append("  </WorksheetOptions>\n");
        this._out.append(" </Worksheet>\n");
    }

    private void writeFooter() throws IOException {
        this._out.write("</Workbook>\n");
    }

    private void writeResults() throws IOException {
        String res;
        this._out.append("   <Row ss:AutoFitHeight=\"1\">\n");
        this.addCell("");
        this.addCell(ResCompute.getString("MSG_MEL_EVENT_NAME"));
        for (MELResult mELResult : this._results) {
            this.addCell(mELResult.getEqu().getTopEvent().getName());
        }
        this._out.append("   </Row>\n");
        this._out.append("   <Row ss:AutoFitHeight=\"1\">\n");
        this.addCell("");
        this.addCell(ResCompute.getString("MSG_MEL_EXPORT_PATH"));
        for (MELResult mELResult : this._results) {
            this.addCell(mELResult.getEqu().getRefPath());
        }
        this._out.append("   </Row>\n");
        this._out.append("   <Row ss:AutoFitHeight=\"1\">\n");
        this.addCell("");
        this.addCell(ResCompute.getString("MSG_MEL_EXPORT_TREENAME"));
        for (MELResult mELResult : this._results) {
            this.addCell(mELResult.getEqu().getDBFolder().getParent().getName());
        }
        this._out.append("   </Row>\n");
        this._out.append("   <Row ss:AutoFitHeight=\"1\">\n");
        this.addCell("");
        this.addCell(ResCompute.getString("MSG_MEL_EXPORT_CONFIG"));
        for (MELResult mELResult : this._results) {
            this.addCell(mELResult.getConfig() != null ? mELResult.getConfig() : "Default");
        }
        this._out.append("   </Row>\n");
        this._out.append("   <Row ss:AutoFitHeight=\"1\">\n");
        this.addCell("");
        this.addCell(ResCompute.getString("MSG_MEL_EXPORT_SEVERITY"));
        for (MELResult mELResult : this._results) {
            res = mELResult.getEqu().getCriticityLevel();
            this.addCell(res == null ? "Not OK - " + ResCompute.getString("MSG_SYNTHESIS_MEL_NO_SEVERITY_ASSIGNED") : res);
        }
        this._out.append("   </Row>\n");
        this._out.append("   <Row ss:AutoFitHeight=\"1\">\n");
        this.addCell("");
        this.addCell(ResMsgVoc.getString((String)"VOC_TRUNCATED"));
        for (MELResult mELResult : this._results) {
            if (mELResult.getParameters() == null) {
                this.addCell("");
                continue;
            }
            if (mELResult.getParameters().getLimitOrder() > 0) {
                this.addCell(Integer.toString(mELResult.getParameters().getLimitOrder()));
                continue;
            }
            this.addCell("-");
        }
        this._out.append("   </Row>\n");
        this._out.append("   <Row ss:AutoFitHeight=\"1\">\n");
        this.addCell("");
        this.addCell(ResMsgVoc.getString((String)"VOC_TYPE"));
        for (MELResult mELResult : this._results) {
            if (mELResult.getParameters() == null) {
                this.addCell("");
                continue;
            }
            this.addCell(mELResult.getParameters().getTypeProbability().getLabel());
        }
        this._out.append("   </Row>\n");
        this._out.append("   <Row ss:AutoFitHeight=\"1\">\n");
        this.addCell("");
        this.addCell(ResMsgVoc.getString((String)"VOC_TIME"));
        for (MELResult mELResult : this._results) {
            if (mELResult.getParameters() == null) {
                this.addCell("");
                continue;
            }
            this.addCell(Double.toString(mELResult.getParameters().getMissionTimeH()));
        }
        this._out.append("   </Row>\n");
        this._out.append("   <Row ss:AutoFitHeight=\"1\">\n");
        this.addCell("");
        this.addCell(ResCompute.getString("MSG_MEL_EXPORT_CMPT_PROBA"));
        for (MELResult mELResult : this._results) {
            res = null;
            res = mELResult.getMelResult() == null || mELResult.getMelResult().getNominalItem() == null ? ResCompute.getString("MSG_SYNTHESIS_MEL_ERROR_READ_COMPUTATION") : this.getResultNominal(mELResult);
            this.addCell(res);
        }
        this._out.append("   </Row>\n");
        for (Map.Entry entry : this._eventsToProba.entrySet()) {
            this._out.append("   <Row ss:AutoFitHeight=\"1\">\n");
            this.addCell("");
            this.addCell((String)entry.getKey());
            for (MELSynthesisCell val : (List)entry.getValue()) {
                String proba = val.getProbability();
                String mess = val.getMess();
                boolean isOk = val.isOK();
                if (proba == null || proba.isEmpty() || proba.equals(String.valueOf(Double.NaN))) {
                    this.addCell("-");
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(String.valueOf(proba));
                sb.append("&#10;");
                sb.append(isOk ? "OK" : "Not OK");
                if (!isOk) {
                    sb.append("&#10;");
                    sb.append(mess);
                }
                this.addCell(sb.toString());
            }
            this._out.append("   </Row>\n");
        }
    }

    private void addCell(String txt) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("    <Cell><Data ss:Type=\"String\">");
        sb.append(this.escapedXML(txt));
        sb.append("</Data></Cell>\n");
        this._out.append(sb.toString());
    }

    private String escapedXML(String txt) {
        String result = txt.replace("'", "&apos;");
        result = result.replace("<", "&lt;");
        result = result.replace(">", "&gt;");
        result = result.replace("\"", "&quot;");
        return result;
    }

    public static CriticityCriterion getCriticity(CeciliaAppl cAppl, FTEquation equ) {
        String criticityName = equ.getCriticityLevel();
        List criticities = equ.getProjectCriticities(cAppl);
        if (criticities == null) {
            return null;
        }
        for (CriticityCriterion criticity : criticities) {
            if (!criticity.getName().equals(criticityName)) continue;
            return criticity;
        }
        return null;
    }

    private String getResultNominal(MELResult result) {
        CriticityCriterion criticity = MELSynthesisExport.getCriticity(this._cAppl, result.getEqu());
        BooleanMEL.Item item = result.getMelResult().getNominalItem();
        double proba = item.getProbability();
        String probaStr = this._format != null ? this._format.format(proba) : String.valueOf(proba);
        boolean isCorrectProba = proba < criticity.getProbability();
        boolean isCorrectOrder = true;
        int maxOrder = criticity.getOrder();
        for (int i = 0; i <= maxOrder && isCorrectOrder; ++i) {
            long numberCuts = item.getOrderNumber(i);
            if (numberCuts < 1L) continue;
            isCorrectOrder = false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(probaStr);
        sb.append("&#10;");
        sb.append(isCorrectProba && isCorrectOrder ? "OK" : "Not OK");
        sb.append("&#10;");
        if (!isCorrectProba && !isCorrectOrder) {
            sb.append(ResCompute.getString("MSG_MEL_QUANTITATIVE_OBJECTIVE"));
            sb.append("/");
            sb.append(ResCompute.getString("MSG_MEL_QUALITATIVE_OBJECTIVE"));
        } else if (!isCorrectProba) {
            sb.append(ResCompute.getString("MSG_MEL_QUANTITATIVE_OBJECTIVE"));
        } else if (!isCorrectOrder) {
            sb.append(ResCompute.getString("MSG_MEL_QUALITATIVE_OBJECTIVE"));
        }
        return sb.toString();
    }
}

