/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.results;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.pref.PrefFieldBoolean;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemAbstractColumnsModel;
import com.dassault.cecilia.dbobj.faulttree.gui.ItemTableModel;
import com.dassault.cecilia.plugin.faulttree.compute.Cut;
import com.dassault.cecilia.plugin.faulttree.compute.Evt;
import com.dassault.cecilia.plugin.faulttree.compute.MCS;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.results.ArborRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class MCSTableModel
implements ItemTableModel {
    ItemAbstractColumnsModel _columnsModel;
    MCS _mcs;
    ArborRenderer _renderer;
    protected EventListenerList _listenerList = new EventListenerList();
    public static final String MCS_FIELD_CUT = "coupe";
    public static final String MCS_FIELD_NAME = "nom";
    public static final String MCS_FIELD_COMMENT = "commentaire";
    public static final String MCS_FIELD_LAW = "loi";
    public static final String MCS_FIELD_PROBA = "probabilite";
    public static final String MCS_FIELD_STATE = "etat";
    public static final String MCS_FIELD_GENERIC = "generique";
    public static final String MCS_FIELD_EXTENTION = "extension";
    public static final String MCS_FIELD_SUBTREE = "sous_arbre";
    public static final String MCS_FIELD_DSF = "dsf";
    public static final String MCS_FIELD_TREENAME = "nom_arbre";
    public static final String MCS_FIELD_BTP = "BTP";
    public static final String MCS_FIELD_FMEA = "Amdec";
    public static final String MCS_FIELD_EQUIV = "equivalence";
    public static final String MCS_FIELD_GSR = "GSR";
    public static final String MCS_FIELD_INSPECTED = "inspecte";
    public static final String MCS_FIELD_TESTED = "test_vol";
    public static final String MCS_FIELD_ATTRIBS = "attribute";
    public static final int MCS_IDX_CUT = 0;
    public static final int MCS_IDX_NAME = 1;
    public static final int MCS_IDX_COMMENT = 2;
    public static final int MCS_IDX_LAW = 3;
    public static final int MCS_IDX_PROBA = 4;
    public static final int MCS_IDX_STATE = 5;
    public static final int MCS_IDX_GENERIC = 6;
    public static final int MCS_IDX_EXTENTION = 7;
    public static final int MCS_IDX_SUBTREE = 8;
    public static final int MCS_IDX_DSF = 9;
    public static final int MCS_IDX_TREENAME = 10;
    public static final int MCS_IDX_BTP = 11;
    public static final int MCS_IDX_FMEA = 12;
    public static final int MCS_IDX_EQUIV = 13;
    public static final int MCS_IDX_GSR = 14;
    public static final int MCS_IDX_INSPECTED = 15;
    public static final int MCS_IDX_TESTED = 16;
    public static final int MCS_IDX_ATTRIBS = 17;
    public static final int MCS_IDX_IP_CP = 20;
    public static final int MCS_IDX_IP_MIF = 21;
    public static final int MCS_IDX_IP_CIF = 22;
    public static final int MCS_IDX_IP_DIF = 23;
    public static final int MCS_IDX_IP_RAW = 24;
    public static final int MCS_IDX_IP_RRW = 25;

    public MCSTableModel(MCS mcs, ArborRenderer renderer) {
        this._columnsModel = new MCSColumnsModel();
        this._mcs = mcs;
        this._renderer = renderer;
    }

    public void changeMCS(MCS mcs) {
        if (this._mcs == mcs) {
            return;
        }
        this._mcs = mcs;
        this.refresh(true, false);
    }

    public void addTableModelListener(TableModelListener l) {
        this._listenerList.add(TableModelListener.class, l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this._listenerList.remove(TableModelListener.class, l);
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    public void refresh(boolean rowsChanged, boolean columnsChanged) {
        if (columnsChanged) {
            this.fireTableChanged(new TableModelEvent((TableModel)((Object)this), -1));
        }
        if (rowsChanged) {
            this.fireTableChanged(new TableModelEvent((TableModel)((Object)this)));
        }
    }

    public ItemAbstractColumnsModel getColumnModel() {
        return this._columnsModel;
    }

    public int getRowCount() {
        return this._mcs.getRowCount();
    }

    public int getColumnCount() {
        return this._columnsModel.getColumnCount();
    }

    public Class getColumnClass(int column) {
        int idxCol = this._columnsModel.getColumnField(column).getIdxCode();
        switch (idxCol) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                return String.class;
            }
            case 15: 
            case 16: {
                return String.class;
            }
            case 0: 
            case 4: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return Double.class;
            }
            case 6: 
            case 8: 
            case 9: 
            case 14: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    public String getColumnName(int column) {
        return this._columnsModel.getColumnName(column);
    }

    Cut getRowCut(int row) {
        return this._mcs.getRowCut(row);
    }

    Evt getRowEvent(int row) {
        return this._mcs.getRowEvent(row);
    }

    int getRowIndexCut(int row) {
        return this._mcs.getRowIndexCut(row);
    }

    private String getValidText(Object obj) {
        String txt;
        if (obj == null) {
            return "-";
        }
        String string = txt = obj instanceof String ? (String)obj : obj.toString();
        if (txt.length() == 0) {
            return "-";
        }
        return txt;
    }

    public Object getValueAt(int row, int col) {
        int idxCol = this._columnsModel.getColumnField(col).getIdxCode();
        if (idxCol == 0) {
            Cut cut = this._mcs.getRowCut(row);
            if (cut != null) {
                return cut.getProbability();
            }
            return null;
        }
        Evt evt = this._mcs.getRowEvent(row);
        switch (idxCol) {
            case 1: {
                return evt.getName();
            }
            case 2: {
                return evt.getInfo(Evt.KeyInfo.COMMENT, this._renderer);
            }
            case 3: {
                return evt.getInfo(Evt.KeyInfo.LAW, this._renderer);
            }
            case 4: {
                return evt.getInfo(Evt.KeyInfo.PROBABILITY, this._renderer);
            }
            case 5: {
                return evt.getInfo(Evt.KeyInfo.STATE, this._renderer);
            }
            case 6: {
                return evt.getInfo(Evt.KeyInfo.GENERIC, this._renderer);
            }
            case 7: {
                return evt.getInfo(Evt.KeyInfo.EXTENTION, this._renderer);
            }
            case 8: {
                return evt.getInfo(Evt.KeyInfo.SUBTREE, this._renderer);
            }
            case 9: {
                return evt.getInfo(Evt.KeyInfo.DSF, this._renderer);
            }
            case 10: {
                return evt.getInfo(Evt.KeyInfo.TREENAME, this._renderer);
            }
            case 11: {
                return this.getValidText(evt.getInfo(Evt.KeyInfo.BTP, this._renderer));
            }
            case 12: {
                return this.getValidText(evt.getInfo(Evt.KeyInfo.FMEA, this._renderer));
            }
            case 13: {
                return this.getValidText(evt.getInfo(Evt.KeyInfo.EQUIV, this._renderer));
            }
            case 14: {
                return evt.getInfo(Evt.KeyInfo.GSR, this._renderer);
            }
            case 15: {
                String txt;
                Object obj = evt.getInfo(Evt.KeyInfo.INSPECTED, this._renderer);
                if (obj == null) {
                    return "";
                }
                String string = txt = obj instanceof String ? (String)obj : obj.toString();
                if (txt.length() == 0) {
                    return "";
                }
                return txt;
            }
            case 16: {
                String txt;
                Object obj = evt.getInfo(Evt.KeyInfo.TESTED, this._renderer);
                if (obj == null) {
                    return "";
                }
                String string = txt = obj instanceof String ? (String)obj : obj.toString();
                if (txt.length() == 0) {
                    return "";
                }
                return txt;
            }
            case 17: {
                return this.getValidText(evt.getInfo(Evt.KeyInfo.ATTRIBS, this._renderer));
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return -1.0;
            }
        }
        return "";
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setValueAt(Object aValue, int row, int column) {
    }

    protected String getExportValueAt(int row, int col) {
        return this.getValueAt(row, col).toString();
    }

    public static List<PrefFieldBoolean> createFields() {
        ArrayList<PrefFieldBoolean> fields = new ArrayList<PrefFieldBoolean>();
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_COMMENTS"), MCS_FIELD_COMMENT, 2, 15, "L"));
        fields.add(new PrefFieldBoolean(ResCompute.getString("MCS_FIELD_LAW"), MCS_FIELD_LAW, 3, 15, "L"));
        fields.add(new PrefFieldBoolean(ResCompute.getString("MCS_FIELD_PROBA_EVT"), MCS_FIELD_PROBA, 4, 6, "R"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_GENERIC"), MCS_FIELD_GENERIC, 6, 4, "C"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_FRB"), MCS_FIELD_BTP, 11, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_FMEA"), MCS_FIELD_FMEA, 12, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_EQUIVALENCE"), MCS_FIELD_EQUIV, 13, 10, "L"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_GSR"), MCS_FIELD_GSR, 14, 4, "C"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_INSPECTED"), MCS_FIELD_INSPECTED, 15, 6, "R"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_INFLIGHT_TESTED"), MCS_FIELD_TESTED, 16, 6, "R"));
        fields.add(new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_ATTRIBUTES"), MCS_FIELD_ATTRIBS, 17, 10, "L"));
        int len = fields.size();
        block3: for (int i = 0; i < len; ++i) {
            PrefFieldBoolean item = fields.get(i);
            item.setOptionnal(true);
            switch (item.getIdxCode()) {
                case 2: 
                case 3: 
                case 5: 
                case 10: 
                case 11: 
                case 15: 
                case 17: {
                    item.setSelected(true);
                    continue block3;
                }
                default: {
                    item.setSelected(false);
                }
            }
        }
        return fields;
    }

    protected static class MCSColumnsModel
    extends ItemAbstractColumnsModel {
        PrefFieldBoolean _cutItem = new PrefFieldBoolean(ResCompute.getString("MCS_FIELD_PROBA_CUT"), "coupe", 0, 8, "C");
        PrefFieldBoolean _nameItem = new PrefFieldBoolean(ResMsgVoc.getString((String)"VOC_EVENTS"), "nom", 1, 10, "L");

        public MCSColumnsModel() {
            this.init();
        }

        public List<PrefFieldBoolean> createOptionnalFields() {
            return MCSTableModel.createFields();
        }

        public void setOptionnalFields(List<PrefFieldBoolean> optionnalFields) {
            this._optionnalFields = optionnalFields;
            this._items.clear();
            this._items.add(this._cutItem);
            this._items.add(this._nameItem);
            for (PrefFieldBoolean item : this._optionnalFields) {
                this._items.add(item);
            }
            this.resetFilterIndexes();
        }
    }
}

