/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.faulttree.compute.task;

import com.dassault.cecilia.plugin.faulttree.compute.BooleanStore;
import com.dassault.cecilia.plugin.faulttree.compute.ResCompute;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskContainer;
import com.dassault.cecilia.plugin.faulttree.compute.task.TaskItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskIStoreLoad
extends TaskItem {
    private static Logger _LOG = Logger.getLogger(TaskIStoreLoad.class.getPackage().getName());
    BooleanStore _store;
    File _xmlFile;
    boolean _error;

    public TaskIStoreLoad(TaskContainer container, BooleanStore store, File xmlFile) {
        super(container);
        this._store = store;
        this._xmlFile = xmlFile;
        this._error = false;
    }

    @Override
    public void run() {
        try {
            this._store.loadXML(new FileInputStream(this._xmlFile));
        }
        catch (IOException e) {
            this._error = true;
            this.addError(ResCompute.getString("MSG_STORE_ERR_LOAD"));
            _LOG.log(Level.WARNING, "IOException during load Store\n" + e.getMessage(), e);
        }
    }

    @Override
    public String getInfo() {
        return ResCompute.getString("TASK_INFO_STORE_LOAD");
    }

    @Override
    public void requestStop() {
    }

    @Override
    public boolean continueWhenFinnished() {
        return !this._error;
    }
}

