/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.filetransfert.ByteFileReceiver;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;

public class JXTAProperties {
    public static final String PROP_PATH_DISTRIB = "cecilia.jxta.path.distributed";
    public static final String PROP_PATH_TEMP = "cecilia.jxta.path.temp";
    public static final String PROP_TEMP_EMPTY_ON_START = "cecilia.jxta.temp.empty.startup";
    public static final String PROP_HTTP = "cecilia.jxta.config.http";
    public static final String PROP_TCP = "cecilia.jxta.config.tcp";
    public static final String PROP_RELAYURI = "cecilia.jxta.relayuri";
    public static final String PROP_RELAYBASEFILE = "cecilia.jxta.relayfile";
    public static final String PROP_PEER_NAME = "cecilia.jxta.name";
    public static final String PROP_IHM = "cecilia.jxta.ihm";
    public static final String PROP_REMOVE_JXTA_ON_START = "cecilia.jxta.clean.startup";
    public static final String PROP_SEARCH_TIME = "cecilia.jxta.search.time";
    public static final String PROP_LOG = "java.util.logging.config.file";
    public static final String PROP_LOG_RELATIV = "cecilia.jxta.log.relativ";
    public static final int DEFAULT_FILE_TRANSFERT_TIMEOUT = 1800000;
    public static final String PROP_FILE_TRANSFERT_TIMEOUT = "cecilia.jxta.filetransfert.timeout";
    public static final String PROP_MEM_DISPLAY_PERIOD = "cecilia.jxta.mem.period";
    public static final String PROP_TYPES = "cecilia.jxta.types";
    public static final String PROP_COPY_METHOD = "cecilia.jxta.copy";
    public static final int DEFAULT_TRASH_SIZE = 1000;
    public static final String PROP_TRASH_SIZE = "cecilia.jxta.trash.size";
    public static final int DEF_SEARCH_DELAI_IF_NO_SERVER = 10000;
    public static final String PROP_SEARCH_DELAI_IF_NO_SERVER = "cecilia.jxta.search.delay.noserver";
    public static final String PROP_PATH_ARALIA2 = "cecilia.jxta.aralia2.exec";
    public static final String PROP_PATH_ARALIA2_CFG = "cecilia.jxta.aralia2.config";
    public static final String PROP_PATH_LOWSTART_ARALIA2 = "cecilia.jxta.aralia2.lowstart.exec";
    public static final String PROP_LOWSTART_ARALIA2_OPTIONS = "cecilia.jxta.aralia2.lowstart.options";
    public static final String PROP_PATH_CECILIABDD = "cecilia.jxta.ceciliabdd.exec";
    public static final String PROP_PATH_CECILIABDD_CFG = "cecilia.jxta.ceciliabdd.config";
    public static final String PROP_PATH_LOWSTART_CECILIABDD = "cecilia.jxta.ceciliabdd.lowstart.exec";
    public static final String PROP_LOWSTART_CECILIABDD_OPTIONS = "cecilia.jxta.ceciliabdd.lowstart.options";
    public static final String PROP_PATH_ARALIA4 = "cecilia.jxta.aralia4.exec";
    public static final String PROP_PATH_ARALIA4_CFG = "cecilia.jxta.aralia4.config";
    public static final String PROP_PATH_LOWSTART_ARALIA4 = "cecilia.jxta.aralia4.lowstart.exec";
    public static final String PROP_LOWSTART_ARALIA4_OPTIONS = "cecilia.jxta.aralia4.lowstart.options";
    public static final String PROP_PATH_XBAN_JAVA = "cecilia.jxta.ban.java.exec";
    public static final String PROP_XBAN_JAVA_OPTIONS = "cecilia.jxta.ban.java.options";
    public static final String PROP_PATH_LOWSTART_XBAN = "cecilia.jxta.ban.lowstart.exec";
    public static final String PROP_LOWSTART_XBAN_OPTIONS = "cecilia.jxta.ban.lowstart.options";
    public static final String PROP_DELAY_BEFORE_LAUNCHING = "cecilia.jxta.launch.delay";
    public static final String PROP_DESC = "cecilia.jxta.desc";
    public static final int DEF_VERIFY_CONSIGNE_PEER = 60000;
    public static final String PROP_VERIFY_CONSIGNE_PEER = "cecilia.jxta.verify.consigne.time";
    public static final int DEF_PUBLISH_PERIOD = 3600;
    public static final String PROP_PUBLISH_PERIOD = "cecilia.jxta.publish.period";
    public static final int DEF_WAIT_SEND_RESULT = -1;
    public static final String PROP_WAIT_SEND_RESULT = "cecilia.jxta.wait.before.send.result";
    public static final String PROP_RELAY = "cecilia.jxta.relay";
    public static final String PROP_ADMIN_ENABLE = "cecilia.jxta.admin.enable";
    public static final String PROP_PRIO = "cecilia.jxta.prio";
    public static final String PROP_PRIO_DELTA_MEL = "cecilia.jxta.prio_delta_mel";
    public static final String PROP_PRIO_DELTA_SEQ = "cecilia.jxta.prio_delta_seq";
    public static final String PROP_KEEP_TMPFILE = "cecilia.jxta.keeptmp";
    @Deprecated
    public static final String PROP_WATCHER_RELAAY_PATH = "cecilia.jxta.watcher.relay.path";
    @Deprecated
    public static final String PROP_WATCHER_DECTECTION_TIME_UP = "cecilia.jxta.watcher.detection.time.up";
    @Deprecated
    public static final String PROP_WATCHER_DECTECTION_TIME_DOWN = "cecilia.jxta.watcher.detection.time.down";
    @Deprecated
    public static final String PROP_RELAY_SCAN_PERIOD = "cecilia.jxta.relay.scan.period";
    private static File _tempDir = null;
    private static String _distributedDir = null;

    public static void initLaunchIni() {
        try {
            String launchIni = System.getProperty("launch", "launch.ini");
            Properties props = new Properties();
            FileInputStream fis = new FileInputStream(launchIni);
            props.load(fis);
            fis.close();
            Enumeration<?> values = props.propertyNames();
            while (values.hasMoreElements()) {
                String key = (String)values.nextElement();
                String value = props.getProperty(key).trim();
                if (value.equals("")) continue;
                System.setProperty(key, value);
            }
            Locale defaultLocale = Locale.getDefault();
            Locale.setDefault(new Locale(System.getProperty("user.language", "en"), defaultLocale.getCountry(), defaultLocale.getVariant()));
            Loggeur.log(JXTAProperties.class, Loggeur.INFO, "launch.ini = " + new File(launchIni).getAbsolutePath());
        }
        catch (Exception excep) {
            excep.printStackTrace();
            System.err.println(ResJXTA.getString("CONFIG_WRONG_LAUNCH_INI"));
            System.exit(0);
        }
    }

    public static String listProperties() {
        StringBuffer sb = new StringBuffer();
        try {
            Field[] fields = JXTAProperties.class.getFields();
            int i = 0;
            while (i < fields.length) {
                String prop = (String)fields[i].get(JXTAProperties.class);
                sb.append(prop);
                sb.append(" = ");
                sb.append(System.getProperty(prop));
                sb.append("\n");
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static File getTempDir() {
        if (_tempDir == null) {
            try {
                File newTmp;
                String tmpDir = System.getProperty(PROP_PATH_TEMP);
                if (tmpDir != null && (newTmp = new File(tmpDir)).exists() && newTmp.isDirectory()) {
                    _tempDir = new File(tmpDir);
                    Loggeur.log(JXTAProperties.class, Loggeur.INFO, "Tmp = " + _tempDir.getAbsolutePath());
                }
            }
            catch (Exception tmpDir) {
                // empty catch block
            }
        }
        if (_tempDir == null && !(_tempDir = new File(String.valueOf(JXTAProperties.getDistributedDir()) + File.separator + "TmpJXTA")).exists()) {
            try {
                _tempDir.mkdir();
                Loggeur.log(JXTAProperties.class, Loggeur.INFO, "Tmp = " + _tempDir.getAbsolutePath());
            }
            catch (Exception e) {
                Loggeur.log(ByteFileReceiver.class, Loggeur.ERROR, _tempDir.getAbsolutePath());
                System.exit(-1);
            }
        }
        assert (_tempDir != null);
        return _tempDir;
    }

    public static String getDistributedDir() {
        if (_distributedDir == null) {
            String dir = System.getProperty(PROP_PATH_DISTRIB);
            if (dir != null && !new File(dir).exists()) {
                try {
                    if (new File(dir).mkdirs()) {
                        _distributedDir = dir;
                    }
                }
                catch (Exception e) {
                    Loggeur.log(PeerJXTA.class, Loggeur.ERROR, e.getMessage());
                }
            }
            if (dir != null && new File(dir).exists() && new File(dir).isDirectory()) {
                _distributedDir = dir;
            }
            if (_distributedDir == null) {
                _distributedDir = ".";
                Loggeur.log(PeerJXTA.class, Loggeur.ERROR, PROP_PATH_DISTRIB + ResJXTA.getString("ENGINE_WRONG_PATH"));
            }
        }
        return _distributedDir;
    }

    public static boolean getBoolProperty(String property) {
        String prop = System.getProperty(property);
        return prop != null && (prop.equalsIgnoreCase("yes") || prop.equalsIgnoreCase("on") || prop.equalsIgnoreCase("true"));
    }

    public static void main(String[] args) {
        JXTAProperties.initLaunchIni();
        System.out.println(JXTAProperties.listProperties());
    }
}

