/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.compute;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.compute.ARALIAComputor;
import com.dassault.cecilia.lib.distrib.compute.PreAndPostProcessor;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonClient;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;

public class AraliaPreAndPostProcessor
implements PreAndPostProcessor {
    private CECILIAClient _client;
    protected HashMap<InfoServerApp, Integer> _memExhausted = new HashMap();

    public AraliaPreAndPostProcessor(CECILIAClient client) {
        this._client = client;
    }

    protected void addMemoryExhausted(InfoServerApp server) {
        Integer count = this._memExhausted.get(server);
        if (count == null) {
            this._memExhausted.put(server, 1);
        } else {
            this._memExhausted.put(server, count + 1);
        }
    }

    protected int getmemExhausted(InfoServerApp server) {
        Integer count = this._memExhausted.get(server);
        if (count != null) {
            return count;
        }
        return 0;
    }

    @Override
    public void manageReqError(Request req, InfoServerApp remoteServer, CECILIAClient client) {
        ReqState state = req.getState();
        if (state == ReqState.ENGINE_ERROR) {
            int err = req.getGeneratedError();
            switch (err) {
                case -700: 
                case -400: 
                case -300: 
                case 12345: {
                    if (!remoteServer.addEngineErrorCount()) {
                        return;
                    }
                    if (req.getHisto().countTmpErr() <= 3) {
                        req.relaunch();
                        break;
                    }
                    ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.TOO_MANY_ERROR);
                    break;
                }
                case -901: 
                case -900: 
                case -100: {
                    this.addMemoryExhausted(remoteServer);
                    if (this.getmemExhausted(remoteServer) > 5) {
                        ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.TOO_MANY_ERROR);
                        this._memExhausted.clear();
                        Request reqTmp = null;
                        while ((reqTmp = client.getRequestStock().getNextRequest()) != null) {
                            ReqAutomatonClient.fireEvent(reqTmp, ReqAutomatonClient.EvtClient.CANCEL_BY_SOFTWARE);
                        }
                        client.remoteStopRequests();
                        break;
                    }
                    if (err == -901) {
                        req.relaunch();
                        break;
                    }
                    ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.TOO_MANY_ERROR);
                    break;
                }
                case -800: 
                case -600: 
                case -500: 
                case -200: {
                    ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.TOO_MANY_ERROR);
                }
            }
        } else if (state == ReqState.WRONG_RESULT) {
            if (!remoteServer.addEngineErrorCount()) {
                return;
            }
            if (req.getHisto().countTmpErr() <= 3) {
                req.relaunch();
            } else {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.TOO_MANY_ERROR);
            }
        }
    }

    @Override
    public boolean manageFinishedRequest(Request req) {
        return true;
    }

    private void parseFile(File f, Request req) throws IOException {
        StringBuffer temp = new StringBuffer(128);
        long size = f.length();
        FileInputStream fis = new FileInputStream(f);
        byte[] bytes = new byte[Long.valueOf(size).intValue()];
        fis.read(bytes);
        fis.close();
        String s = new String(bytes);
        StringTokenizer st = new StringTokenizer(s.toLowerCase(), ";");
        boolean needToBeModified = false;
        while (st.hasMoreTokens()) {
            String command = st.nextToken();
            int c = 34;
            int pos1 = 0;
            int pos2 = 0;
            if (command.indexOf("load ") != -1) {
                pos1 = command.indexOf(c);
                pos2 = command.lastIndexOf(c);
                if (pos1 != -1 && pos2 != -1 && pos1 != pos2) {
                    needToBeModified = true;
                    String loadFile = command.substring(pos1 + 1, pos2);
                    this.parseFile(new File(loadFile), req);
                    String newName = this._client.makeUniqueFileID(loadFile, false);
                    String s1 = command.substring(0, pos1 - 1);
                    String s2 = command.substring(pos2 + 1);
                    temp.append(s1);
                    temp.append("\"");
                    temp.append(newName);
                    temp.append("\"");
                    temp.append(s2);
                    continue;
                }
                throw new IOException("PARSING ERREURRRRRRRRRRRRRRRRRRR Load");
            }
            pos1 = command.indexOf(c);
            pos2 = command.lastIndexOf(c);
            if (pos1 != -1 && pos2 != -1 && pos1 != pos2) {
                int p1 = command.indexOf("save ");
                int p2 = command.indexOf("trace ");
                int p3 = command.indexOf(62);
                int p4 = command.indexOf(">>");
                if (p1 != -1 || p2 != -1 || p3 != -1 || p4 != -1) {
                    needToBeModified = true;
                    String resultFile = command.substring(pos1 + 1, pos2);
                    String newName = this._client.makeUniqueFileID(resultFile, false);
                    String s1 = command.substring(0, pos1 - 1);
                    String s2 = command.substring(pos2 + 1);
                    temp.append(s1);
                    temp.append("\"");
                    temp.append(newName);
                    temp.append("\"");
                    temp.append(s2);
                    continue;
                }
                throw new IOException("PARSING ERREURRRRRRRRRRRRRRRRRRR ");
            }
            temp.append(command);
        }
        if (needToBeModified) {
            FileWriter fos = new FileWriter(f);
            fos.write(temp.toString());
            fos.flush();
            fos.close();
        }
    }

    @Override
    public boolean preProcess(Request req) {
        Loggeur.log(this.getClass(), Loggeur.INFO, ResJXTA.getString("ENGINE_PREPROC"));
        File cmdFile = new File(req.getCmdFileName());
        try {
            this.parseFile(cmdFile, req);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public String createMessage(int err) {
        return ARALIAComputor.createErrMessage(err);
    }
}

