/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.compute;

import com.dassault.cecilia.lib.distrib.log.Loggeur;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

public class CopyStream
extends Thread {
    BufferedReader _inTxt;
    PrintWriter _outTxt;
    protected boolean _stop = false;

    public CopyStream() {
        this.setDaemon(true);
    }

    public CopyStream(String name) {
        super(name);
        this.setDaemon(true);
    }

    public CopyStream setIn(InputStream in) {
        this._inTxt = new BufferedReader(new InputStreamReader(in));
        return this;
    }

    public CopyStream setIn(Reader in) {
        this._inTxt = new BufferedReader(in);
        return this;
    }

    public CopyStream setOut(OutputStream out) {
        this._outTxt = new PrintWriter((Writer)new OutputStreamWriter(out), true);
        return this;
    }

    public CopyStream setOut(PrintWriter out) {
        this._outTxt = out;
        return this;
    }

    @Override
    public void run() {
        try {
            String line;
            while ((line = this._inTxt.readLine()) != null) {
                this.println(line);
                if (this._stop) break;
            }
            this._inTxt.close();
        }
        catch (IOException e) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, e.getMessage());
        }
    }

    protected void println(String line) {
        Loggeur.log(this.getClass(), Loggeur.DEBUG, line);
    }

    public void close() {
        this._stop = true;
    }
}

