/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.compute;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.compute.Computor;
import com.dassault.cecilia.lib.distrib.compute.CopyStream;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.request.Request;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class ProcessComputor
implements Computor {
    public static final int RETURN_OK = 0;
    public static final int RETURN_KO = 1;
    public static final int RETURN_LOWSTART_TIME_OUT = 6;
    public static final int RETURN_LOWSTART_MEMORY_ABS = 7;
    public static final int RETURN_LOWSTART_MEMORY_REL = 8;
    public static final int KILLEDBYLOWSTART = -800;
    public static final int MEMORY1BYLOWSTART = -900;
    public static final int MEMORY2BYLOWSTART = -901;
    protected boolean _bUseLowstart = false;
    protected Process _proc;
    public static final int NOTCOMPUTING = 0;
    public static final int STILLCOMPUTING = 1;
    public static final int FINISHED = 2;
    protected Object _lockComputingState = new Object();
    protected int _computingState;
    private static final String __separatorWhite = " \t\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeComputingState(int testValue, int value) {
        Object object = this._lockComputingState;
        synchronized (object) {
            if (this._computingState == testValue) {
                this._computingState = value;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getComputingState() {
        Object object = this._lockComputingState;
        synchronized (object) {
            return this._computingState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setComputingState(int value) {
        Object object = this._lockComputingState;
        synchronized (object) {
            this._computingState = value;
        }
    }

    @Override
    public boolean compute(final Request req) {
        this.setComputingState(0);
        try {
            this.launchExecutable(req);
            this.setComputingState(1);
            this.launchOutputThread(req.getShortNumber());
            this.launchErrorThread(req.getShortNumber());
            this.launchInputThread(req.getShortNumber());
            Thread wait = new Thread("WAIT"){

                @Override
                public void run() {
                    try {
                        ProcessComputor.this._proc.waitFor();
                        Loggeur.log(this.getClass(), Loggeur.FINE, " " + req.getShortNumber() + " - FINISHED because WaitFor return");
                        ProcessComputor.this.changeComputingState(1, 2);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            };
            wait.start();
            boolean bResult = false;
            while (this.getComputingState() == 1) {
                Thread.sleep(10L);
            }
            int retourDeLowStart = 1;
            try {
                retourDeLowStart = this._proc.exitValue();
            }
            catch (IllegalThreadStateException e) {
                StringBuffer sb = new StringBuffer();
                sb.append("_proc.exitValue() throws exception, but _proc should be finished for request ");
                sb.append(req.getAllID());
                sb.append("\n[").append(e.getClass().getName()).append("] ").append(e.getMessage()).append("\n");
                StringWriter traceException = new StringWriter();
                e.printStackTrace(new PrintWriter(traceException));
                sb.append(traceException.toString());
                Loggeur.log(this.getClass(), Loggeur.WARNING, sb.toString());
            }
            try {
                retourDeLowStart = this.filterExecutable(req, retourDeLowStart);
                if (this._bUseLowstart) {
                    switch (retourDeLowStart) {
                        case 6: {
                            Loggeur.log(this.getClass(), Loggeur.ERROR, ResJXTA.getString("ENGINE_LOWSTART_TIME_OUT"));
                            req.setInfo(String.valueOf(-800));
                            break;
                        }
                        case 7: {
                            Loggeur.log(this.getClass(), Loggeur.ERROR, ResJXTA.getString("ENGINE_LOWSTART_MEMORY_ABS"));
                            req.setInfo(String.valueOf(-900));
                            break;
                        }
                        case 8: {
                            Loggeur.log(this.getClass(), Loggeur.ERROR, ResJXTA.getString("ENGINE_LOWSTART_MEMORY_REL"));
                            req.setInfo(String.valueOf(-901));
                            break;
                        }
                        case 0: {
                            bResult = req.getNumberOfErr() == 0;
                            break;
                        }
                        default: {
                            Loggeur.log(this.getClass(), Loggeur.ERROR, ResJXTA.msgFormat("ENGINE_BAD_EXIT", String.valueOf(req.getShortNumber()) + " - ", retourDeLowStart));
                            break;
                        }
                    }
                } else if (retourDeLowStart == 0) {
                    bResult = req.getNumberOfErr() == 0;
                } else {
                    Loggeur.log(this.getClass(), Loggeur.ERROR, ResJXTA.msgFormat("ENGINE_BAD_EXIT", String.valueOf(req.getShortNumber()) + " - ", retourDeLowStart));
                }
            }
            catch (Throwable e) {
                Loggeur.log(this.getClass(), Loggeur.ERROR, e);
            }
            if (this.getComputingState() != 2) {
                Loggeur.log(this.getClass(), Loggeur.ERROR, ResJXTA.msgFormat("ENGINE_ERROR", String.valueOf(req.getShortNumber()) + " - "));
                req.setInfo(String.valueOf(this.getComputingState()));
                Thread.sleep(3000L);
                this._proc.destroy();
                return false;
            }
            boolean bl = bResult;
            return bl;
        }
        catch (Exception e) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, e);
            if (this._proc == null) {
                return false;
            }
            this._proc.destroy();
            if (req.getGeneratedError() == 12345) {
                req.setInfo(String.valueOf(this._proc.exitValue()));
            }
            return false;
        }
        finally {
            this.finalizeExecutable(req);
        }
    }

    protected int filterExecutable(Request req, int exitValue) {
        return exitValue;
    }

    protected void finalizeExecutable(Request req) {
    }

    protected abstract void launchExecutable(Request var1) throws IOException;

    protected void launchOutputThread(String id) throws IOException {
        CopyStream outThread = new CopyStream("ENGINE-OUT-" + id);
        outThread.setIn(this._proc.getInputStream());
        outThread.setOut(System.out);
        outThread.start();
    }

    protected void launchErrorThread(String id) throws IOException {
        CopyStream errThread = new CopyStream("ENGINE-ERR-" + id){

            @Override
            protected void println(String line) {
                int err;
                super.println(line);
                boolean flag = true;
                if (flag && (err = ProcessComputor.this.containsErrorDuringComputing(line, false)) != 12345) {
                    Loggeur.log(this.getClass(), Loggeur.FINE, "FINISHED because error in sdterr");
                    ProcessComputor.this.changeComputingState(1, err);
                    flag = false;
                    this.close();
                }
            }
        };
        errThread.setIn(this._proc.getErrorStream());
        errThread.setOut(System.err);
        errThread.start();
    }

    public abstract int containsErrorDuringComputing(String var1, boolean var2);

    protected void launchInputThread(String id) throws IOException {
    }

    @Override
    public boolean stop() {
        if (this._proc != null) {
            Loggeur.log(this.getClass(), Loggeur.DEBUG, "destruction du processus");
            this._proc.destroy();
        }
        return true;
    }

    @Override
    public String createMessage(int err) {
        return ProcessComputor.createErrMessage(err);
    }

    public static String createErrMessage(int err) {
        switch (err) {
            case -800: {
                return ResJXTA.getString("ENGINE_LOWSTART_TIME_OUT");
            }
            case -900: {
                return ResJXTA.getString("ENGINE_LOWSTART_MEMORY_ABS");
            }
            case -901: {
                return ResJXTA.getString("ENGINE_LOWSTART_MEMORY_REL");
            }
            case 0: {
                return ResJXTA.getString("ENGINE_NOERROR");
            }
        }
        return "";
    }

    /*
     * Unable to fully structure code
     */
    protected static void parseArguments(String args, List<String> resultList) {
        block8: {
            block7: {
                if (args.indexOf(34) != -1) break block7;
                stOpts = new StringTokenizer(args);
                while (stOpts.hasMoreTokens()) {
                    tok = stOpts.nextToken();
                    resultList.add(tok);
                }
                break block8;
            }
            beg = 0;
            size = args.length();
            idx = 0;
            posBeg = 0;
            while (idx < size) {
                posBeg = idx;
                beg = args.charAt(idx++);
                if (" \t\r\n".indexOf(cur) == -1) break;
            }
            block2: while (idx < size) {
                block6: {
                    if (beg != 34) ** GOTO lbl33
                    while (idx < size) {
                        if ((cur = args.charAt(idx++)) != '\"') continue;
                        arg = args.substring(posBeg + 1, idx - 1);
                        resultList.add(arg);
                        break block6;
                    }
                    break block6;
lbl-1000:
                    // 1 sources

                    {
                        if (" \t\r\n".indexOf(cur = args.charAt(idx++)) == -1) continue;
                        arg = args.substring(posBeg, idx - 1);
                        resultList.add(arg);
                        break;
lbl33:
                        // 2 sources

                        ** while (idx < size)
                    }
                }
                while (idx < size) {
                    posBeg = idx;
                    beg = args.charAt(idx++);
                    if (" \t\r\n".indexOf(cur) == -1) continue block2;
                }
            }
        }
    }

    public static void main(String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        ProcessComputor.parseArguments("-10 \"\" args \"t  o  t  o\tti ti", results);
        int i = 0;
        while (i < results.size()) {
            System.out.println("'" + (String)results.get(i) + "'");
            ++i;
        }
    }
}

