/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.entityinfo;

import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import java.util.ArrayList;
import java.util.Iterator;

public class InfoPeerList {
    ArrayList<InfoPeerJXTA> _remotePeers = new ArrayList();

    public synchronized void add(InfoPeerJXTA remotePeer) {
        InfoPeerJXTA oldRemotePeer = this.getRemotePeer(remotePeer.getPeerIDString());
        if (oldRemotePeer != null) {
            this._remotePeers.remove(oldRemotePeer);
        }
        this._remotePeers.add(remotePeer);
    }

    public synchronized void remove(InfoPeerJXTA remotePeer) {
        this._remotePeers.remove(remotePeer);
    }

    public synchronized InfoPeerJXTA getRemotePeer(String peerIDString) {
        Iterator<InfoPeerJXTA> it = this._remotePeers.iterator();
        InfoPeerJXTA remotepeer = null;
        int count = 0;
        while (it.hasNext()) {
            InfoPeerJXTA tmp = it.next();
            if (!tmp.getPeerIDString().equals(peerIDString)) continue;
            remotepeer = tmp;
            ++count;
        }
        if (count > 1) {
            Loggeur.log(this.getClass(), Loggeur.FINE, "Two peers with same ID");
        }
        return remotepeer;
    }

    public Iterator<InfoPeerJXTA> iterator() {
        ArrayList<InfoPeerJXTA> tmpList = new ArrayList<InfoPeerJXTA>();
        tmpList.addAll(this._remotePeers);
        return tmpList.iterator();
    }

    public ArrayList<InfoPeerJXTA> trashWrongPeers() {
        ArrayList<InfoPeerJXTA> toBeTrashed = new ArrayList<InfoPeerJXTA>();
        for (InfoPeerJXTA peer : this._remotePeers) {
            if (peer.getStatus() != 1) {
                toBeTrashed.add(peer);
            }
            if (peer.isBound()) continue;
            toBeTrashed.add(peer);
        }
        for (InfoPeerJXTA peerJXTA : toBeTrashed) {
            this.remove(peerJXTA);
        }
        return toBeTrashed;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (InfoPeerJXTA peer : this._remotePeers) {
            sb.append(peer.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

