/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.filetransfert;

import com.dassault.cecilia.lib.distrib.jxtautility.FileDirDeletor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtility {
    static final int BUFFER = 4096;

    public static String unAccent(String s) {
        String temp = s;
        return temp.replaceAll("[^\\p{ASCII}]", "");
    }

    public static ZipInputStream getZipInputStreamFromURL(String url) {
        try {
            FileInputStream fis = new FileInputStream(url);
            ZipInputStream zis = new ZipInputStream(fis);
            return zis;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static ZipOutputStream getZipOutputStreamFromURL(String url) {
        try {
            FileOutputStream fos = new FileOutputStream(url);
            CheckedOutputStream checksum = new CheckedOutputStream(fos, new Adler32());
            BufferedOutputStream buff = new BufferedOutputStream(checksum);
            ZipOutputStream zos = new ZipOutputStream(buff);
            zos.setMethod(8);
            zos.setLevel(-1);
            return zos;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList readFilesFromZip(ZipInputStream zis) throws IOException {
        ZipEntry entry;
        ArrayList<Object[]> files = new ArrayList<Object[]>();
        while ((entry = zis.getNextEntry()) != null) {
            int count;
            int entrySize = (int)entry.getSize();
            if (entrySize == -1) {
                entrySize = 2048;
            }
            byte[] data = new byte[4096];
            ByteArrayOutputStream out = new ByteArrayOutputStream(entrySize);
            while ((count = zis.read(data, 0, 4096)) != -1) {
                out.write(data, 0, count);
            }
            out.flush();
            out.close();
            Object[] nameAndFile = new Object[]{entry.getName(), out.toByteArray()};
            files.add(nameAndFile);
        }
        return files;
    }

    public static void writeZipWithByteArray(ArrayList files, ZipOutputStream zos) throws IOException {
        for (Object[] file : files) {
            int count;
            String name = ZipUtility.unAccent((String)file[0]);
            byte[] byteArray = (byte[])file[1];
            ByteArrayInputStream in = new ByteArrayInputStream(byteArray);
            ZipEntry entry = new ZipEntry(name);
            zos.putNextEntry(entry);
            byte[] data = new byte[4096];
            while ((count = in.read(data, 0, 4096)) != -1) {
                zos.write(data, 0, count);
            }
            zos.closeEntry();
            in.close();
        }
        zos.close();
    }

    public static void compress(File sourceFile, String nameOfFileInZip, File destZipFile) {
        try {
            int count;
            ZipOutputStream out = ZipUtility.getZipOutputStreamFromURL(destZipFile.getAbsolutePath());
            byte[] data = new byte[4096];
            ZipEntry entry = new ZipEntry(nameOfFileInZip);
            out.putNextEntry(entry);
            FileInputStream fi = new FileInputStream(sourceFile);
            BufferedInputStream buffi = new BufferedInputStream(fi, 4096);
            while ((count = buffi.read(data, 0, 4096)) != -1) {
                out.write(data, 0, count);
            }
            out.closeEntry();
            buffi.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void compress(ArrayList sourceFiles, String destZipFile) {
        try {
            ZipOutputStream out = ZipUtility.getZipOutputStreamFromURL(destZipFile);
            byte[] data = new byte[4096];
            int i = 0;
            while (i < sourceFiles.size()) {
                int count;
                File file = (File)sourceFiles.get(i);
                ZipEntry entry = new ZipEntry(ZipUtility.unAccent(file.getName()));
                out.putNextEntry(entry);
                FileInputStream fi = new FileInputStream(file);
                BufferedInputStream buffi = new BufferedInputStream(fi, 4096);
                while ((count = buffi.read(data, 0, 4096)) != -1) {
                    out.write(data, 0, count);
                }
                out.closeEntry();
                buffi.close();
                ++i;
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void unCompressFiles(String zipFile, String destDir) {
        block7: {
            FilterOutputStream dest = null;
            ArrayList<File> created = new ArrayList<File>();
            try {
                ZipEntry entry;
                FileInputStream fis = new FileInputStream(zipFile);
                BufferedInputStream buffi = new BufferedInputStream(fis);
                ZipInputStream zis = new ZipInputStream(buffi);
                while ((entry = zis.getNextEntry()) != null) {
                    int count;
                    byte[] data = new byte[4096];
                    File fileentry = new File(destDir, entry.getName());
                    created.add(fileentry);
                    FileOutputStream fos = new FileOutputStream(fileentry);
                    dest = new BufferedOutputStream(fos, 4096);
                    while ((count = zis.read(data, 0, 4096)) != -1) {
                        ((BufferedOutputStream)dest).write(data, 0, count);
                    }
                    ((BufferedOutputStream)dest).flush();
                    dest.close();
                }
                zis.close();
                break block7;
            }
            catch (Exception e) {
                try {
                    dest.close();
                    for (File file : created) {
                        FileDirDeletor.deleteIfNotDir(file);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            e.printStackTrace();
        }
    }

    public static InputStream unCompressToStream(String zipFile) {
        ZipInputStream zis = null;
        try {
            FileInputStream fis = new FileInputStream(zipFile);
            BufferedInputStream buffi = new BufferedInputStream(fis);
            zis = new ZipInputStream(buffi);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return zis;
    }

    public static void main(String[] args) {
        System.out.println("SeqStepperResults.zip is zip file ? : " + ZipUtility.isZip(new File("C:\\Working\\Distrib", "SeqStepperResults.zip")));
        System.out.println("SeqGen-Aero.xml is zip file ? : " + ZipUtility.isZip(new File("C:\\Working\\Distrib", "SeqGen-Aero.xml")));
        System.out.println("SeqStepperResults.subresult is zip file ? : " + ZipUtility.isZip(new File("C:\\Working\\Distrib", "SeqStepperResults.subresult")));
    }

    public static boolean isZip(File file) {
        try {
            ZipFile zip = new ZipFile(file);
            zip.close();
        }
        catch (ZipException ze) {
            return false;
        }
        catch (IOException ze) {
            return false;
        }
        return true;
    }
}

