/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.ihm;

import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.PeerChangeListener;
import com.dassault.cecilia.lib.distrib.ihm.ResJXTAIHM;
import com.dassault.cecilia.lib.distrib.ihm.UtilTableModel;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import java.util.ArrayList;

public class InfoClientsJXTATableModel
extends UtilTableModel
implements PeerChangeListener {
    private ArrayList<InfoPeerJXTA> _clients;

    public InfoClientsJXTATableModel(ArrayList<InfoPeerJXTA> clients, PeerJXTA localJXTA) {
        this._clients = clients;
        for (InfoPeerJXTA peerJXTA : clients) {
            peerJXTA.addChangeListener(this);
        }
    }

    public void dispose() {
        for (InfoPeerJXTA peerJXTA : this._clients) {
            peerJXTA.removeChangeListener(this);
        }
    }

    public void setClients(ArrayList<InfoPeerJXTA> newClients) {
        this._clients = newClients;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return this._clients.size();
    }

    public InfoPeerJXTA getClient(int idx) {
        if (idx >= 0 && idx < this._clients.size()) {
            return this._clients.get(idx);
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        InfoPeerJXTA clt = this._clients.get(rowIndex);
        if (clt == null) {
            return "null";
        }
        switch (columnIndex) {
            case 0: {
                return clt.getName();
            }
            case 1: {
                if (clt.getStatus() == 1) {
                    return true;
                }
                return false;
            }
            case 2: {
                return clt.getPeerIDString();
            }
            case 3: {
                return clt.getVersion();
            }
        }
        return "err";
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return ResJXTAIHM.getString("GLOBAL_CLIENT");
            }
            case 1: {
                return ResJXTAIHM.getString("GLOBAL_ONLINE");
            }
            case 2: {
                return ResJXTAIHM.getString("GLOBAL_CLIENT_ID");
            }
            case 3: {
                return ResJXTAIHM.getString("GLOBAL_VERSION");
            }
        }
        return "err";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public int getColumnSize(int col) {
        switch (col) {
            case 0: {
                return 80;
            }
            case 1: {
                return 40;
            }
            case 2: {
                return 150;
            }
            case 3: {
                return 40;
            }
        }
        return 30;
    }

    @Override
    public void peerStatusChange(String peerID, int oldStatus, int newStatus, PeerChangeListener.Reason reason) {
        this.fireTableDataChanged();
    }
}

