/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.ihm;

import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerApp;
import com.dassault.cecilia.lib.distrib.ihm.ReqHistoryDisplayer;
import com.dassault.cecilia.lib.distrib.ihm.ResJXTAIHM;
import com.dassault.cecilia.lib.distrib.ihm.UtilTableModel;
import com.dassault.cecilia.lib.distrib.peers.AppPeer;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.peers.CECILIAServer;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestTrash;
import com.dassault.cecilia.lib.distrib.requestManagement.TrashListenner;
import java.awt.Component;
import java.awt.Dimension;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TrashTableModel
extends UtilTableModel
implements TrashListenner,
ReqHistoryDisplayer {
    private RequestTrash _trash;
    private AppPeer _appPeer;

    public TrashTableModel(RequestTrash trash, AppPeer appPeer) {
        this._trash = trash;
        this._appPeer = appPeer;
        this._trash.addListenner(this);
    }

    public void dispose() {
        this._trash.removeListenner(this);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 3;
    }

    @Override
    public int getRowCount() {
        return this._trash.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Request req = this._trash.get(this.convertIndex(rowIndex));
        if (req == null) {
            return "null";
        }
        switch (columnIndex) {
            case 0: {
                return req.getShortNumber();
            }
            case 1: {
                return req.getState();
            }
            case 2: {
                String RemoteID = this._appPeer instanceof CECILIAClient ? req.getServerID() : req.getClientID();
                InfoPeerApp server = this._appPeer.getRemoteAppList().getRemoteInfoPeerApp(RemoteID);
                if (server == null) {
                    return "N/A";
                }
                return server.getName();
            }
            case 3: {
                return req.getHisto().toStringShort();
            }
        }
        return "err";
    }

    private int convertIndex(int rowIndex) {
        int next;
        int max;
        int realIndex = this._trash.getCurrentSize() < this._trash.getMaxSize() ? rowIndex : (rowIndex < (max = this._trash.getMaxSize()) - (next = this._trash.getNextIndex()) ? next + rowIndex : rowIndex - (max - next));
        return realIndex;
    }

    public Request getRequest(int tableRow) {
        return this._trash.get(this.convertIndex(tableRow));
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return ResJXTAIHM.getString("GLOBAL_REQ");
            }
            case 1: {
                return ResJXTAIHM.getString("GLOBAL_STATE");
            }
            case 2: {
                if (this._appPeer instanceof CECILIAServer) {
                    return ResJXTAIHM.getString("GLOBAL_CLIENT");
                }
                return ResJXTAIHM.getString("GLOBAL_SERVEUR");
            }
            case 3: {
                return ResJXTAIHM.getString("GLOBAL_HISTO");
            }
        }
        return "err";
    }

    @Override
    public int getColumnSize(int column) {
        switch (column) {
            case 0: {
                return 60;
            }
            case 1: {
                return 120;
            }
            case 2: {
                return 120;
            }
            case 3: {
                return 60;
            }
        }
        return 30;
    }

    @Override
    public int getColumnSizeMax(int col) {
        return super.getColumnSizeMax(col);
    }

    @Override
    public void trashChange() {
        this.fireTableDataChanged();
    }

    @Override
    public boolean mustBeHighlightedBold(int row) {
        Request req = this.getRequest(row);
        if (req == null) {
            return true;
        }
        if (req.getState() == ReqState.FINISHED_SUCCESFULY) {
            return false;
        }
        return req.getState() != ReqState.RESULT_SENT;
    }

    @Override
    public void displayHisto(Component parent, int row, PeerJXTA localPeer) {
        if (row == -1) {
            return;
        }
        Request req = this.getRequest(row);
        if (req == null) {
            return;
        }
        String msg = req.getHistoString(localPeer);
        StringTokenizer st = new StringTokenizer(msg, "\n", false);
        int width = 0;
        int height = 0;
        while (st.hasMoreTokens()) {
            width = Math.max(st.nextToken().length(), width);
            ++height;
        }
        if (width > 120 || height > 12) {
            JTextArea ctrlMess = new JTextArea();
            ctrlMess.setLineWrap(false);
            ctrlMess.setWrapStyleWord(false);
            ctrlMess.setEditable(false);
            ctrlMess.setTabSize(4);
            ctrlMess.setText(msg);
            JScrollPane scrMess = new JScrollPane(ctrlMess);
            scrMess.setPreferredSize(new Dimension(500, 300));
            JOptionPane.showMessageDialog(parent, scrMess);
        } else {
            JOptionPane.showMessageDialog(parent, msg);
        }
    }
}

