/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class DistribFormatter
extends SimpleFormatter {
    Date dat = new Date();
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String format = "{0,date} {0,time}";
    private final MessageFormat formatter = new MessageFormat("{0,date} {0,time}");
    private Object[] args = new Object[1];

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        this.dat.setTime(record.getMillis());
        this.args[0] = this.dat;
        StringBuffer textDate = new StringBuffer();
        this.formatter.format(this.args, textDate, (FieldPosition)null);
        sb.append(textDate);
        sb.append(" ");
        sb.append("[");
        sb.append(Thread.currentThread().getName());
        sb.append("] ");
        String message = this.formatMessage(record);
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message);
        sb.append(lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

