/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.peers;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.PeerChangeListener;
import com.dassault.cecilia.lib.distrib.filetransfert.ClientFileReceiver;
import com.dassault.cecilia.lib.distrib.jxtautility.DistribException;
import com.dassault.cecilia.lib.distrib.jxtautility.JXTAException;
import com.dassault.cecilia.lib.distrib.jxtautility.MessageUtility;
import com.dassault.cecilia.lib.distrib.jxtautility.StackTracePrinter;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.PeerClient;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonClient;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonException;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.xmlutility.MessageInfoAnalyser;
import java.io.IOException;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.util.JxtaBiDiPipe;
import net.jxta.util.PipeEventListener;

public class BidiPipeClient
extends Thread
implements PipeMsgListener,
PipeEventListener {
    protected JxtaBiDiPipe _bipipe;
    protected InfoPeerJXTA _infoServeur;
    protected PeerClient _peerClient;

    public BidiPipeClient(PeerClient client, InfoPeerJXTA serveur) {
        assert (serveur.getType().equals("SERVER"));
        this._infoServeur = serveur;
        this._peerClient = client;
    }

    public boolean connect() {
        if (this._infoServeur.getPipeAdv() == null) {
            this._peerClient.removeRemote(this._infoServeur);
            Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(this._infoServeur.getName()) + " " + "No PipeAdv");
            return false;
        }
        if (this._bipipe != null) {
            try {
                this._bipipe.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this._bipipe = new JxtaBiDiPipe();
        this._bipipe.setPipeEventListener((PipeEventListener)this);
        try {
            this._bipipe.setReliable(true);
            this._bipipe.connect(this._peerClient.getNetPeerGroup(), this._infoServeur.getPeerID(), this._infoServeur.getPipeAdv(), 60000, (PipeMsgListener)this);
            this._infoServeur.setBidiPipe(this._bipipe);
        }
        catch (IOException e) {
            this._infoServeur.setStatus(0, PeerChangeListener.Reason.BECAUSE_OF_BROKEN_PIPE);
            JXTAException ex = new JXTAException();
            ex.setCondition("During Connection");
            ex.setRemotePeer(this._infoServeur);
            ex.setTypeOfError(1);
            this._peerClient.reportDistribException(ex);
            return false;
        }
        catch (NullPointerException npe) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, npe);
            this._infoServeur.setStatus(0, PeerChangeListener.Reason.BECAUSE_OF_BROKEN_PIPE);
            this._peerClient.removeRemote(this._infoServeur);
            npe.printStackTrace();
            return false;
        }
        catch (Exception e) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, e);
            this._infoServeur.setStatus(0, PeerChangeListener.Reason.BECAUSE_OF_BROKEN_PIPE);
            this._peerClient.removeRemote(this._infoServeur);
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        if (this.connect()) {
            Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(this._infoServeur.getName()) + " " + "OK");
        } else {
            Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(this._infoServeur.getName()) + " " + "KO");
        }
        if (this._bipipe != null) {
            this._bipipe.setMessageListener((PipeMsgListener)this);
        }
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        Message message = event.getMessage();
        MessageElement element = message.getMessageElement("INFO");
        if (element == null) {
            this._peerClient.getClientCecilia().printError("un message ne contenant pas d'info a ete recu de " + this._infoServeur.getName());
            return;
        }
        MessageInfoAnalyser info = null;
        try {
            info = new MessageInfoAnalyser(element);
        }
        catch (JXTAException e) {
            this._peerClient.getClientCecilia().printError("Message invalide recu de " + this._infoServeur.getName() + " : " + e.getElt().toString());
            return;
        }
        String type = info.getType();
        try {
            if (type.equals("FILETRANSFERT")) {
                if (!this.verifyEltAtt(info, "FILENAME", element)) {
                    return;
                }
                try {
                    ClientFileReceiver receiver = ClientFileReceiver.getFileReceiver(this._peerClient.getClientCecilia(), info);
                    receiver.manageMessage(message);
                }
                catch (DistribException e2) {
                    this._peerClient.reportDistribException(e2);
                }
            } else if (type.equals("CECILIARESPONSE")) {
                if (!this.verifyEltAtt(info, "UID", element)) {
                    return;
                }
                this._peerClient.getClientCecilia().manageCeciliaResponseMessage(message, info);
            } else if (type.equals("REQSTATE")) {
                if (!this.verifyEltAtt(info, "UID", element)) {
                    return;
                }
                if (!this.verifyEltAtt(info, "SENDERID", element)) {
                    return;
                }
                this._peerClient.getClientCecilia().manageStateMessage(info);
            } else if (type.equals("ADMINISTRATION")) {
                if (!this.verifyEltAtt(info, "ADMINTYPE", element)) {
                    return;
                }
                if (!this.verifyEltAtt(info, "SENDERID", element)) {
                    return;
                }
                this._peerClient.getClientCecilia().manageAdminMessage(message, info);
            } else if (type.equals("ISSUE")) {
                this._peerClient.getClientCecilia().manageCeciliaIssueMessage(message, info);
            } else if (type.equals("ERROR")) {
                this._peerClient.getClientCecilia().printError(String.valueOf(this._infoServeur.getName()) + "n'a pas compris un de mes messages : ");
                MessageElement eltErr = message.getMessageElement("ERROR");
                if (eltErr == null) {
                    this._peerClient.getClientCecilia().printError("aucune info n'est disponible sur le message errone");
                } else {
                    this._peerClient.getClientCecilia().printError(eltErr.toString());
                }
            } else {
                this.reportBadMessage(element);
            }
        }
        catch (ReqAutomatonException e) {
            Loggeur.log(this.getClass(), Loggeur.DEBUG, StackTracePrinter.getStackTrace(e));
            Request req = e.getRequest();
            req.setInfo("pipeMsgEventClient " + type + " " + e.getMessage());
            ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.CANCEL_BY_SOFTWARE);
        }
    }

    private void reportBadMessage(MessageElement element) {
        System.err.println("Bad Message !!!!!!!\n################");
        this._infoServeur.sendMessage(MessageUtility.createErrorMessage(element));
    }

    private boolean verifyEltAtt(MessageInfoAnalyser info, String attribut, MessageElement element) {
        String toverify = info.getAttribut(attribut);
        if (toverify == null || toverify.equals("")) {
            Loggeur.log(this.getClass(), Loggeur.FATAL, String.valueOf(ResJXTA.getString("NETWORK_MESSAGE_FROM_UNKNOWN_PEER")) + attribut);
            this.reportBadMessage(element);
            return false;
        }
        return true;
    }

    public void pipeEvent(int event) {
        if (event == 1) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, "PIPE_CLOSED_EVENT for " + this._infoServeur.getName());
            this._infoServeur.setStatus(0, PeerChangeListener.Reason.BECAUSE_OF_PIPE_CLOSED_BY_REMOTE);
        }
    }
}

