/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.peers;

import com.dassault.cecilia.lib.distrib.JXTAProperties;
import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.compute.ACeciliaBDDComputor;
import com.dassault.cecilia.lib.distrib.compute.ARALIA2Computor;
import com.dassault.cecilia.lib.distrib.compute.ARALIA4Computor;
import com.dassault.cecilia.lib.distrib.compute.ARALIAComputor;
import com.dassault.cecilia.lib.distrib.compute.Computor;
import com.dassault.cecilia.lib.distrib.compute.CxuComputor;
import com.dassault.cecilia.lib.distrib.compute.ServerComputingThread;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoAppList;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoClientApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoClientsApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.PeerChangeListener;
import com.dassault.cecilia.lib.distrib.ihm.IHMServer;
import com.dassault.cecilia.lib.distrib.jxtautility.FileDirDeletor;
import com.dassault.cecilia.lib.distrib.jxtautility.LockUtility;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.AppPeer;
import com.dassault.cecilia.lib.distrib.peers.MessagePrinter;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import com.dassault.cecilia.lib.distrib.peers.PeerServer;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonClient;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonException;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonServer;
import com.dassault.cecilia.lib.distrib.request.ReqChangeListener;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.requestManagement.AdminManagerServeur;
import com.dassault.cecilia.lib.distrib.requestManagement.DistributorServer;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestConsigne;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestStockServer;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestTrash;
import com.dassault.cecilia.lib.distrib.xmlutility.MessageInfoAnalyser;
import com.dassault.cecilia.lib.distrib.xmlutility.XMLMessageCreator;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;

public class CECILIAServer
implements AppPeer,
MessagePrinter,
PeerChangeListener,
ReqChangeListener {
    protected PeerServer _peerServer;
    protected InfoClientsApp _clientsApp;
    protected RequestStockServer _requestStock;
    protected RequestTrash _trash;
    protected ServerComputingThread _computor;
    protected DistributorServer _distributor;
    protected AdminManagerServeur _admManager;
    protected Window _ihm;
    private Map<String, RequestConsigne> _consignes = new HashMap<String, RequestConsigne>();
    private static CECILIAServer _singletonServeur;
    private static ThreadLocal<Boolean> __singletonServerLocal;
    private static short __singletonServerShutdown;

    static {
        __singletonServerLocal = new ThreadLocal();
        __singletonServerShutdown = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized CECILIAServer getServer() {
        if (__singletonServerLocal.get() != null) return _singletonServeur;
        Class<CECILIAServer> clazz = CECILIAServer.class;
        synchronized (CECILIAServer.class) {
            if (_singletonServeur == null) {
                LockUtility.createLock(true);
                _singletonServeur = new CECILIAServer();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        _singletonServeur.shutdown();
                    }
                });
                _singletonServeur.init();
            }
            __singletonServerLocal.set(Boolean.TRUE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return _singletonServeur;
        }
    }

    public static boolean isActive() {
        return _singletonServeur != null;
    }

    private CECILIAServer() {
        int delay = Integer.getInteger("cecilia.jxta.launch.delay", 180);
        this.attente(delay);
        this._clientsApp = new InfoClientsApp();
        this._requestStock = new RequestStockServer(this);
        this._trash = new RequestTrash();
        this._computor = new ServerComputingThread(this);
        this._peerServer = new PeerServer(this);
        this._distributor = new DistributorServer(this);
        this._admManager = new AdminManagerServeur(this);
    }

    private void init() {
        if (Boolean.getBoolean("cecilia.jxta.temp.empty.startup")) {
            FileDirDeletor.emptyDir(JXTAProperties.getTempDir());
        }
        this.addcomputors();
        this.displayEngines();
        this._peerServer.startJxta();
        this._computor.start();
        this._distributor.start();
        this._peerServer.waitForConnection();
        this._peerServer.periodicDisplayRemote();
        Loggeur.log(this.getClass(), Loggeur.INFO, ResJXTA.getString("SERVER_LAUNCHED"));
        Timer consigneWatcher = new Timer("CONSIGNE", true);
        consigneWatcher.schedule(new TimerTask(){

            @Override
            public void run() {
                CECILIAServer.this.verifyConsignedPeer();
            }
        }, 0L, (long)Integer.getInteger("cecilia.jxta.verify.consigne.time", 60000).intValue());
        if (JXTAProperties.getBoolProperty("cecilia.jxta.ihm") && __singletonServerShutdown == 0) {
            this._ihm = new IHMServer(null);
            ((IHMServer)this._ihm).init(this);
            ((IHMServer)this._ihm).setVisible(true);
        }
    }

    private void attente(int sec) {
        if (sec == 0) {
            return;
        }
        try {
            int i = 0;
            while (i < 10) {
                this.printInfo("Launching in " + String.valueOf(sec - i * sec / 10) + " secondes");
                Thread.sleep(sec / 10 * 1000);
                ++i;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void manageCeciliaRequestMessage(Message message, MessageInfoAnalyser info) {
        String reqID = info.getAttribut("UID");
        Request req = new Request(reqID);
        req.addChangeListener(this);
        req.initialiseFromMessage(info);
        ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.NEW_2_WAIT_COMPUTING);
        this._peerServer.print(MessageFormat.format(ResJXTA.getString("RECEPTION_NEW_REQUEST"), this._clientsApp.getClient(req.getClientID()).getName(), req.getShortNumber()));
        this._requestStock.addRequest(req);
    }

    public void manageStateMessage(MessageInfoAnalyser info) {
        String reqStr = info.getAttribut("UID");
        String senderID = info.getAttribut("SENDERID");
        assert (reqStr != null);
        Request req = this._requestStock.getRequest(reqStr);
        if (req == null) {
            Loggeur.log(this.getClass(), Loggeur.DEBUG, "RequestReceiverServer(1)" + reqStr);
            return;
        }
        if (!req.getClientID().equals(senderID)) {
            Loggeur.log(this.getClass(), Loggeur.INFO, String.valueOf(ResJXTA.getString("REQUEST_INVALID_SERVER_FOR_REQ")) + req.getShortNumber());
            return;
        }
        String stateStr = info.getAttribut("STATUS");
        ReqState state = ReqState.valueOf(stateStr);
        if (state == null) {
            throw new ReqAutomatonException(req, req.getState(), null);
        }
        switch (state) {
            case RESULT_SENT: {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.SENDING_RESULT_2_RESULT_SENT);
                break;
            }
            case RESULTS_TRANSFERT_ERROR: {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.SENDING_RESULT_2_RESULTS_TRANFERT_ERROR);
                break;
            }
            case CANCEL_BY_SOFTWARE: {
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.CANCEL_BY_SOFTWARE);
                break;
            }
            default: {
                Loggeur.log(this.getClass(), Loggeur.ERROR, ResJXTA.getString("ADMIN_UNKNOWN_ADMIN_MESSAGE"));
            }
        }
    }

    public void manageAdminMessage(Message message, MessageInfoAnalyser info) {
        this._admManager.manageAdminMessage(message, info);
    }

    public void sendInfo() {
        this._admManager.remoteSendInfo();
    }

    public void refuseConnection(InfoClientApp clientApp) {
        this._admManager.refuseConnection(clientApp);
    }

    public MessageElement createInfoElement() {
        HashMap<String, String> attMap = new HashMap<String, String>();
        int reqToCompute = this._requestStock.size();
        attMap.put("STOCKSIZE", String.valueOf(reqToCompute));
        attMap.put("SHUTINGDOWN", this._peerServer.isShutingDown() ? "true" : "false");
        Request req = this._computor.getCurrentReq();
        attMap.put("CURRENTREQUEST", req != null ? req.getID() : " ");
        List<String> engines = this._computor.getAuthorizedEnginesList();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < engines.size()) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(engines.get(i));
            ++i;
        }
        attMap.put("AUTHORIZEDENGINES", sb.toString());
        XMLMessageCreator messageXML = new XMLMessageCreator();
        messageXML.addEntity("STATRESPONSE", attMap, null);
        StringMessageElement elt = new StringMessageElement("STATRESPONSE", messageXML.toString(), null);
        return elt;
    }

    protected void addcomputors() {
        Computor ban;
        Class<?> cl;
        this._computor.addComputor("TESTFILE", new CxuComputor());
        ARALIAComputor engine = new ARALIA2Computor();
        if (((ARALIA2Computor)engine).verifyEngine()) {
            this._computor.addComputor("ARALIA", engine);
        }
        if (((ARALIA4Computor)(engine = new ARALIA4Computor())).verifyEngine()) {
            this._computor.addComputor("ARALIA4", engine);
        }
        if (((ACeciliaBDDComputor)(engine = new ACeciliaBDDComputor())).verifyEngine()) {
            this._computor.addComputor("CECILIABDD", engine);
        }
        try {
            cl = Class.forName("com.dassault.cecilia.lib.distrib.compute.BANExternalComputor");
            ban = (Computor)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (ban.verifyEngine()) {
                this._computor.addComputor("BAN", ban);
            }
        }
        catch (Throwable e) {
            Loggeur.log(this.getClass(), Loggeur.WARNING, ResJXTA.getString("ENGINE_BAN_NOT_IN_PATH"));
        }
        try {
            Class.forName("com.dassault.cecilia.lib.ban.BanProcessListener");
            cl = Class.forName("com.dassault.cecilia.lib.distrib.compute.BANComputor");
            ban = (Computor)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (ban.verifyEngine()) {
                this._computor.addComputor("iBAN", ban);
            }
        }
        catch (Throwable e) {
            Loggeur.log(this.getClass(), Loggeur.WARNING, ResJXTA.getString("ENGINE_BAN_NOT_IN_PATH"));
        }
    }

    public void setAuthorizedEngine(List<String> authorized) {
        this._computor.setAuthorizedEnginesList(authorized);
        this.sendInfo();
    }

    @Override
    public void printError(String s) {
        Loggeur.log(this.getClass(), Loggeur.ERROR, s);
    }

    public RequestStockServer getRequestStock() {
        return this._requestStock;
    }

    public Map<String, RequestConsigne> getRequestsConsigne() {
        return this._consignes;
    }

    public RequestTrash getRequestTrash() {
        return this._trash;
    }

    @Override
    public void printInfo(String s) {
        Loggeur.log(this.getClass(), Loggeur.INFO, s);
    }

    public void displayEngines() {
        StringBuffer info = new StringBuffer(64);
        info.append("Moteurs = {");
        Iterator<String> it = this._computor.getEnginesList().iterator();
        while (it.hasNext()) {
            String moteur = it.next();
            info.append(moteur);
            if (!it.hasNext()) continue;
            info.append(",");
        }
        info.append("}");
        this.printInfo(info.toString());
    }

    public ServerComputingThread getComputor() {
        return this._computor;
    }

    @Override
    public PeerJXTA getPeerJXTA() {
        return this._peerServer;
    }

    @Override
    public void peerStatusChange(String peerID, int oldStatus, int newStatus, PeerChangeListener.Reason reason) {
        InfoPeerJXTA peer = this._peerServer.getRemotePeer(peerID);
        if (peer == null) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, MessageFormat.format(ResJXTA.getString("NETWORK_CLIENT_DISCONNECTED"), peerID));
            return;
        }
        if (oldStatus == 1 && newStatus == 0) {
            if (reason == PeerChangeListener.Reason.BECAUSE_OF_BROKEN_PIPE || reason == PeerChangeListener.Reason.BECAUSE_OF_PIPE_CLOSED_BY_REMOTE) {
                this.disconnectClient(peer, reason);
            } else {
                ArrayList<Request> reqs = this._requestStock.getClientRequests(peerID);
                Loggeur.log(this.getClass(), Loggeur.DEBUG, MessageFormat.format(ResJXTA.getString("NETWORK_CLIENT_REQUEST_REMOVED"), String.valueOf(reqs.size())));
                for (Request request : reqs) {
                    request.setPriority(Integer.MIN_VALUE);
                }
                RequestConsigne consigne = new RequestConsigne(peer);
                Loggeur.log(this.getClass(), Loggeur.DEBUG, MessageFormat.format(ResJXTA.getString("NETWORK_CLIENT_NOT_ONLINE_CONSIGNE_CREATED"), peer.getName()));
                RequestConsigne oldConsigne = this._consignes.put(peerID, consigne);
                if (oldConsigne != null) {
                    Loggeur.log(this.getClass(), Loggeur.FATAL, "Double Consigne :" + peer.getName());
                }
            }
        } else if (newStatus == 1 && oldStatus == 0) {
            RequestConsigne consigne = this._consignes.remove(peerID);
            if (consigne != null) {
                List<Request> inConsigne = consigne.flush();
                for (Request request : inConsigne) {
                    this._requestStock.addRequest(request);
                }
            }
        } else if (newStatus == 0 && oldStatus == 0 && (reason == PeerChangeListener.Reason.BECAUSE_OF_BROKEN_PIPE || reason == PeerChangeListener.Reason.BECAUSE_OF_PIPE_CLOSED_BY_REMOTE)) {
            this.disconnectClient(peer, reason);
        }
    }

    private void disconnectClient(InfoPeerJXTA peer, PeerChangeListener.Reason reason) {
        String peerID = peer.getPeerIDString();
        Loggeur.log(this.getClass(), Loggeur.INFO, MessageFormat.format(ResJXTA.getString("NETWORK_CLIENT_DISCONNECTED"), peer.getName()));
        Loggeur.log(this.getClass(), Loggeur.INFO, "Reason = " + reason.name());
        this._clientsApp.removeClient(this._clientsApp.getClient(peerID));
        peer.closeConnection();
        ArrayList<Request> reqs = this._requestStock.getClientRequests(peerID);
        Loggeur.log(this.getClass(), Loggeur.DEBUG, MessageFormat.format(ResJXTA.getString("NETWORK_CLIENT_REQUEST_REMOVED"), String.valueOf(reqs.size())));
        for (Request request : reqs) {
            ReqAutomatonServer.fireEvent(request, ReqAutomatonServer.EvtServer.NETWORK_DISCONNECT);
        }
        RequestConsigne consigne = this._consignes.remove(peerID);
        if (consigne != null) {
            List<Request> inConsigne = consigne.flush();
            for (Request request : inConsigne) {
                ReqAutomatonServer.fireEvent(request, ReqAutomatonServer.EvtServer.NETWORK_DISCONNECT);
                this._trash.add(request);
            }
        }
    }

    private void verifyConsignedPeer() {
        Set<String> ids = this._consignes.keySet();
        for (String id : ids) {
            this._admManager.remoteAskForInfo(id);
        }
    }

    @Override
    public void requestStateChange(final Request req, ReqState oldState, ReqState newState) {
        if (ReqAutomatonServer.mustBeReportedToRemote(newState)) {
            this._distributor.remoteSendRequestStatus(req);
        }
        if (newState == ReqState.RESULT_SENT || newState == ReqState.NETWORK_DISCONNECT || newState == ReqState.CANCEL_BY_USER || newState == ReqState.CANCEL_BY_SOFTWARE) {
            this._requestStock.removeRequest(req);
            this._trash.add(req);
            req.deleteNeededFile();
            req.deleteResultFiles();
        }
        if (newState == ReqState.CANCEL_BY_ADMIN) {
            new Thread("CANCEL_BY_ADMIN"){

                @Override
                public void run() {
                    try {
                        3.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    CECILIAServer.this._requestStock.removeRequest(req);
                    CECILIAServer.this._trash.add(req);
                    req.deleteNeededFile();
                    req.deleteResultFiles();
                }
            }.start();
        }
    }

    public InfoClientsApp getClientsApp() {
        return this._clientsApp;
    }

    @Override
    public InfoAppList getRemoteAppList() {
        return this.getClientsApp();
    }

    public void waitEmptyStock(long maxTimeToWait) {
        long begin = System.currentTimeMillis();
        while (this._requestStock.size() != 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (System.currentTimeMillis() - begin > maxTimeToWait) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Loggeur.log(this.getClass(), Loggeur.DEBUG, "Server shutdown call");
        Class<CECILIAServer> clazz = CECILIAServer.class;
        synchronized (CECILIAServer.class) {
            if (__singletonServerShutdown == 0) {
                __singletonServerShutdown = 1;
                if (this._ihm != null) {
                    try {
                        this._ihm.dispose();
                    }
                    catch (Exception e) {
                        Loggeur.log(this.getClass(), Loggeur.WARNING, e);
                    }
                }
                this._peerServer.stop();
                if (this._computor.isAlive()) {
                    this._computor.stopComputing();
                    this._computor.shutDownComputor();
                }
                if (this._distributor.isAlive()) {
                    this._distributor.stopDistribution();
                }
                LockUtility.removeLock();
            }
            __singletonServerShutdown = (short)2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void main(String[] args) {
        JXTAProperties.initLaunchIni();
        CECILIAServer.getServer();
    }

    public static void stop() {
        Loggeur.log(CECILIAServer.class, Loggeur.INFO, ResJXTA.getString("STOP"));
        if (_singletonServeur != null) {
            _singletonServeur.shutdown();
        }
        System.exit(0);
    }
}

