/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.peers;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.jxtautility.DistribException;
import com.dassault.cecilia.lib.distrib.jxtautility.NetworkUtility;
import com.dassault.cecilia.lib.distrib.jxtautility.StackTracePrinter;
import com.dassault.cecilia.lib.distrib.jxtautility.URIListUtility;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.BidiPipeClient;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.peers.PeerJXTA;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;

public class PeerClient
extends PeerJXTA {
    public static final String MessageEltName = "pipe_tutorial";
    protected NetworkUtility networkUtil;
    protected CECILIAClient _clientCecilia;

    public PeerClient(CECILIAClient clientCecilia) {
        this._clientCecilia = clientCecilia;
    }

    @Override
    public void startJxta() {
        super.startJxta();
        this._manager.searchForPeers(this);
        URIListUtility.saveURIsToFile(new File(this.getJXTAHome(), "discovered.peer").getAbsolutePath());
        this.connectServers();
        this.periodicCheckOnlineStatus();
    }

    @Override
    public ArrayList<InfoPeerJXTA> refreshNetwork() {
        ArrayList<InfoPeerJXTA> toBeTrashed = super.refreshNetwork();
        toBeTrashed.addAll(this.connectServers());
        return toBeTrashed;
    }

    @Override
    protected Thread createBidiPipe(InfoPeerJXTA serveur) {
        return new BidiPipeClient(this, serveur);
    }

    @Override
    public String createDescription() {
        StringBuffer sb = new StringBuffer(32);
        sb.append("PEERTYPE");
        sb.append("=");
        sb.append("CLIENT");
        sb.append(",");
        sb.append("VERSION");
        sb.append("=");
        sb.append("1.8.4");
        sb.append(",");
        sb.append("HOSTNAME");
        sb.append("=");
        try {
            sb.append(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            sb.append("");
        }
        sb.append(",");
        sb.append("APPTYPES");
        sb.append("=");
        Iterator types = this._types.iterator();
        while (types.hasNext()) {
            String type = (String)types.next();
            sb.append(type);
            if (!types.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public void reportDistribException(DistribException e) {
        if (e.getMessage() == null) {
            Loggeur.log(this.getClass(), Loggeur.ERROR, StackTracePrinter.getStackTrace(e));
        } else {
            Loggeur.log(this.getClass(), Loggeur.ERROR, String.valueOf(ResJXTA.getString("NETWORK_PEER_ERROR")) + " " + e.getRemotePeerID() + " " + e.getMessage());
        }
    }

    public CECILIAClient getClientCecilia() {
        return this._clientCecilia;
    }
}

