/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.requestManagement;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoClientApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.CECILIAServer;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonServer;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.requestManagement.AdminManager;
import com.dassault.cecilia.lib.distrib.requestManagement.AdminMessageCreator;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestConsigne;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestStockServer;
import com.dassault.cecilia.lib.distrib.xmlutility.MessageInfoAnalyser;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.jxta.endpoint.Message;

public class AdminManagerServeur
extends AdminManager {
    private RequestStockServer _stock;

    public AdminManagerServeur(CECILIAServer peer) {
        super(peer);
        this._stock = peer.getRequestStock();
    }

    @Override
    protected void doManageAdminMessage(int type, String senderID, InfoPeerApp remote, Message mess, MessageInfoAnalyser info) {
        if (type == 27) {
            String newList = info.getAttribut("NEWENGINES");
            ArrayList<String> enginesList = new ArrayList<String>();
            if (newList != null) {
                StringTokenizer st = new StringTokenizer(newList, "|");
                while (st.hasMoreTokens()) {
                    String engine = st.nextToken();
                    enginesList.add(engine);
                }
            }
            if (enginesList.size() == 0) {
                Loggeur.log(this.getClass(), Loggeur.WARNING, "No engine is autorized");
            }
            ((CECILIAServer)this._appPeer).setAuthorizedEngine(enginesList);
        } else {
            super.doManageAdminMessage(type, senderID, remote, mess, info);
        }
    }

    @Override
    protected void remoteSendInfo(String peerToInform) {
        InfoClientApp clientApp = ((CECILIAServer)this._appPeer).getClientsApp().getClient(peerToInform);
        if (clientApp != null && clientApp.canTalkWith()) {
            this.remoteSendInfo(clientApp.getPeerJXTA());
        } else if (clientApp != null) {
            Loggeur.log(this.getClass(), Loggeur.WARNING, String.valueOf(ResJXTA.getString("ADMIN_UNKNOWN_PEER_FOR_INFO")) + clientApp.getName());
        } else {
            Loggeur.log(this.getClass(), Loggeur.WARNING, String.valueOf(ResJXTA.getString("ADMIN_UNKNOWN_PEER_FOR_INFO")) + " null");
        }
    }

    @Override
    protected void localStopAllRequest(String senderID) {
        this.localStopAllRequest(senderID, ReqAutomatonServer.EvtServer.CANCEL_BY_USER);
    }

    private void localStopAllRequest(String senderID, ReqAutomatonServer.EvtServer typeOfCancel) {
        InfoClientApp client = ((CECILIAServer)this._appPeer).getClientsApp().getClient(senderID);
        if (client == null) {
            Loggeur.log(this.getClass(), Loggeur.DEBUG, "AdminManagerServeur.localStopAllRequest()");
            return;
        }
        ArrayList<Request> reqs = this._stock.getClientRequests(client.getPeerID());
        RequestConsigne consigne = ((CECILIAServer)this._appPeer).getRequestsConsigne().get(client.getPeerID());
        if (consigne != null) {
            reqs.addAll(consigne.flush());
        }
        for (Request request : reqs) {
            ReqAutomatonServer.fireEvent(request, typeOfCancel);
        }
        ((CECILIAServer)this._appPeer).getComputor().stopComputing(senderID);
    }

    @Override
    protected void localStopRequest(String reqID, String senderID) {
        this._appPeer.printInfo("Demande d'arret de la requete " + reqID);
        Request req = this._stock.getRequest(reqID);
        if (req != null && req.getClientID().equals(senderID)) {
            ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.CANCEL_BY_USER);
            ((CECILIAServer)this._appPeer).getComputor().stopComputing(req);
        } else {
            this._appPeer.printInfo("Droit insuffisant pour arreter la requete");
        }
    }

    @Override
    protected void localAdminStopRequest(String reqID) {
        Request req = this._stock.getRequest(reqID);
        if (req == null) {
            Collection<RequestConsigne> values = ((CECILIAServer)this._appPeer).getRequestsConsigne().values();
            for (RequestConsigne requestConsigne : values) {
                req = requestConsigne.getRequest(reqID);
                if (req != null) break;
            }
        }
        if (req == null) {
            return;
        }
        ReqAutomatonServer.fireEvent(req, ReqAutomatonServer.EvtServer.CANCEL_BY_ADMIN);
        ((CECILIAServer)this._appPeer).getComputor().stopComputing(req);
    }

    @Override
    protected void localAdminStopAllRequest(String clientID) {
        this.localStopAllRequest(clientID, ReqAutomatonServer.EvtServer.CANCEL_BY_ADMIN);
    }

    @Override
    protected void localAdminStopAllRequest() {
        Iterator<? extends InfoPeerApp> clients = this._appPeer.getRemoteAppList().iterator();
        while (clients.hasNext()) {
            InfoPeerApp client = clients.next();
            this.localStopAllRequest(client.getPeerID(), ReqAutomatonServer.EvtServer.CANCEL_BY_ADMIN);
        }
        ((CECILIAServer)this._appPeer).getComputor().stopComputing();
    }

    @Override
    public void localAdminShutDown() {
        CECILIAServer serveur = (CECILIAServer)this._appPeer;
        serveur.getComputor().shutDownComputor();
        Loggeur.log(this.getClass(), Loggeur.INFO, MessageFormat.format(ResJXTA.getString("ADMIN_SERVEUR_SHUTING_DOWN_INFO"), ""));
        this._peerJXTA.setShutingDown();
        this.remoteSendInfo();
        try {
            while (!serveur.getComputor().isFinished()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ((CECILIAServer)this._appPeer).waitEmptyStock(5000L);
        Loggeur.log(this.getClass(), Loggeur.INFO, MessageFormat.format(ResJXTA.getString("ADMIN_SERVEUR_SHUTING_DOWN"), ""));
        serveur.shutdown();
    }

    private void remoteSendInfo(InfoPeerJXTA remotePeer) {
        AdminMessageCreator admMessage = new AdminMessageCreator(6, "", this._peerJXTA.getPeerIDString());
        Message message = admMessage.createMessage();
        message.addMessageElement(((CECILIAServer)this._appPeer).createInfoElement());
        remotePeer.sendMessage(message);
    }

    public void remoteSendInfo() {
        new Thread(){

            @Override
            public void run() {
                Iterator<InfoClientApp> itApp = ((CECILIAServer)AdminManagerServeur.this._appPeer).getClientsApp().iterator();
                while (itApp.hasNext()) {
                    InfoClientApp remoteClient = itApp.next();
                    if (remoteClient == null || !remoteClient.canTalkWith()) continue;
                    AdminManagerServeur.this.remoteSendInfo(remoteClient.getPeerJXTA());
                }
            }
        }.start();
    }

    public void refuseConnection(InfoClientApp client) {
        AdminMessageCreator message = new AdminMessageCreator(20, null, this._peerJXTA.getPeerIDString());
        Message refuseMessage = message.createMessage();
        client.getPeerJXTA().sendMessage(refuseMessage);
    }

    @Override
    protected void localChangePriority(String clientID, int prio) {
        InfoClientApp client = ((CECILIAServer)this._appPeer).getClientsApp().getClient(clientID);
        if (client == null) {
            Loggeur.log(this.getClass(), Loggeur.DEBUG, "AdminManagerServeur.localChangePriority() : unused Client");
            return;
        }
        Loggeur.log(this.getClass(), Loggeur.INFO, MessageFormat.format(ResJXTA.getString("PRIORITY_CHANGE_CLIENT"), client.getName(), String.valueOf(prio)));
        ArrayList<Request> reqs = this._stock.getClientRequests(client.getPeerID());
        for (Request request : reqs) {
            request.setPriority(prio);
        }
    }
}

