/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.requestManagement;

import com.dassault.cecilia.lib.distrib.ResJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoPeerJXTA;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServerApp;
import com.dassault.cecilia.lib.distrib.entityinfo.InfoServersApp;
import com.dassault.cecilia.lib.distrib.filetransfert.ByteFileSender;
import com.dassault.cecilia.lib.distrib.filetransfert.FileNameUtility;
import com.dassault.cecilia.lib.distrib.jxtautility.DistribException;
import com.dassault.cecilia.lib.distrib.jxtautility.MessageUtility;
import com.dassault.cecilia.lib.distrib.jxtautility.StackTracePrinter;
import com.dassault.cecilia.lib.distrib.log.Loggeur;
import com.dassault.cecilia.lib.distrib.peers.CECILIAClient;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonClient;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonException;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestStockClient;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import net.jxta.endpoint.Message;

public class DistributorClient
extends Thread {
    private RequestStockClient _stock;
    private CECILIAClient _client;
    private InfoServersApp _serversApp;
    private boolean stop;

    public DistributorClient(CECILIAClient client) {
        super("DISTRIBUTOR");
        this.setPriority(1);
        this._client = client;
        this._stock = client.getRequestStock();
        this._serversApp = client.getServersApp();
        this.stop = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                try {
                    while (true) {
                        DistributorClient distributorClient = this;
                        synchronized (distributorClient) {
                            Thread.currentThread().wait(1000L);
                        }
                        this.distribute();
                    }
                }
                catch (ReqAutomatonException rae) {
                    Request req = rae.getRequest();
                    req.setInfo("DistributorClient" + rae.getMessage());
                    Loggeur.log(this.getClass(), Loggeur.FATAL, rae.getMessage());
                    if (req.getHisto().countState(ReqState.NEW) < 3) {
                        req.relaunch();
                        continue;
                    }
                    ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.CANCEL_BY_SOFTWARE);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Loggeur.log(this.getClass(), Loggeur.FATAL, e.getMessage());
            Loggeur.log(this.getClass(), Loggeur.FATAL, StackTracePrinter.getStackTrace(e));
            return;
        }
    }

    public boolean distribute() {
        Request req = null;
        boolean serveurDispo = true;
        while ((req = this._stock.getNextRequestToDistribute()) != null) {
            if (this.stop) {
                return false;
            }
            serveurDispo = this.distribute(req);
        }
        return serveurDispo;
    }

    public void stopDistributor() {
        this.stop = true;
    }

    public void startDistributor() {
        this.stop = false;
    }

    public boolean distribute(Request req) {
        InfoServerApp server;
        assert (req != null);
        InfoServerApp serveurToUse = null;
        String serverId = req.getServerID();
        if (serverId != null && !serverId.equals("") && (server = this._serversApp.getServer(serverId)) != null && server.canBeUsedForComputation(req.getEngine())) {
            serveurToUse = server;
        }
        if (serveurToUse == null) {
            serveurToUse = this._serversApp.getNextOnlineServer(0, req.getEngine());
        }
        if (serveurToUse == null) {
            ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.NEW_2_NO_SERVER_AVAILABLE);
            return false;
        }
        req.setClientID(this._client.getPeerJXTA().getPeerIDString());
        req.setServerID(serveurToUse.getPeerID());
        this.sendRequest(req, serveurToUse);
        serveurToUse.setStockSize(serveurToUse.getStockSize() + 1);
        return true;
    }

    private void sendRequest(Request req, InfoServerApp serveur) {
        this.sendRequest(req, serveur.getPeerJXTA());
    }

    private void sendRequest(Request req, InfoPeerJXTA serveur) {
        ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.NEW_2_SENDING_REQUEST);
        this._client.printInfo(MessageFormat.format(ResJXTA.getString("DISTRIBUTION_SENDING_REQUEST"), req.getShortNumber(), serveur.getName()));
        for (String uniqueFileName : req.getNeededFiles()) {
            if (FileNameUtility.retrieveDiffuseFile(uniqueFileName)) continue;
            String localName = this._client.getLocalFileName(uniqueFileName);
            if (localName == null) {
                this._client.printError("impossible de trouver un fichier de nom unique " + uniqueFileName);
                ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.SENDING_REQUEST_2_MISSING_FILE_TO_SEND);
                return;
            }
            try {
                File file = new File(localName);
                ByteFileSender.sendFileTo(file, uniqueFileName, this._client.getPeerJXTA().getPeerIDString(), serveur, req.getID());
            }
            catch (DistribException e) {
                if (e.getMessage().equals("Problem while reading file")) {
                    this._client.printError("I/O Erreur sur un fichier : " + e.getFilename() + ", impossible d'envoyer les fichiers au serveur " + serveur.getName());
                    ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.SENDING_REQUEST_2_MISSING_FILE_TO_SEND);
                } else {
                    e.getMessage().equals("Problem while communicating with peer");
                }
                return;
            }
        }
        if (serveur.sendMessage(req.createRequestMessage())) {
            ReqAutomatonClient.fireEvent(req, ReqAutomatonClient.EvtClient.SENDING_REQUEST_2_REQUEST_SENT);
        }
    }

    public void redistribReqOfServer(InfoServerApp serverApp) {
        Request req = null;
        this._client.remoteStopRequests(serverApp);
        while ((req = this._stock.getNextRequestFor(serverApp.getPeerID())) != null) {
            req.relaunch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redistribReqToServer(InfoServerApp freeServerApp, int paquetSize) {
        Request req = null;
        String freeServerID = freeServerApp.getPeerID();
        int nbOfRedistribReq = 0;
        while ((req = this._stock.getNextRequestToRedistribute(freeServerID)) != null) {
            String originalServerID = req.getServerID();
            InfoServerApp originalServer = this._serversApp.getServer(originalServerID);
            if (originalServer == null) {
                req.relaunch();
                ++nbOfRedistribReq;
                continue;
            }
            this._client.remoteStopRequest(req);
            Request request = req;
            synchronized (request) {
                if (req.isRedistributed()) {
                    continue;
                }
                req.setRedistributed(true);
            }
            req.relaunchOn(freeServerApp.getPeerID());
            if (++nbOfRedistribReq >= paquetSize) break;
        }
    }

    public void remoteSendRequestStatus(Request req) {
        Loggeur.log(this.getClass(), Loggeur.FINEST, "remoteSendRequestStatus for " + req.getShortNumber() + " " + (Object)((Object)req.getState()));
        InfoServerApp server = this._serversApp.getServer(req.getServerID());
        if (server != null && server.canTalkWith()) {
            HashMap<String, String> attMap = new HashMap<String, String>();
            attMap.put("MESSAGETYPE", "REQSTATE");
            attMap.put("UID", req.getID());
            attMap.put("STATUS", String.valueOf((Object)req.getState()));
            Message stateMsg = MessageUtility.createMessageWithInfo(attMap, this._client.getPeerJXTA().getPeerIDString());
            server.sendMessage(stateMsg);
        }
    }
}

