/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.requestManagement;

import com.dassault.cecilia.lib.distrib.peers.CECILIAServer;
import com.dassault.cecilia.lib.distrib.request.ReqAutomatonServer;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.requestManagement.RequestStock;
import java.util.ArrayList;

public class RequestStockServer
extends RequestStock {
    private CECILIAServer _serveur;

    public RequestStockServer(CECILIAServer serveur) {
        this._serveur = serveur;
    }

    @Override
    public synchronized void addRequest(Request request) {
        super.addRequest(request);
        this._serveur.sendInfo();
    }

    @Override
    public synchronized void removeRequest(Request req) {
        super.removeRequest(req);
        this._serveur.sendInfo();
    }

    public synchronized ArrayList<Request> getClientRequests(String clientID) {
        ArrayList<Request> reqsForClient = new ArrayList<Request>();
        for (Request req : this._requests) {
            if (!req.getClientID().equals(clientID)) continue;
            reqsForClient.add(req);
        }
        return reqsForClient;
    }

    public synchronized Request getNextComputedRequest() {
        Request req2 = null;
        for (Request req2 : this._requests) {
            ReqState state = req2.getState();
            if (!ReqAutomatonServer.isErrorState(state) && state != ReqState.COMPUTE_FINISHED && state != ReqState.RESULTS_TRANSFERT_ERROR) continue;
            return req2;
        }
        return null;
    }

    public synchronized Request getNextRequestFrom(String clientID) {
        Request req2 = null;
        for (Request req2 : this._requests) {
            if (!req2.getClientID().equals(clientID)) continue;
            return req2;
        }
        return null;
    }
}

