/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.test;

import com.dassault.cecilia.lib.distrib.request.Command;
import com.dassault.cecilia.lib.distrib.request.CommandFileWriter;
import com.dassault.cecilia.lib.distrib.request.ReqState;
import com.dassault.cecilia.lib.distrib.request.Request;
import com.dassault.cecilia.lib.distrib.test.TestJXTAClient;
import com.dassault.cecilia.lib.distrib.test.TestRessources;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class TestClient
extends TestJXTAClient {
    protected int count = 0;
    private int nbTest = 0;

    @Test
    public void testSizeOf() {
        Request req = this.createAndLaunchTestRequest(15);
        this.waitEmptyStock();
        Assert.assertTrue((String)req.getHisto().toString(), (boolean)req.getHisto().endsWithList(GOOD_LIST));
    }

    public Request createAralia2() {
        Request req = this._client.getNewRequest();
        req.setEngine("ARALIA");
        Command command = this._client.getCommandWriter(req);
        command.append("load \"");
        command.addInputFile(TestRessources.getRessource("default.cfg"));
        command.append("\";");
        command.append("\n");
        command.append("load \"");
        command.addInputFile(TestRessources.getRessource("calcul.dag"));
        command.append("\";");
        command.append("\n");
        command.append("compute BDD 'ESSAI';");
        command.append("\n");
        command.append("compute q-cuts 'ESSAI';");
        command.append("\n");
        command.append("compute probability * at 1.000E00>");
        command.append("\"");
        command.addOutputFile(new File(".\\probabilityV2_" + this.count + ".res"));
        command.append("\";");
        command.append("\n");
        command.append("display products q-cuts 'ESSAI' {compute at 1.000E00 sort literals $< :>name sort products < :>order display :> probability}>");
        command.append("\"");
        command.addOutputFile(new File(".\\coupesV2_" + this.count + ".res"));
        command.append("\";");
        command.append("\n");
        command.append("exit;");
        req.setCmdFileName(command.getFileName());
        req.setParsed(true);
        ++this.count;
        return req;
    }

    @Test
    public void testRedistrib() {
        Assert.assertTrue((String)"la reditrib se teste avec 2 serveurs", (this._client.numberServer() > 1 ? 1 : 0) != 0);
        Request req = this.createAndLaunchTestRequest(15);
        int serveurs = this._client.getServersApp().getNumberOfOKServer();
        Request[] aralias = new Request[5];
        int i = 0;
        while (i < serveurs) {
            Request reqAralia;
            aralias[i] = reqAralia = this.createAralia2();
            this._client.addRequestToStock(reqAralia);
            ++i;
        }
        this.waitEmptyStock();
        Assert.assertTrue((String)req.getHisto().toString(), (boolean)req.getHisto().compareToList(GOOD_LIST));
        i = 0;
        while (i < serveurs - 1) {
            Assert.assertTrue((String)aralias[i].getHisto().toString(), (boolean)aralias[i].getHisto().compareToList(GOOD_LIST));
            ++i;
        }
        Assert.assertTrue((String)aralias[serveurs - 1].getHistoString(this._client.getPeerJXTA()).toString(), (aralias[serveurs - 1].getHisto().countState(ReqState.NEW) == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testStopOneRequest() {
        Request req = this.createAndLaunchTestRequest(15);
        Request req2 = this.createAndLaunchTestRequest(15);
        Request req3 = this.createAndLaunchTestRequest(15);
        Request req4 = this.createAndLaunchTestRequest(15);
        this._client.addRequestToStock(req4);
        this._client.cancelRequest(req3, true);
        this._client.cancelRequest(req2, true);
        this.waitEmptyStock();
        Assert.assertTrue((String)req.getHisto().toString(), (boolean)req.getHisto().compareToList(GOOD_LIST));
        Assert.assertTrue((String)req4.getHisto().toString(), (boolean)req.getHisto().compareToList(GOOD_LIST));
        Assert.assertTrue((req3.getHisto().countState(ReqState.CANCEL_BY_USER) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((req3.getHisto().countState(ReqState.COMPUTE_FINISHED) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((req2.getHisto().countState(ReqState.CANCEL_BY_USER) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((req2.getHisto().countState(ReqState.COMPUTE_FINISHED) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStopAllRequests() {
        Request req = this.createAndLaunchTestRequest(20);
        Request req2 = this.createAndLaunchTestRequest(20);
        Request req3 = this.createAndLaunchTestRequest(20);
        Request req4 = this.createAndLaunchTestRequest(20);
        Request req5 = this.createAndLaunchTestRequest(20);
        Request req6 = this.createAndLaunchTestRequest(20);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this._client.cancelAllRequest(true);
        this.waitEmptyStock();
        Assert.assertTrue((req.getHisto().countState(ReqState.CANCEL_BY_USER) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((req2.getHisto().countState(ReqState.CANCEL_BY_USER) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((req3.getHisto().countState(ReqState.CANCEL_BY_USER) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((req4.getHisto().countState(ReqState.CANCEL_BY_USER) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((req5.getHisto().countState(ReqState.CANCEL_BY_USER) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((req6.getHisto().countState(ReqState.CANCEL_BY_USER) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBigResult() {
        Request req0 = this._client.getNewRequest();
        req0.setEngine("ARALIA4");
        Command command = this._client.getCommandWriter(req0);
        command.append("load \"");
        command.addInputFile(TestRessources.getRessource("bigresultv4.dag"));
        command.append("\";\n");
        command.append("r := [@,3,roots(*)];\n");
        command.append("compute BDD r;\n");
        command.append("compute ZQC r;\n");
        command.append("approximate product-number ZQC r;\n");
        command.append("display products ZQC r > \"");
        command.addOutputFile(new File(".\\BigRes.res"));
        command.append("\";\n");
        command.append("exit;\n");
        req0.setCmdFileName(command.getFileName());
        req0.setParsed(true);
        this._client.addRequestToStock(req0);
        this.waitEmptyStock();
        File big = new File(".\\BigRes.res");
        Assert.assertTrue((String)(String.valueOf(big.length()) + " Octets"), (big.length() == 296881226L ? 1 : 0) != 0);
        Assert.assertTrue((String)req0.getHistoString(this._client.getPeerJXTA()), (boolean)req0.getHisto().endsWithList(GOOD_LIST));
    }

    @Test
    public void testBigResultWithOther() {
        ArrayList<Request> reqs = new ArrayList<Request>();
        int i = 0;
        while (i < 50) {
            reqs.add(this.createAndLaunchTestRequest(5));
            ++i;
        }
        this.testBigResult();
        i = 0;
        while (i < 50) {
            Assert.assertTrue((((Request)reqs.get(i)).getState() == ReqState.FINISHED_SUCCESFULY ? 1 : 0) != 0);
            ++i;
        }
    }

    public Request createAndLaunchTestRequest(int executionTime) {
        File file = new File(".\\taille" + this.nbTest + ".txt");
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        Request req = this._client.getNewRequest();
        req.setEngine("TESTFILE");
        req.setParsed(true);
        try {
            CommandFileWriter fw = new CommandFileWriter(this._client, req);
            fw.writeText("sizeof ");
            fw.writeInputFile(TestRessources.getRessource("bigresultv4.dag"));
            fw.writeText(" > ");
            fw.writeOutputFile(file);
            fw.writeText(" wait ");
            fw.writeText(String.valueOf(executionTime));
            fw.flushAndClose();
            req.setCmdFileName(fw);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        this._client.addRequestToStock(req);
        ++this.nbTest;
        return req;
    }
}

