/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.distrib.xmlutility;

import com.dassault.cecilia.lib.distrib.xmlutility.XMLUtility;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.InputSource;

public class XMLMessageCreator {
    StringBuffer buffer = new StringBuffer(64);

    public void addStartEntity(String entity) {
        this.buffer.append("<");
        this.buffer.append(entity);
        this.buffer.append(">");
        this.buffer.append("\n");
    }

    public void addEndEntity(String entity) {
        this.buffer.append("\n");
        this.buffer.append("</");
        this.buffer.append(entity);
        this.buffer.append(">");
        this.buffer.append("\n");
    }

    public void addEntity(String entity, Map attributes, String charValue) {
        this.buffer.append("<");
        this.buffer.append(entity);
        if (attributes != null) {
            for (Map.Entry entry : attributes.entrySet()) {
                String attName = (String)entry.getKey();
                String attValue = (String)entry.getValue();
                this.buffer.append(" ");
                this.buffer.append(attName);
                this.buffer.append("=\"");
                this.buffer.append(attValue);
                this.buffer.append("\"");
            }
        }
        if (charValue != null) {
            this.buffer.append(">");
            this.buffer.append(charValue);
            this.buffer.append("</");
            this.buffer.append(entity);
            this.buffer.append(">");
        } else {
            this.buffer.append("/>");
        }
        this.buffer.append("\n");
    }

    public String toString() {
        return this.buffer.toString();
    }

    public static void main(String[] args) {
        XMLMessageCreator test = new XMLMessageCreator();
        test.addEntity("type", null, "mon type a moi");
        HashMap<String, String> mapatt = new HashMap<String, String>();
        mapatt.put("id", "myID");
        mapatt.put("name", "toto.txt");
        test.addEntity("entitywithatt", mapatt, "charcharcharchar");
        test.addEntity("entitywithatt", mapatt, null);
        System.out.print(test.toString());
        XMLMessageCreator infoElement = new XMLMessageCreator();
        HashMap<String, String> attMap = new HashMap<String, String>();
        attMap.put("gxddg", "totp.txt");
        attMap.put("ghxgf", String.valueOf(1));
        attMap.put("ghdfhxd", String.valueOf(48));
        attMap.put("gfhxdfh", "FILETRANSFERT");
        infoElement.addEntity("INFO", attMap, null);
        System.out.print(infoElement.toString());
        StringReader reader = new StringReader(test.toString());
        InputSource source = new InputSource(reader);
        System.out.print("type=");
        System.out.print(new XMLUtility(source).findCharacters("type"));
        reader = new StringReader(test.toString());
        source = new InputSource(reader);
        System.out.print("type=");
        System.out.print(new XMLUtility(source).findCharacters("type"));
    }
}

