/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.general.robot;

import com.dassault.cecilia.core.plugin.AbstractPlugPanelInfo;
import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.plugin.general.robot.RobotPlay;
import com.dassault.cecilia.plugin.general.robot.ScenarioFileFilter;
import java.awt.AWTException;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class PluginCmdPlay
extends AbstractPluginModel
implements PluginMAction {
    protected static final String VERSION = "1.0.00";
    RobotThread _robotThread = null;

    public String getInfo(String key) {
        if (key.equals("plugin.version")) {
            return VERSION;
        }
        if (key.equals("plugin.name")) {
            return "Joue des scenarios utilisateurs";
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return "Permet des evenements claviers et/ou souris a partir d'un script xml (generalement genere a l'aide du plugin PluginCmdCapture.\n";
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    public void createSession(Plugable launcher, Object parameters) {
        File actFile = null;
        if (parameters instanceof File) {
            actFile = (File)parameters;
        } else {
            JFileChooser dlg = new JFileChooser(".");
            dlg.setFileFilter(new ScenarioFileFilter());
            dlg.setMultiSelectionEnabled(false);
            if (dlg.showOpenDialog(launcher.getWindow()) != 0) {
                return;
            }
            actFile = dlg.getSelectedFile();
        }
        try {
            this._robotThread = new RobotThread(new RobotPlay(actFile), launcher);
            this._robotThread.start();
        }
        catch (AWTException e1) {
            e1.printStackTrace();
            return;
        }
    }

    public Thread getThread() {
        return this._robotThread;
    }

    class PanelError
    extends AbstractPlugPanelInfo {
        PanelError() {
        }

        protected String getLabel() {
            return "Erreur(s) produites lors de la generation du script";
        }

        public String getInfo(String key) {
            if (key.equals("ppanel.title")) {
                return "Messages d'erreur ...";
            }
            return super.getInfo(key);
        }
    }

    class RobotThread
    extends Thread {
        RobotPlay _rPlay;
        Plugable _launcher;

        RobotThread(RobotPlay rPlay, Plugable launcher) {
            super((Runnable)rPlay, "Cecilia Robot");
            this._rPlay = rPlay;
            this._launcher = launcher;
        }

        @Override
        public void run() {
            super.run();
            if (this._rPlay.withError()) {
                PanelError panel = new PanelError();
                panel.append(this._rPlay.getErrorMsg());
                this._launcher.addPanel((PlugPanel)panel, -1L);
            } else {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._launcher.getWindow()), "Fin du scenario");
            }
        }
    }
}

