/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.migration.db60to60;

import com.dassault.cecilia.migration.db60to60.DBCopyInterface;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.logging.Level;

public class DBCopyDefault
implements DBCopyInterface {
    protected String getDeleteSQLCmd() {
        return "Delete from";
    }

    protected void deleteTable(Statement statement, String tableName) throws SQLException {
        try {
            statement.executeUpdate(this.getDeleteSQLCmd() + " " + tableName);
        }
        catch (SQLException e) {
            _LOG.severe("Exception during " + this.getDeleteSQLCmd() + " '" + tableName + "'");
            throw e;
        }
    }

    protected void dropTableIfExist(Statement statement, String tableName) throws SQLException {
        try {
            statement.executeUpdate("DROP TABLE IF EXISTS " + tableName);
        }
        catch (SQLException e) {
            _LOG.severe("Exception during DROP TABLE IF EXISTS '" + tableName + "'");
            throw e;
        }
    }

    @Override
    public void deleteTables(Connection dbTarget) throws SQLException {
        Statement statement = dbTarget.createStatement();
        _LOG.fine("Delete data started...");
        this.deleteTable(statement, "cec_egli");
        this.deleteTable(statement, "cec_relations");
        this.deleteTable(statement, "cec_accesses");
        this.deleteTable(statement, "cec_folders");
        this.deleteTable(statement, "cec_obj_properties");
        this.deleteTable(statement, "cec_obj_models");
        this.deleteTable(statement, "cec_objects");
        this.deleteTable(statement, "cec_preferencies");
        this.deleteTable(statement, "cec_sessions");
        this.deleteTable(statement, "cec_groups_users");
        this.deleteTable(statement, "cec_users");
        this.deleteTable(statement, "cec_groups");
        this.deleteTable(statement, "cec_db_properties");
        this.dropTableIfExist(statement, "cec_migration_parameters");
        this.dropTableIfExist(statement, "cec_migration_attributes");
        this.dropTableIfExist(statement, "cec_migration_ccfs");
        this.dropTableIfExist(statement, "cec_migration_refobjects");
        _LOG.info("Delete data completed...");
        statement.close();
    }

    @Override
    public void updateSequences(Connection dbTarget) throws SQLException {
        Statement statement = dbTarget.createStatement();
        _LOG.fine("Update sequences started...");
        statement.executeUpdate("ALTER TABLE cec_folders ALTER COLUMN fol_id RESTART WITH ((SELECT MAX(fol_id) FROM cec_folders) +1)");
        statement.executeUpdate("ALTER TABLE cec_obj_properties ALTER COLUMN opr_id RESTART WITH ((SELECT MAX(opr_id) FROM cec_obj_properties) +1)");
        statement.executeUpdate("ALTER TABLE cec_obj_models ALTER COLUMN mod_id RESTART WITH ((SELECT MAX(mod_id) FROM cec_obj_models) +1)");
        statement.executeUpdate("ALTER TABLE cec_objects ALTER COLUMN obj_id RESTART WITH ((SELECT MAX(obj_id) FROM cec_objects) +1)");
        statement.executeUpdate("ALTER TABLE cec_preferencies ALTER COLUMN upf_id RESTART WITH ((SELECT MAX(upf_id) FROM cec_preferencies) +1)");
        statement.executeUpdate("ALTER TABLE cec_users ALTER COLUMN usr_id RESTART WITH ((SELECT MAX(usr_id) FROM cec_users) +1)");
        statement.executeUpdate("ALTER TABLE cec_groups ALTER COLUMN grp_id RESTART WITH ((SELECT MAX(grp_id) FROM cec_groups) +1)");
        statement.executeUpdate("ALTER TABLE cec_sessions ALTER COLUMN ses_id RESTART WITH 1");
        _LOG.info("Update sequences completed...");
        statement.close();
    }

    protected void constraintsDisable(Connection dbTarget) throws SQLException {
    }

    protected void constraintsEnable(Connection dbTarget) throws SQLException {
    }

    @Override
    public void copyData(Connection dbSource, Connection dbTarget) throws SQLException {
        this.constraintsDisable(dbTarget);
        _LOG.info("Copy started....");
        _LOG.fine("Copy Groups...");
        this.copyGroups(dbSource, dbTarget);
        _LOG.info("Copy Groups completed...");
        _LOG.fine("Copy Users...");
        this.copyUsers(dbSource, dbTarget);
        _LOG.info("Copy Users completed...");
        _LOG.fine("Copy Preferencies...");
        this.copyPreferencies(dbSource, dbTarget);
        _LOG.info("Copy Preferencies completed...");
        _LOG.fine("Copy GroupsUsers...");
        this.copyGroupsUsers(dbSource, dbTarget);
        _LOG.info("Copy GroupsUsers completed...");
        _LOG.fine("Copy Objects...");
        this.copyObjects(dbSource, dbTarget);
        _LOG.info("Copy Objects completed...");
        _LOG.fine("Copy ObjProperties...");
        this.copyObjProperties(dbSource, dbTarget);
        _LOG.info("Copy ObjProperties completed...");
        _LOG.fine("Copy ObjModels...");
        this.copyObjModels(dbSource, dbTarget);
        _LOG.info("Copy ObjModels completed...");
        _LOG.fine("Copy Folders...");
        this.copyFolders(dbSource, dbTarget);
        _LOG.info("Copy Folders completed...");
        _LOG.fine("Copy Relations...");
        this.copyRelations(dbSource, dbTarget);
        _LOG.info("Copy Relations completed...");
        _LOG.fine("Copy Accesses...");
        this.copyAccesses(dbSource, dbTarget);
        _LOG.info("Copy Accesses completed...");
        _LOG.fine("Copy DbProperties...");
        this.copyDbProperties(dbSource, dbTarget);
        _LOG.info("Copy DbProperties completed...");
        if (this.verifyMigration(dbSource)) {
            _LOG.fine("Copy MigrationParameters...");
            this.createTableMigrationParameters(dbTarget);
            this.copyMigrationParameters(dbSource, dbTarget);
            _LOG.info("Copy MigrationParameters completed...");
            _LOG.fine("Copy MigrationAttributes...");
            this.createTableMigrationAttributes(dbTarget);
            this.copyMigrationAttributes(dbSource, dbTarget);
            _LOG.info("Copy MigrationAttributes completed...");
            _LOG.fine("Copy MigrationCCFs...");
            this.createTableMigrationCCFs(dbTarget);
            this.copyMigrationCCFs(dbSource, dbTarget);
            _LOG.info("Copy MigrationCCFs completed...");
            _LOG.fine("Copy MigrationRefObjects...");
            this.createTableMigrationRefObjects(dbTarget);
            this.copyMigrationRefObjects(dbSource, dbTarget);
            _LOG.info("Copy MigrationRefObjects completed...");
        }
        _LOG.info("Copy completed...");
        this.constraintsEnable(dbTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void traceInsertCount(Connection dbTarget, String tableName, int nbLigne) {
        try (Statement statement = dbTarget.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM " + tableName);){
            if (resultSet.next()) {
                _LOG.fine("Table '" + tableName + "': " + resultSet.getInt(1) + "/" + nbLigne);
            }
        }
        catch (Exception e) {
            _LOG.log(Level.WARNING, "Exception during count Table '" + tableName + "' : " + nbLigne, e);
        }
    }

    protected int getIDType() {
        return 4;
    }

    protected void prepareSetID(ResultSet resultSet, PreparedStatement prep_statement, int idxSrc, int idxTgt) throws SQLException {
        if (resultSet.getObject(idxSrc) != null) {
            prep_statement.setInt(idxTgt, resultSet.getInt(idxSrc));
        } else {
            prep_statement.setNull(idxTgt, 4);
        }
    }

    protected void prepareSetString(ResultSet resultSet, PreparedStatement prep_statement, int idxSrc, int idxTgt) throws SQLException {
        if (resultSet.getObject(idxSrc) != null) {
            prep_statement.setString(idxTgt, resultSet.getString(idxSrc));
        } else {
            prep_statement.setNull(idxTgt, 12);
        }
    }

    protected void prepareSetBlob(ResultSet resultSet, PreparedStatement prep_statement, int idxSrc, int idxTgt) throws SQLException {
        if (resultSet.getObject(idxSrc) != null) {
            prep_statement.setBytes(idxTgt, resultSet.getBytes(idxSrc));
        } else {
            prep_statement.setNull(idxTgt, 2004);
        }
    }

    protected void prepareSetTimestamp(ResultSet resultSet, PreparedStatement prep_statement, int idxSrc, int idxTgt) throws SQLException {
        if (resultSet.getObject(idxSrc) != null) {
            prep_statement.setTimestamp(idxTgt, resultSet.getTimestamp(idxSrc));
        } else {
            prep_statement.setNull(idxTgt, 93);
        }
    }

    protected void insertBegin(Connection dbTarget) throws SQLException {
    }

    protected void insertEnd(Connection dbTarget) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyGroups(Connection dbSource, Connection dbTarget) throws SQLException {
        int nbLigne = 0;
        Statement statement = dbSource.createStatement();
        PreparedStatement prep_statement = dbTarget.prepareStatement("INSERT INTO cec_groups (grp_id,grp_name,grp_description,grp_flags) VALUES (?,?,?,?)");
        try {
            this.insertBegin(dbTarget);
            try (ResultSet resultSet = statement.executeQuery("SELECT grp_id,grp_name,grp_description,grp_flags FROM cec_groups");){
                while (resultSet.next()) {
                    this.prepareSetID(resultSet, prep_statement, 1, 1);
                    this.prepareSetString(resultSet, prep_statement, 2, 2);
                    this.prepareSetString(resultSet, prep_statement, 3, 3);
                    prep_statement.setInt(4, resultSet.getInt(4));
                    try {
                        prep_statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        _LOG.info("Exception during insert line idx=" + nbLigne + " into 'cec_groups': name=" + resultSet.getString(2));
                        _LOG.severe(e.getMessage());
                        _LOG.log(Level.FINEST, "More informations", e);
                    }
                    ++nbLigne;
                }
            }
            this.insertEnd(dbTarget);
        }
        finally {
            statement.close();
            prep_statement.close();
        }
        this.traceInsertCount(dbTarget, "cec_groups", nbLigne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyUsers(Connection dbSource, Connection dbTarget) throws SQLException {
        int nbLigne = 0;
        Statement statement = dbSource.createStatement();
        PreparedStatement prep_statement = dbTarget.prepareStatement("INSERT INTO cec_users (usr_id,usr_name,usr_login,usr_password,usr_default_grp_id,usr_description,usr_flags) VALUES (?,?,?,?,?,?,?)");
        try {
            this.insertBegin(dbTarget);
            try (ResultSet resultSet = statement.executeQuery("SELECT usr_id,usr_name,usr_login,usr_password,usr_default_grp_id,usr_description,usr_flags FROM cec_users");){
                while (resultSet.next()) {
                    this.prepareSetID(resultSet, prep_statement, 1, 1);
                    this.prepareSetString(resultSet, prep_statement, 2, 2);
                    this.prepareSetString(resultSet, prep_statement, 3, 3);
                    this.prepareSetString(resultSet, prep_statement, 4, 4);
                    this.prepareSetID(resultSet, prep_statement, 5, 5);
                    this.prepareSetString(resultSet, prep_statement, 6, 6);
                    prep_statement.setInt(7, resultSet.getInt(7));
                    try {
                        prep_statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        _LOG.info("Exception during insert line idx=" + nbLigne + " into 'cec_users': login=" + resultSet.getString(3));
                        _LOG.severe(e.getMessage());
                        _LOG.log(Level.FINEST, "More informations", e);
                    }
                    ++nbLigne;
                }
            }
            this.insertEnd(dbTarget);
        }
        finally {
            statement.close();
            prep_statement.close();
        }
        this.traceInsertCount(dbTarget, "cec_users", nbLigne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyPreferencies(Connection dbSource, Connection dbTarget) throws SQLException {
        int nbLigne = 0;
        Statement statement = dbSource.createStatement();
        PreparedStatement prep_statement = dbTarget.prepareStatement("INSERT INTO cec_preferencies (upf_id,upf_usr_id,upf_key,upf_flags,upf_data,upf_data_size) VALUES (?,?,?,?,?,?)");
        try {
            this.insertBegin(dbTarget);
            try (ResultSet resultSet = statement.executeQuery("SELECT upf_id,upf_usr_id,upf_key,upf_flags,upf_data,upf_data_size FROM cec_preferencies");){
                while (resultSet.next()) {
                    this.prepareSetID(resultSet, prep_statement, 1, 1);
                    this.prepareSetID(resultSet, prep_statement, 2, 2);
                    this.prepareSetString(resultSet, prep_statement, 3, 3);
                    prep_statement.setInt(4, resultSet.getInt(4));
                    this.prepareSetBlob(resultSet, prep_statement, 5, 5);
                    prep_statement.setInt(6, resultSet.getInt(6));
                    try {
                        prep_statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        _LOG.info("Exception during insert line idx=" + nbLigne + " into 'cec_preferencies': name=" + resultSet.getString(2));
                        _LOG.severe(e.getMessage());
                        _LOG.log(Level.FINEST, "More informations", e);
                    }
                    ++nbLigne;
                }
            }
            this.insertEnd(dbTarget);
        }
        finally {
            statement.close();
            prep_statement.close();
        }
        this.traceInsertCount(dbTarget, "cec_preferencies", nbLigne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyGroupsUsers(Connection dbSource, Connection dbTarget) throws SQLException {
        int nbLigne = 0;
        Statement statement = dbSource.createStatement();
        PreparedStatement prep_statement = dbTarget.prepareStatement("INSERT INTO cec_groups_users (grp_grp_id,grp_usr_id) VALUES (?,?)");
        try {
            this.insertBegin(dbTarget);
            try (ResultSet resultSet = statement.executeQuery("SELECT grp_grp_id,grp_usr_id FROM cec_groups_users");){
                while (resultSet.next()) {
                    this.prepareSetID(resultSet, prep_statement, 1, 1);
                    this.prepareSetID(resultSet, prep_statement, 2, 2);
                    try {
                        prep_statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        _LOG.info("Exception during insert line idx=" + nbLigne + " into 'cec_groups_users'");
                        _LOG.severe(e.getMessage());
                        _LOG.log(Level.FINEST, "More informations", e);
                    }
                    ++nbLigne;
                }
            }
            this.insertEnd(dbTarget);
        }
        finally {
            statement.close();
            prep_statement.close();
        }
        this.traceInsertCount(dbTarget, "cec_groups_users", nbLigne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyObjects(Connection dbSource, Connection dbTarget) throws SQLException {
        int nbLigne = 0;
        Statement statement = dbSource.createStatement();
        PreparedStatement prep_statement = dbTarget.prepareStatement("INSERT INTO cec_objects (obj_id,obj_flags,obj_ses_id,obj_time_update) VALUES (?,?,?,?)");
        try {
            this.insertBegin(dbTarget);
            try (ResultSet resultSet = statement.executeQuery("SELECT obj_id,obj_flags,obj_ses_id,obj_time_update FROM cec_objects");){
                while (resultSet.next()) {
                    this.prepareSetID(resultSet, prep_statement, 1, 1);
                    prep_statement.setInt(2, resultSet.getInt(2));
                    prep_statement.setNull(3, this.getIDType());
                    this.prepareSetTimestamp(resultSet, prep_statement, 4, 4);
                    try {
                        prep_statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        _LOG.info("Exception during insert line idx=" + nbLigne + " into 'cec_objects': objID=" + resultSet.getInt(1));
                        _LOG.severe(e.getMessage());
                        _LOG.log(Level.FINEST, "More informations", e);
                    }
                    ++nbLigne;
                }
            }
            this.insertEnd(dbTarget);
        }
        finally {
            statement.close();
            prep_statement.close();
        }
        this.traceInsertCount(dbTarget, "cec_objects", nbLigne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyObjModels(Connection dbSource, Connection dbTarget) throws SQLException {
        int nbLigne = 0;
        Statement statement = dbSource.createStatement();
        PreparedStatement prep_statement = dbTarget.prepareStatement("INSERT INTO cec_obj_models (mod_id,mod_obj_id,mod_nature,mod_format,mod_encoding,mod_crc,mod_data,mod_data_size,mod_previous ) VALUES (?,?,?,?,?,?,?,?,?)");
        try {
            this.insertBegin(dbTarget);
            try (ResultSet resultSet = statement.executeQuery("SELECT mod_id,mod_obj_id,mod_nature,mod_format,mod_encoding,mod_crc,mod_data,mod_data_size,mod_previous FROM cec_obj_models");){
                while (resultSet.next()) {
                    this.prepareSetID(resultSet, prep_statement, 1, 1);
                    this.prepareSetID(resultSet, prep_statement, 2, 2);
                    this.prepareSetString(resultSet, prep_statement, 3, 3);
                    this.prepareSetString(resultSet, prep_statement, 4, 4);
                    this.prepareSetString(resultSet, prep_statement, 5, 5);
                    this.prepareSetString(resultSet, prep_statement, 6, 6);
                    this.prepareSetBlob(resultSet, prep_statement, 7, 7);
                    prep_statement.setInt(8, resultSet.getInt(8));
                    prep_statement.setInt(9, resultSet.getInt(9));
                    try {
                        prep_statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        _LOG.info("Exception during insert line idx=" + nbLigne + " into 'cec_obj_models': modID=" + resultSet.getInt(1));
                        _LOG.severe(e.getMessage());
                        _LOG.log(Level.FINEST, "More informations", e);
                    }
                    ++nbLigne;
                }
            }
            this.insertEnd(dbTarget);
        }
        finally {
            statement.close();
            prep_statement.close();
        }
        this.traceInsertCount(dbTarget, "cec_obj_models", nbLigne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyObjProperties(Connection dbSource, Connection dbTarget) throws SQLException {
        int nbLigne = 0;
        Statement statement = dbSource.createStatement();
        PreparedStatement prep_statement = dbTarget.prepareStatement("INSERT INTO cec_obj_properties (opr_id,opr_obj_id,opr_name,opr_value,opr_type) VALUES (?,?,?,?,?)");
        try {
            this.insertBegin(dbTarget);
            try (ResultSet resultSet = statement.executeQuery("SELECT opr_id,opr_obj_id,opr_name,opr_value,opr_type FROM cec_obj_properties");){
                while (resultSet.next()) {
                    this.prepareSetID(resultSet, prep_statement, 1, 1);
                    this.prepareSetID(resultSet, prep_statement, 2, 2);
                    this.prepareSetString(resultSet, prep_statement, 3, 3);
                    this.prepareSetString(resultSet, prep_statement, 4, 4);
                    this.prepareSetString(resultSet, prep_statement, 5, 5);
                    try {
                        prep_statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        _LOG.info("Exception during insert line idx=" + nbLigne + " into 'cec_obj_properties': oprID=" + resultSet.getInt(1) + ", oprName=" + resultSet.getString(3));
                        _LOG.severe(e.getMessage());
                        _LOG.log(Level.FINEST, "More informations", e);
                    }
                    ++nbLigne;
                }
            }
            this.insertEnd(dbTarget);
        }
        finally {
            statement.close();
            prep_statement.close();
        }
        this.traceInsertCount(dbTarget, "cec_obj_properties", nbLigne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFolders(Connection dbSource, Connection dbTarget) throws SQLException {
        int nbLigne = 0;
        Statement statement = dbSource.createStatement();
        PreparedStatement prep_statement = dbTarget.prepareStatement("INSERT INTO cec_folders (fol_id,fol_parent_id,fol_obj_id,fol_name,fol_description,fol_grp_id,fol_usr_id,fol_access_group,fol_access_other,fol_date_creation,fol_date_modification,fol_last_modifier_usr_id,fol_flags,fol_time_update) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            LinkedList<Integer> currentIDs = new LinkedList<Integer>();
            nbLigne = this.copyFolder_step(dbTarget, statement, prep_statement, nbLigne, " WHERE fol_parent_id IS NULL", currentIDs);
            while (!currentIDs.isEmpty()) {
                StringBuilder appendSQL = new StringBuilder(currentIDs.size() * 3 + 100);
                appendSQL.append(" WHERE fol_parent_id IN (");
                for (int i = 0; i < 1000 && !currentIDs.isEmpty(); ++i) {
                    if (i > 0) {
                        appendSQL.append(",");
                    }
                    appendSQL.append(currentIDs.removeFirst());
                }
                appendSQL.append(")");
                nbLigne = this.copyFolder_step(dbTarget, statement, prep_statement, nbLigne, appendSQL.toString(), currentIDs);
            }
        }
        finally {
            statement.close();
            prep_statement.close();
        }
        this.traceInsertCount(dbTarget, "cec_folders", nbLigne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyFolder_step(Connection dbTarget, Statement statement, PreparedStatement prep_statement, int nbLigne, String appendSQL, LinkedList<Integer> currentIDs) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery("SELECT fol_id,fol_parent_id,fol_obj_id,fol_name,fol_description,fol_grp_id,fol_usr_id,fol_access_group,fol_access_other,fol_date_creation,fol_date_modification,fol_last_modifier_usr_id,fol_flags,fol_time_update FROM cec_folders" + appendSQL);){
            while (resultSet.next()) {
                _LOG.finest("cec_folder(fol_id=" + resultSet.getInt(1) + ",fol_parent_id=" + resultSet.getInt(2) + ",fol_name=" + resultSet.getString(4));
                this.prepareSetID(resultSet, prep_statement, 1, 1);
                this.prepareSetID(resultSet, prep_statement, 2, 2);
                this.prepareSetID(resultSet, prep_statement, 3, 3);
                this.prepareSetString(resultSet, prep_statement, 4, 4);
                this.prepareSetString(resultSet, prep_statement, 5, 5);
                this.prepareSetID(resultSet, prep_statement, 6, 6);
                this.prepareSetID(resultSet, prep_statement, 7, 7);
                prep_statement.setShort(8, resultSet.getShort(8));
                prep_statement.setShort(9, resultSet.getShort(9));
                this.prepareSetTimestamp(resultSet, prep_statement, 10, 10);
                this.prepareSetTimestamp(resultSet, prep_statement, 11, 11);
                this.prepareSetID(resultSet, prep_statement, 12, 12);
                prep_statement.setInt(13, resultSet.getInt(13));
                this.prepareSetTimestamp(resultSet, prep_statement, 14, 14);
                try {
                    prep_statement.executeUpdate();
                    currentIDs.addLast(resultSet.getInt(1));
                }
                catch (SQLException e) {
                    _LOG.info("Exception during insert line idx=" + nbLigne + " into 'cec_folders': folID=" + resultSet.getInt(1) + ", folName=" + resultSet.getString(4));
                    _LOG.severe(e.getMessage());
                    _LOG.log(Level.FINEST, "More informations", e);
                }
                ++nbLigne;
            }
        }
        _LOG.fine("Copy Folders ... " + nbLigne);
        return nbLigne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyRelations(Connection dbSource, Connection dbTarget) throws SQLException {
        int nbLigne = 0;
        Statement statement = dbSource.createStatement();
        PreparedStatement prep_statement = dbTarget.prepareStatement("INSERT INTO cec_relations (rel_src_id,rel_dst_id,rel_src_type,rel_dst_type) VALUES (?,?,?,?)");
        try {
            this.insertBegin(dbTarget);
            try (ResultSet resultSet = statement.executeQuery("SELECT rel_src_id,rel_dst_id,rel_src_type,rel_dst_type FROM cec_relations");){
                while (resultSet.next()) {
                    this.prepareSetID(resultSet, prep_statement, 1, 1);
                    this.prepareSetID(resultSet, prep_statement, 2, 2);
                    this.prepareSetString(resultSet, prep_statement, 3, 3);
                    this.prepareSetString(resultSet, prep_statement, 4, 4);
                    try {
                        prep_statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        _LOG.info("Exception during insert line idx=" + nbLigne + " into 'cec_relations'");
                        _LOG.severe(e.getMessage());
                        _LOG.log(Level.FINEST, "More informations", e);
                    }
                    ++nbLigne;
                }
            }
            this.insertEnd(dbTarget);
        }
        finally {
            statement.close();
            prep_statement.close();
        }
        this.traceInsertCount(dbTarget, "cec_relations", nbLigne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyAccesses(Connection dbSource, Connection dbTarget) throws SQLException {
        int nbLigne = 0;
        Statement statement = dbSource.createStatement();
        PreparedStatement prep_statement = dbTarget.prepareStatement("INSERT INTO cec_accesses (acc_fol_id,acc_grp_id,acc_rights) VALUES (?,?,?)");
        try {
            this.insertBegin(dbTarget);
            try (ResultSet resultSet = statement.executeQuery("SELECT acc_fol_id,acc_grp_id,acc_rights FROM cec_accesses");){
                while (resultSet.next()) {
                    this.prepareSetID(resultSet, prep_statement, 1, 1);
                    this.prepareSetID(resultSet, prep_statement, 2, 2);
                    prep_statement.setShort(3, resultSet.getShort(3));
                    try {
                        prep_statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        _LOG.info("Exception during insert line idx=" + nbLigne + " into 'cec_accesses'");
                        _LOG.severe(e.getMessage());
                        _LOG.log(Level.FINEST, "More informations", e);
                    }
                    ++nbLigne;
                }
            }
            this.insertEnd(dbTarget);
        }
        finally {
            statement.close();
            prep_statement.close();
        }
        this.traceInsertCount(dbTarget, "cec_accesses", nbLigne);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDbProperties(Connection dbSource, Connection dbTarget) throws SQLException {
        int nbLigne = 0;
        Statement statement = dbSource.createStatement();
        PreparedStatement prep_statement = dbTarget.prepareStatement("INSERT INTO cec_db_properties (dbp_name,dbp_value,dbp_description) VALUES (?,?,?)");
        try {
            this.insertBegin(dbTarget);
            try (ResultSet resultSet = statement.executeQuery("SELECT dbp_name,dbp_value,dbp_description FROM cec_db_properties");){
                while (resultSet.next()) {
                    this.prepareSetString(resultSet, prep_statement, 1, 1);
                    this.prepareSetString(resultSet, prep_statement, 2, 2);
                    this.prepareSetString(resultSet, prep_statement, 3, 3);
                    try {
                        prep_statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        _LOG.info("Exception during insert line idx=" + nbLigne + " into 'cec_db_properties': name=" + resultSet.getString(1));
                        _LOG.severe(e.getMessage());
                        _LOG.log(Level.FINEST, "More informations", e);
                    }
                    ++nbLigne;
                }
            }
            this.insertEnd(dbTarget);
        }
        finally {
            statement.close();
            prep_statement.close();
        }
        this.traceInsertCount(dbTarget, "cec_db_properties", nbLigne);
    }

    protected boolean verifyMigration(Connection dbSource) {
        int cpt = 0;
        try {
            Statement statement = dbSource.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM cec_migration_parameters");
            resultSet.next();
            cpt += resultSet.getInt(1);
            resultSet.close();
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM cec_migration_attributes");
            resultSet.next();
            cpt += resultSet.getInt(1);
            resultSet.close();
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM cec_migration_ccfs");
            resultSet.next();
            cpt += resultSet.getInt(1);
            resultSet.close();
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM cec_migration_refobjects");
            resultSet.next();
            resultSet.close();
            return (cpt += resultSet.getInt(1)) > 0;
        }
        catch (SQLException e) {
            _LOG.info("No migration informations");
            return false;
        }
    }

    protected void createTableMigrationParameters(Connection dbTarget) throws SQLException {
        Statement statement = dbTarget.createStatement();
        String sqlCmd = "CREATE TABLE cec_migration_parameters (  lpa_id INTEGER not null,   lpa_fol_id INTEGER not null  )";
        try {
            statement.executeUpdate(sqlCmd);
        }
        catch (SQLException e) {
            _LOG.severe("Exception during CREATE TABLE 'cec_migration_parameters'");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyMigrationParameters(Connection dbSource, Connection dbTarget) throws SQLException {
        int nbLigne = 0;
        Statement statement = dbSource.createStatement();
        PreparedStatement prep_statement = dbTarget.prepareStatement("INSERT INTO cec_migration_parameters (lpa_id,lpa_fol_id) VALUES (?,?)");
        try {
            this.insertBegin(dbTarget);
            try (ResultSet resultSet = statement.executeQuery("SELECT lpa_id,lpa_fol_id FROM cec_migration_parameters");){
                while (resultSet.next()) {
                    this.prepareSetID(resultSet, prep_statement, 1, 1);
                    this.prepareSetID(resultSet, prep_statement, 2, 2);
                    try {
                        prep_statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        _LOG.info("Exception during insert line idx=" + nbLigne + " into 'cec_migration_parameters': lpa_id=" + resultSet.getInt(1));
                        _LOG.severe(e.getMessage());
                        _LOG.log(Level.FINEST, "More informations", e);
                    }
                    ++nbLigne;
                }
            }
            this.insertEnd(dbTarget);
        }
        finally {
            statement.close();
            prep_statement.close();
        }
        this.traceInsertCount(dbTarget, "cec_migration_parameters", nbLigne);
    }

    protected void createTableMigrationAttributes(Connection dbTarget) throws SQLException {
        Statement statement = dbTarget.createStatement();
        String sqlCmd = "CREATE TABLE cec_migration_attributes (  att_id INTEGER not null,   att_fol_id INTEGER not null  )";
        try {
            statement.executeUpdate(sqlCmd);
        }
        catch (SQLException e) {
            _LOG.severe("Exception during CREATE TABLE 'cec_migration_attributes'");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyMigrationAttributes(Connection dbSource, Connection dbTarget) throws SQLException {
        int nbLigne = 0;
        Statement statement = dbSource.createStatement();
        PreparedStatement prep_statement = dbTarget.prepareStatement("INSERT INTO cec_migration_attributes (att_id,att_fol_id) VALUES (?,?)");
        try {
            this.insertBegin(dbTarget);
            try (ResultSet resultSet = statement.executeQuery("SELECT att_id,att_fol_id FROM cec_migration_attributes");){
                while (resultSet.next()) {
                    this.prepareSetID(resultSet, prep_statement, 1, 1);
                    this.prepareSetID(resultSet, prep_statement, 2, 2);
                    try {
                        prep_statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        _LOG.info("Exception during insert line idx=" + nbLigne + " into 'cec_migration_attributes': att_id=" + resultSet.getInt(1));
                        _LOG.severe(e.getMessage());
                        _LOG.log(Level.FINEST, "More informations", e);
                    }
                    ++nbLigne;
                }
            }
            this.insertEnd(dbTarget);
        }
        finally {
            statement.close();
            prep_statement.close();
        }
        this.traceInsertCount(dbTarget, "cec_migration_attributes", nbLigne);
    }

    protected void createTableMigrationCCFs(Connection dbTarget) throws SQLException {
        Statement statement = dbTarget.createStatement();
        String sqlCmd = "CREATE TABLE cec_migration_ccfs (  ccf_id INTEGER not null,   ccf_fol_id INTEGER not null  )";
        try {
            statement.executeUpdate(sqlCmd);
        }
        catch (SQLException e) {
            _LOG.severe("Exception during CREATE TABLE 'cec_migration_ccfs'");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyMigrationCCFs(Connection dbSource, Connection dbTarget) throws SQLException {
        int nbLigne = 0;
        Statement statement = dbSource.createStatement();
        PreparedStatement prep_statement = dbTarget.prepareStatement("INSERT INTO cec_migration_ccfs (ccf_id,ccf_fol_id) VALUES (?,?)");
        try {
            this.insertBegin(dbTarget);
            try (ResultSet resultSet = statement.executeQuery("SELECT ccf_id,ccf_fol_id FROM cec_migration_ccfs");){
                while (resultSet.next()) {
                    this.prepareSetID(resultSet, prep_statement, 1, 1);
                    this.prepareSetID(resultSet, prep_statement, 2, 2);
                    try {
                        prep_statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        _LOG.info("Exception during insert line idx=" + nbLigne + " into 'cec_migration_ccfs': ccf_id=" + resultSet.getInt(1));
                        _LOG.severe(e.getMessage());
                        _LOG.log(Level.FINEST, "More informations", e);
                    }
                    ++nbLigne;
                }
            }
            this.insertEnd(dbTarget);
        }
        finally {
            statement.close();
            prep_statement.close();
        }
        this.traceInsertCount(dbTarget, "cec_migration_ccfs", nbLigne);
    }

    protected void createTableMigrationRefObjects(Connection dbTarget) throws SQLException {
        Statement statement = dbTarget.createStatement();
        String sqlCmd = "CREATE TABLE cec_migration_refobjects (  obj_old_id INTEGER not null,   fol_id INTEGER not null  )";
        try {
            statement.executeUpdate(sqlCmd);
        }
        catch (SQLException e) {
            _LOG.severe("Exception during CREATE TABLE 'cec_migration_refobjects'");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyMigrationRefObjects(Connection dbSource, Connection dbTarget) throws SQLException {
        int nbLigne = 0;
        Statement statement = dbSource.createStatement();
        PreparedStatement prep_statement = dbTarget.prepareStatement("INSERT INTO cec_migration_refobjects (obj_old_id,fol_id) VALUES (?,?)");
        try {
            this.insertBegin(dbTarget);
            try (ResultSet resultSet = statement.executeQuery("SELECT obj_old_id,fol_id FROM cec_migration_refobjects");){
                while (resultSet.next()) {
                    this.prepareSetID(resultSet, prep_statement, 1, 1);
                    this.prepareSetID(resultSet, prep_statement, 2, 2);
                    try {
                        prep_statement.executeUpdate();
                    }
                    catch (SQLException e) {
                        _LOG.info("Exception during insert line idx=" + nbLigne + " into 'cec_migration_refobjects': obj_old_id=" + resultSet.getInt(1));
                        _LOG.severe(e.getMessage());
                        _LOG.log(Level.FINEST, "More informations", e);
                    }
                    ++nbLigne;
                }
            }
            this.insertEnd(dbTarget);
        }
        finally {
            statement.close();
            prep_statement.close();
        }
        this.traceInsertCount(dbTarget, "cec_migration_refobjects", nbLigne);
    }
}

