/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class RAMFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private Map<String, RAMPackage> _mapPackage;
    ClassLoader _classLoader = new ClassLoader(){

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            try {
                return super.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                JavaClassObject jc;
                RAMPackage pack = (RAMPackage)RAMFileManager.this._mapPackage.get(RAMPackage.getPackage(name));
                if (pack != null && (jc = (JavaClassObject)pack.get(RAMPackage.getSimplePackage(name))) != null) {
                    byte[] classData = jc._bytecode;
                    return this.defineClass(name, classData, 0, classData.length);
                }
                throw new ClassNotFoundException();
            }
        }
    };

    public Iterable<String> listPackage() {
        return this._mapPackage.keySet();
    }

    public RAMFileManager(JavaFileManager fileMgr) {
        super(fileMgr);
        this._mapPackage = new HashMap<String, RAMPackage>();
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this._classLoader;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject originatingSource) throws UnsupportedOperationException {
        if (originatingSource instanceof JavaSourceObject) {
            return new JavaClassObject(name);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof JavaClassObject) {
            return file.getName();
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public Iterable list(JavaFileManager.Location location, String packageName, Set kinds, boolean recurse) throws IOException {
        RAMPackage pack;
        if ("CLASS_PATH".equals(location.getName()) && kinds.contains((Object)JavaFileObject.Kind.CLASS) && (pack = this._mapPackage.get(packageName)) != null) {
            return pack.values();
        }
        return super.list(location, packageName, kinds, recurse);
    }

    @Override
    public void close() throws IOException {
        for (RAMPackage pack : this._mapPackage.values()) {
            pack.clear();
        }
        this._mapPackage.clear();
        super.close();
    }

    public static JavaFileObject makeSource(String name, String code) {
        return new JavaSourceObject(name, code);
    }

    protected static URI String2URI(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class JavaSourceObject
    extends SimpleJavaFileObject {
        final String _txtcode;

        JavaSourceObject(String name, String code) {
            super(RAMFileManager.String2URI("ramfm:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this._txtcode = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this._txtcode;
        }
    }

    public class JavaClassObject
    extends SimpleJavaFileObject {
        private String _name;
        byte[] _bytecode;

        JavaClassObject(String name) {
            super(RAMFileManager.String2URI("ramfm:///" + name.replace('.', '/') + JavaFileObject.Kind.CLASS.extension), JavaFileObject.Kind.CLASS);
            this._name = name;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this._bytecode != null) {
                return new ByteArrayInputStream(this._bytecode);
            }
            return super.openInputStream();
        }

        @Override
        public OutputStream openOutputStream() {
            return new FilterOutputStream(new ByteArrayOutputStream()){

                @Override
                public void close() throws IOException {
                    this.out.close();
                    ByteArrayOutputStream bos = (ByteArrayOutputStream)this.out;
                    JavaClassObject.this._bytecode = bos.toByteArray();
                    String packName = RAMPackage.getPackage(JavaClassObject.this._name);
                    RAMPackage pack = (RAMPackage)RAMFileManager.this._mapPackage.get(packName);
                    if (pack == null) {
                        pack = new RAMPackage();
                        RAMFileManager.this._mapPackage.put(packName, pack);
                    }
                    pack.put(RAMPackage.getSimplePackage(JavaClassObject.this._name), JavaClassObject.this);
                }
            };
        }
    }

    static class RAMPackage
    extends HashMap<String, JavaClassObject> {
        RAMPackage() {
        }

        static String getPackage(String fullName) {
            int idx = fullName.lastIndexOf(46);
            if (idx <= 0) {
                return "";
            }
            return fullName.substring(0, idx);
        }

        static String getSimplePackage(String fullName) {
            int idx = fullName.lastIndexOf(46);
            if (idx < 0 || idx >= fullName.length()) {
                return fullName;
            }
            return fullName.substring(idx + 1);
        }
    }
}

