/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.io;

import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CRCWriter
extends Writer {
    MessageDigest _digest;
    boolean _update = true;
    CharsetEncoder _encoder;
    Writer _delegate;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    String _CRC = null;
    String _mac = null;

    public CRCWriter(Writer out) throws NoSuchAlgorithmException {
        this._delegate = out;
        this._digest = MessageDigest.getInstance("MD5");
        this._encoder = StandardCharsets.UTF_8.newEncoder();
    }

    public void setUpdate(boolean update) {
        this._update = update;
    }

    @Override
    public void write(int c) throws IOException {
        if (this._update) {
            char[] buffer = new char[]{(char)c};
            this._digest.update(this._encoder.encode(CharBuffer.wrap(buffer)));
        }
        this._delegate.write(c);
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (this._update) {
            this._digest.update(this._encoder.encode(CharBuffer.wrap(str, off, len)));
        }
        this._delegate.write(str, off, len);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this._update) {
            this._digest.update(this._encoder.encode(CharBuffer.wrap(cbuf, off, len)));
        }
        this._delegate.write(cbuf, off, len);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        if (csq != null) {
            this.write(csq.toString(), 0, csq.length());
        }
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        if (csq != null) {
            this.write(csq.subSequence(start, end).toString());
        }
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.write(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
        this._delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this._delegate.close();
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public String getCRC() {
        if (this._CRC == null) {
            byte[] bits = this._digest.digest();
            this._CRC = CRCWriter.bytesToHex(bits);
        }
        return this._CRC;
    }

    public String getMAC() {
        if (this._CRC == null) {
            byte[] bits = this._digest.digest();
            StringBuffer hex = new StringBuffer(bits.length * 2);
            for (int i = 0; i < bits.length && i < 12; ++i) {
                if (i == 6) {
                    hex.append(";");
                } else if (i > 0) {
                    hex.append("-");
                }
                if ((bits[i] & 0xFF) < 16) {
                    hex.append("0");
                }
                hex.append(Integer.toString(bits[i] & 0xFF, 16).toUpperCase());
            }
            this._mac = hex.toString();
        }
        return this._mac;
    }
}

