/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.loader;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class JarResources {
    private static final boolean __debugOn = false;
    private String _jarFileName = null;
    private Manifest _manifest = null;
    private Map<String, Integer> _htSizes = new HashMap<String, Integer>();
    private Map<String, byte[]> _htJarContents = new HashMap<String, byte[]>();

    public JarResources(String jarFileName) {
        this._jarFileName = jarFileName;
        try {
            ZipFile zf = new ZipFile(this._jarFileName);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                this._htSizes.put(ze.getName(), (int)ze.getSize());
            }
            zf.close();
            FileInputStream fis = new FileInputStream(this._jarFileName);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            this.init(zis);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public JarResources(InputStream stream) {
        this._jarFileName = null;
        ZipInputStream zis = new ZipInputStream(stream);
        this.init(zis);
    }

    private void init(ZipInputStream zis) {
        try {
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.isDirectory()) continue;
                int size = (int)ze.getSize();
                if (size == -1) {
                    size = this._htSizes.get(ze.getName());
                }
                byte[] b = new byte[size];
                int rb = 0;
                int chunk = 0;
                while (size - rb > 0 && (chunk = zis.read(b, rb, size - rb)) != -1) {
                    rb += chunk;
                }
                this._htJarContents.put(ze.getName(), b);
                if (this._manifest != null || !"META-INF/MANIFEST.MF".equals(ze.getName())) continue;
                this._manifest = new Manifest(new ByteArrayInputStream(b));
            }
            zis.close();
        }
        catch (NullPointerException e) {
            System.out.println("done.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String dumpZipEntry(ZipEntry ze) {
        StringBuffer sb = new StringBuffer();
        if (ze.isDirectory()) {
            sb.append("d ");
        } else {
            sb.append("f ");
        }
        if (ze.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("defalted ");
        }
        sb.append(ze.getName());
        sb.append("\t");
        sb.append("" + ze.getSize());
        if (ze.getMethod() == 8) {
            sb.append("/" + ze.getCompressedSize());
        }
        return sb.toString();
    }

    public URL getURLAccess(String name) {
        if (this._jarFileName != null) {
            try {
                File file = new File(this._jarFileName);
                String url = file.toURI().toURL().toString();
                return new URL("jar:" + url + "!/" + name);
            }
            catch (Exception exception) {}
        } else {
            try {
                return new URL("http://127.0.0.1/" + name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Manifest getManifest() {
        return this._manifest;
    }

    public byte[] getResource(String name) {
        return this._htJarContents.get(name);
    }
}

