/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.logging;

import java.io.UnsupportedEncodingException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class DualConsoleHandler
extends StreamHandler {
    private final ConsoleHandler _stderrHandler = new ConsoleHandler();
    private int _middleValue;

    public DualConsoleHandler() {
        super(System.out, new SimpleFormatter());
        this.configure();
    }

    private void configure() {
        Class<?> clz2;
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        this._middleValue = Level.INFO.intValue();
        String prop = manager.getProperty(cname + ".middle");
        if (prop != null) {
            try {
                Level middleLevel = Level.parse(prop);
                this._middleValue = middleLevel.intValue();
            }
            catch (IllegalArgumentException middleLevel) {
                // empty catch block
            }
        }
        if ((prop = manager.getProperty(cname + ".level")) != null) {
            try {
                Level level = Level.parse(prop);
                this.setLevel(level);
            }
            catch (IllegalArgumentException level) {
                // empty catch block
            }
        }
        if ((prop = manager.getProperty(cname + ".filter")) != null) {
            try {
                clz2 = ClassLoader.getSystemClassLoader().loadClass(prop);
                this.setFilter((Filter)clz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception clz2) {
                // empty catch block
            }
        }
        if ((prop = manager.getProperty(cname + ".formatter")) != null) {
            try {
                clz2 = ClassLoader.getSystemClassLoader().loadClass(prop);
                this.setFormatter((Formatter)clz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception clz3) {
                // empty catch block
            }
        }
        if ((prop = manager.getProperty(cname + ".encoding")) != null) {
            try {
                this.setEncoding(prop);
            }
            catch (Exception e1) {
                try {
                    this.setEncoding(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public synchronized void setLevel(Level newLevel) throws SecurityException {
        super.setLevel(newLevel);
        if (this._stderrHandler != null) {
            this._stderrHandler.setLevel(newLevel);
        }
    }

    @Override
    public synchronized void setFilter(Filter newFilter) throws SecurityException {
        super.setFilter(newFilter);
        if (this._stderrHandler != null) {
            this._stderrHandler.setFilter(newFilter);
        }
    }

    @Override
    public synchronized void setFormatter(Formatter newFormatter) throws SecurityException {
        super.setFormatter(newFormatter);
        if (this._stderrHandler != null) {
            this._stderrHandler.setFormatter(newFormatter);
        }
    }

    @Override
    public synchronized void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(encoding);
        if (this._stderrHandler != null) {
            this._stderrHandler.setEncoding(encoding);
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (record.getLevel().intValue() <= this._middleValue) {
            super.publish(record);
            super.flush();
        } else {
            this._stderrHandler.publish(record);
            this._stderrHandler.flush();
        }
    }
}

