/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mcs;

import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.plugin.mcs.ResMCS;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MCS2DagOptionsPanel
extends JPanel {
    int _size;
    char _sep;
    JComboBox _ctrlSize;
    JComboBox _ctrlSep;
    protected static final String GOOD_CARSET = "._-abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public void setGroupSize(int value) {
        this._size = value;
        this._ctrlSize.setSelectedItem(value);
    }

    public int getGroupSize() {
        return this._size;
    }

    public void setSeparator(char value) {
        this._sep = value;
        this._ctrlSep.setSelectedItem(Character.valueOf(value));
    }

    public char getSeparator() {
        return this._sep;
    }

    public MCS2DagOptionsPanel() {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(ResMCS.getString("DLG_MCS2DAG_OPTIONS")));
        int oLine = 0;
        this.add((Component)new JLabel(ResMCS.getString("DLG_MCS2DAG_OPT_SIZE")), new GridBagConstraints(0, oLine, 1, 1, 100.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this._ctrlSize = new JComboBox();
        this._ctrlSize.addItem(10);
        this._ctrlSize.addItem(100);
        this._ctrlSize.addItem(1000);
        this._ctrlSize.setEditable(true);
        this._ctrlSize.setLightWeightPopupEnabled(false);
        this.add((Component)this._ctrlSize, new GridBagConstraints(1, oLine++, 3, 1, 100.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel(ResMCS.getString("DLG_MCS2DAG_OPT_SEP")), new GridBagConstraints(0, oLine, 1, 1, 100.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this._ctrlSep = new JComboBox();
        this._ctrlSep.addItem(Character.valueOf('.'));
        this._ctrlSep.addItem(Character.valueOf('_'));
        this._ctrlSep.addItem(Character.valueOf('-'));
        this._ctrlSep.setEditable(true);
        this._ctrlSep.setLightWeightPopupEnabled(false);
        this.add((Component)this._ctrlSep, new GridBagConstraints(0, oLine++, 4, 1, 100.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    public boolean verify() {
        Object sel = this._ctrlSize.getSelectedItem();
        if (sel instanceof Integer) {
            this._size = (Integer)sel;
        } else if (sel instanceof Number) {
            this._size = ((Number)sel).intValue();
        } else if (sel instanceof String) {
            String strSize = (String)sel;
            try {
                this._size = Integer.parseInt(strSize);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._ctrlSize), ResMCS.getString("DLG_MCS2DAG_SIZE_ERROR"), ResMCS.getString("PLUG_CMD_MCS2DAG_NAME"), 0);
                this._ctrlSize.requestFocus();
                return false;
            }
        } else {
            ResMCS.LOG.severe("CtrlSize (JComboBox) has selectedItem unknown !");
        }
        Object sep = this._ctrlSep.getSelectedItem();
        if (sep instanceof Character) {
            this._sep = ((Character)sep).charValue();
        } else if (sep instanceof String) {
            String strSep = sep.toString();
            if (strSep.length() != 1 || GOOD_CARSET.indexOf(strSep.charAt(0)) == -1) {
                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf((Component)this._ctrlSize), ResMCS.getString("DLG_MCS2DAG_SEP_ERROR"), ResMCS.getString("PLUG_CMD_MCS2DAG_NAME"), 0);
                this._ctrlSize.requestFocus();
                return false;
            }
            this._sep = strSep.charAt(0);
        } else {
            ResMCS.LOG.severe("CtrlSep (JComboBox) has selectedItem unknown !");
        }
        return true;
    }
}

