/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.plugin.mcs;

import com.dassault.cecilia.core.plugin.AbstractPlugPanelInfo;
import com.dassault.cecilia.core.plugin.AbstractPluginModel;
import com.dassault.cecilia.core.plugin.IModel;
import com.dassault.cecilia.core.plugin.PlugPanel;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.plugin.PlugableUtility;
import com.dassault.cecilia.core.plugin.PluginMAction;
import com.dassault.cecilia.core.swing.JDialogCecilia;
import com.dassault.cecilia.lib.util.ResIcoAbstract;
import com.dassault.cecilia.lib.util.io.LimitedWriter;
import com.dassault.cecilia.plugin.mcs.ResMCS;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PluginCmdAralia
extends AbstractPluginModel
implements PluginMAction {
    public static final String OPT_EXEC = PluginCmdAralia.class.getName() + "#Execute";
    public static final String OPT_SCRIPT = PluginCmdAralia.class.getName() + "#Script";
    public static final String OPT_SCRIPT_DEFAULT = "echo \"Definition des variables sommets : \n\" ;\ndisplay definition roots(*);\necho \"\n------------------------------------\nCalculs :\n\" ;\ncompute BDD roots(*);\ncompute ZQC roots(*);\ndisplay orders ZQC roots(*);\ndisplay products ZQC roots(*);\n";
    AraliaOptsPanel _opts = null;

    PluginCmdAralia() {
    }

    public String getInfo(String key) {
        if (key.equals("plugin.name")) {
            return ResMCS.getString("PLUG_CMD_ARALIA_NAME");
        }
        if (key.equals("plugin.description") || key.equals("plugin.tooltip")) {
            return ResMCS.getString("PLUG_CMD_ARALIA_DESC");
        }
        if (key.equals("type")) {
            return "PluginAction";
        }
        return super.getInfo(key);
    }

    public Icon getIcon(String key) {
        if (key.equals("plugin.default")) {
            return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("B-02.svg"));
        }
        return super.getIcon(key);
    }

    public boolean withOption(Plugable plugable) {
        return true;
    }

    public PlugPanel displayOption(Plugable launcher) {
        if (this._opts == null) {
            this._opts = new AraliaOptsPanel();
        }
        this._opts.prepareWith(launcher);
        return this._opts;
    }

    public void refreshOptions(Plugable launcher) {
        if (this._opts != null) {
            this._opts.prepareWith(launcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSession(Plugable launcher, Object parameters) {
        IModel model = launcher.getModel("aralia.file");
        if (model == null) {
            return;
        }
        DlgCmdAralia dlg = new DlgCmdAralia(launcher.getWindow());
        dlg.create();
        dlg._cmdsCtrl.setText(PlugableUtility.getStrOpt((Plugable)launcher, (String)OPT_SCRIPT, (String)OPT_SCRIPT_DEFAULT));
        dlg.setVisible(true);
        if (!dlg.getResult()) {
            return;
        }
        String cmds = dlg._cmdsCtrl.getText();
        if (cmds.length() == 0) {
            return;
        }
        launcher.setOption(OPT_SCRIPT, cmds);
        String pathDag = model.getFile().getAbsolutePath();
        StringBuffer script = new StringBuffer(cmds.length() * 3 / 2);
        script.append("load \"");
        script.append(pathDag);
        script.append("\";\n");
        script.append(cmds);
        script.append("\nexit;\n");
        String exec = PlugableUtility.getStrOpt((Plugable)launcher, (String)OPT_EXEC, (String)"aralia");
        StringWriter out = new StringWriter(1024);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter((Writer)new LimitedWriter((Writer)out, 4096), true);
            Process process = Runtime.getRuntime().exec(exec);
            new CopyStream().setIn(process.getInputStream()).setOut(writer).start();
            new CopyStream().setIn(process.getErrorStream()).setOut(writer).start();
            new CopyStream().setIn(new StringReader(script.toString())).setOut(process.getOutputStream()).start();
            Thread.sleep(100L);
            process.waitFor();
            writer.print("\n");
            writer.println(ResMCS.getString("CMD_ARALIA_PRV_END"));
            writer.println("\n");
        }
        catch (Exception e) {
            String display = ResMCS.msgFormat("CMD_ARALIA_PRV_STOP", e.toString());
            writer.print(display);
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        AbstractPlugPanelInfo panel = new AbstractPlugPanelInfo(){

            protected String getLabel() {
                return ResMCS.getString("CMD_ARALIA_PRV_RESULT");
            }

            public Icon getIcon(String key) {
                if (key.equals("ppanel.icon")) {
                    return ResIcoAbstract.getIconRes((URL)((Object)((Object)this)).getClass().getResource("B-02.svg"));
                }
                return super.getIcon(key);
            }

            public String getInfo(String key) {
                if (key.equals("ppanel.title")) {
                    return ResMCS.getString("PLUG_CMD_ARALIA_NAME");
                }
                if (key.equals("ppanel.default.width")) {
                    return "600";
                }
                if (key.equals("ppanel.default.height")) {
                    return "480";
                }
                return super.getInfo(key);
            }
        };
        String res = out.toString();
        panel.append(res);
        if (res.length() >= 4096) {
            panel.append("\n\t...\n\nLimited at 4096 octets\n");
        }
        launcher.addPanel((PlugPanel)panel, model.getUID());
    }

    public class CopyStream
    extends Thread {
        BufferedReader _inTxt;
        PrintWriter _outTxt;

        public CopyStream setIn(InputStream in) {
            this._inTxt = new BufferedReader(new InputStreamReader(in));
            return this;
        }

        public CopyStream setIn(Reader in) {
            this._inTxt = new BufferedReader(in);
            return this;
        }

        public CopyStream setOut(OutputStream out) {
            this._outTxt = new PrintWriter((Writer)new OutputStreamWriter(out), true);
            return this;
        }

        public CopyStream setOut(PrintWriter out) {
            this._outTxt = out;
            return this;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this._inTxt.readLine()) != null) {
                    this._outTxt.println(line);
                }
                this._inTxt.close();
            }
            catch (IOException e) {
                ResMCS.LOG.log(Level.SEVERE, "IOException in CopyStream:Run", e);
            }
        }
    }

    class DlgCmdAralia
    extends JDialogCecilia {
        protected JTextArea _cmdsCtrl;

        public DlgCmdAralia(Window win) {
            super(win, true);
        }

        public void create() {
            this.init();
            this._cmdsCtrl = new JTextArea(20, 80);
            this._cmdsCtrl.setFont(new Font("Monospaced", 0, 12));
            this.getContentPane().add((Component)new JLabel(ResMCS.getString("DLG_ARALIA_PRV_LBL")), "North");
            this.getContentPane().add((Component)new JScrollPane(this._cmdsCtrl), "Center");
            this.getContentPane().add((Component)this.createButPanel(), "South");
            this.setTitle(ResMCS.getString("DLG_ARALIA_PRV_TITLE"));
            this.pack();
            Dimension size = this.getSize();
            this.setSize(size);
            Dimension pSize = this.getParent().getSize();
            Point pLocal = this.getParent().getLocation();
            this.setLocation(pLocal.x + (pSize.width - size.width) / 2, pLocal.y + (pSize.height - size.height) / 2);
        }
    }

    class AraliaOptsPanel
    extends JPanel
    implements PlugPanel {
        Plugable _launcher;
        JLabel _lblExec;
        JTextField _ctrlExec;

        public void prepareWith(Plugable launcher) {
            this._launcher = launcher;
            this._ctrlExec.setText(PlugableUtility.getStrOpt((Plugable)this._launcher, (String)OPT_EXEC, (String)"aralia"));
        }

        public void trash() {
        }

        public AraliaOptsPanel() {
            super(new GridBagLayout());
            this._launcher = null;
            this._lblExec = new JLabel(ResMCS.getString("DLG_ARALIA_OPT_EXEC"));
            this._ctrlExec = new JTextField(40);
            this._ctrlExec.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    AraliaOptsPanel.this._launcher.setOption(OPT_EXEC, AraliaOptsPanel.this._ctrlExec.getText());
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.add((Component)this._lblExec, new GridBagConstraints(0, 0, 1, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add((Component)this._ctrlExec, new GridBagConstraints(0, 1, 1, 1, 100.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        }

        public Component getPanel() {
            return this;
        }

        public String getInfo(String key) {
            return PluginCmdAralia.this.getInfo(key);
        }

        public Icon getIcon(String key) {
            return null;
        }
    }
}

